/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import starlogo.Application;
import starlogo.BlueGrid;
import starlogo.Interface;
import starlogo.PatchCanvas;
import starlogo.WHEnumeration;
import starlogo.Widget;
import starlogo.WidgetDrag;
import yoyo.YoYo;

public class WidgetHolder {
    Application app;
    Interface iface;
    private PatchCanvas patchcanvas;
    Widget[] toolbarwidgets = new Widget[10];
    BlueGrid bluegrid;
    private Vector widgets;
    private int selections;
    public boolean locked;
    public Object synchObject = new Object();

    public void setPatchCanvas(PatchCanvas patchCanvas) {
        this.patchcanvas = patchCanvas;
    }

    public PatchCanvas getPatchCanvas() {
        return this.patchcanvas;
    }

    public void addToolbarWidget(Widget widget) {
        int n = 0;
        while (n < this.toolbarwidgets.length) {
            if (this.toolbarwidgets[n] == null) {
                this.toolbarwidgets[n] = widget;
                return;
            }
            ++n;
        }
        this.app.err.println("Not enough toolbar widget slots!");
    }

    public int numToolbarWidgets() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.toolbarwidgets.length) {
            if (this.toolbarwidgets[n2] != null) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public void removeToolbarWidget(Widget widget) {
        int n = 0;
        while (n < this.toolbarwidgets.length) {
            if (this.toolbarwidgets[n] == widget) {
                this.toolbarwidgets[n] = null;
            }
            ++n;
        }
    }

    public void addGrid(BlueGrid blueGrid) {
        this.bluegrid = blueGrid;
    }

    public void setGrid(boolean bl) {
        if (YoYo.applet != null) {
            return;
        }
        if (bl != this.bluegrid.on) {
            this.bluegrid.on = bl;
            this.iface.addToClipRect(this.bluegrid.position);
        }
    }

    public boolean contains(Widget widget) {
        return this.widgets.indexOf(widget) != -1 || widget == this.getPatchCanvas();
    }

    public void addWidget(Widget widget) {
        if (widget.isSelected()) {
            this.incSelections();
        }
        this.widgets.addElement(widget);
    }

    public void removeWidget(Widget widget) {
        int n = this.widgets.indexOf(widget);
        if (-1 == n && !widget.equals(this.getPatchCanvas())) {
            return;
        }
        if (widget.isSelected()) {
            this.decSelections();
        }
        if (n > -1) {
            this.widgets.removeElementAt(n);
        } else {
            this.setPatchCanvas(null);
        }
    }

    public void moveToFront(Widget widget) {
        if (widget instanceof PatchCanvas) {
            return;
        }
        this.widgets.removeElement(widget);
        this.widgets.addElement(widget);
    }

    public void removeAllWidgets() {
        this.widgets.removeAllElements();
        this.selections = this.getPatchCanvas().isSelected() ? 1 : 0;
    }

    public Vector getDragWidgets() {
        Vector<Widget> vector = new Vector<Widget>();
        int n = 0;
        while (n < this.widgets.size()) {
            Widget widget = (Widget)this.widgets.elementAt(n);
            if (widget instanceof WidgetDrag) {
                vector.addElement(widget);
            }
            ++n;
        }
        return vector;
    }

    public Vector getWidgets() {
        return this.widgets;
    }

    private final void incSelections() {
        ++this.selections;
    }

    private final void decSelections() {
        --this.selections;
    }

    public void setSelected(WidgetDrag widgetDrag, boolean bl) {
        if (bl == widgetDrag.isSelected()) {
            return;
        }
        if (widgetDrag.isSelected() && !bl) {
            this.decSelections();
        }
        if (!widgetDrag.isSelected() && bl) {
            this.incSelections();
        }
        widgetDrag.setSelected(bl);
    }

    public boolean hasSelections() {
        return this.selections > 0;
    }

    public WidgetDrag[] getSelectedWidgets(boolean bl) {
        if (this.selections == 0 || !bl && this.selections == 1 && this.patchcanvas.isSelected()) {
            return null;
        }
        WidgetDrag[] widgetDragArray = null;
        widgetDragArray = this.patchcanvas.isSelected() && !bl ? new WidgetDrag[this.selections - 1] : new WidgetDrag[this.selections];
        int n = 0;
        int n2 = 0;
        while (n2 < this.widgets.size()) {
            Widget widget = (Widget)this.widgets.elementAt(n2);
            if (widget.isSelected()) {
                widgetDragArray[n++] = (WidgetDrag)widget;
            }
            ++n2;
        }
        if (n < widgetDragArray.length) {
            widgetDragArray[n++] = this.patchcanvas;
        }
        return widgetDragArray;
    }

    public Rectangle getSelectRectWithHandles() {
        Rectangle rectangle = this.getSelectRect();
        rectangle.grow(8, 8);
        return rectangle;
    }

    public Rectangle getSelectRect() {
        Rectangle rectangle = new Rectangle();
        WidgetDrag[] widgetDragArray = this.getSelectedWidgets(true);
        int n = 0;
        while (n < widgetDragArray.length) {
            rectangle = rectangle.union(widgetDragArray[n].position);
            ++n;
        }
        return rectangle;
    }

    public void clearSelections() {
        Enumeration enumeration = this.widgets.elements();
        while (enumeration.hasMoreElements()) {
            this.setSelected((WidgetDrag)enumeration.nextElement(), false);
        }
        this.setSelected(this.patchcanvas, false);
        if (this.selections != 0) {
            this.selections = 0;
        }
    }

    public Enumeration listDragWidgets() {
        return new WHEnumeration(this, "drag");
    }

    public Enumeration listAllWidgets() {
        return new WHEnumeration(this, "all");
    }

    public Enumeration listAllWidgetsTopDown() {
        return new WHEnumeration(this, "all", true);
    }

    public Enumeration listToolbars() {
        return new WHEnumeration(this, "toolbars");
    }

    public WidgetHolder(Application application, Interface interface_) {
        this(application, interface_, null);
    }

    public WidgetHolder(Application application, Interface interface_, PatchCanvas patchCanvas) {
        this.app = application;
        this.iface = interface_;
        this.widgets = new Vector();
        this.patchcanvas = patchCanvas;
        this.selections = 0;
    }
}

