/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.util.Observable;
import starlogo.ToolTipWidget;
import starlogo.WidgetOwner;
import yoyo.YoYo;

public abstract class WidgetLite
extends Observable
implements ImageObserver {
    public static Font WIDGET_FONT;
    public Rectangle position;
    public Image image;
    public WidgetOwner owner;
    protected ToolTipWidget toolTip;
    protected boolean showingToolTip = false;
    public Object toolTipLock = new Object();

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.image, this.position.x, this.position.y, this);
    }

    void mouseClicked(MouseEvent mouseEvent) {
    }

    void mouseDoubleClicked(MouseEvent mouseEvent) {
    }

    void mousePressed(MouseEvent mouseEvent) {
    }

    void mouseDragged(MouseEvent mouseEvent) {
    }

    void keyTyped(char c) {
    }

    void mouseReleased(MouseEvent mouseEvent) {
    }

    public void setLocation(int n, int n2) {
        this.position.x = n;
        this.position.y = n2;
    }

    public void setLocation(Point point) {
        this.position.setLocation(point);
    }

    public Point getLocation() {
        return this.position.getLocation();
    }

    public void setSize(int n, int n2) {
        this.position.width = n;
        this.position.height = n2;
    }

    public boolean contains(int n, int n2) {
        return this.position.contains(n, n2);
    }

    public boolean intersects(Rectangle rectangle) {
        return this.position.intersects(rectangle);
    }

    public void update() {
    }

    public String getSaveString(boolean bl) throws IOException {
        return "";
    }

    public boolean isSelected() {
        return false;
    }

    public void delete() {
        this.removeToolTip();
    }

    public ToolTipWidget getToolTip() {
        return this.toolTip;
    }

    public String getToolText() {
        String string = null;
        if (this.toolTip != null) {
            string = this.toolTip.getText();
        }
        return string;
    }

    public String getToolTipSaveString() {
        String string = new String();
        if (this.toolTip != null) {
            string = this.toolTip.getSaveString();
        }
        return string;
    }

    public void setToolTip(ToolTipWidget toolTipWidget) {
        Object object = this.toolTipLock;
        synchronized (object) {
            this.dropToolTip();
            this.toolTip = toolTipWidget;
        }
    }

    public void removeToolTip() {
        Object object = this.toolTipLock;
        synchronized (object) {
            this.dropToolTip();
            this.toolTip = null;
        }
    }

    public void displayToolTip(Point point) {
        Object object = this.toolTipLock;
        synchronized (object) {
            if (this.toolTip != null && !this.showingToolTip && this.owner != null) {
                this.toolTip.setPosition(this.position);
                this.owner.setTooltipWidget(this.toolTip);
                this.showingToolTip = true;
                this.owner.repaint(this.toolTip.position);
            }
        }
    }

    public void dropToolTip() {
        if (this.toolTip != null && this.showingToolTip && this.owner != null) {
            this.showingToolTip = false;
            this.owner.setTooltipWidget(null);
            this.owner.repaint(this.toolTip.position);
        }
    }

    public WidgetLite() {
        this.position = new Rectangle(0, 0, 0, 0);
    }

    public WidgetLite(WidgetOwner widgetOwner) {
        this.owner = widgetOwner;
        this.position = new Rectangle(0, 0, 0, 0);
    }

    public WidgetLite(WidgetOwner widgetOwner, Image image) {
        this.owner = widgetOwner;
        this.position = new Rectangle(0, 0, 0, 0);
    }

    static {
        try {
            WIDGET_FONT = System.getProperty("java.vendor").toLowerCase().indexOf("microsoft") != -1 ? new Font("SansSerif", 0, 10) : new Font("Dialog", 0, 10);
            if (YoYo.macintoshp) {
                WIDGET_FONT = Font.getFont("starlogo.widget.font", WIDGET_FONT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

