/*
 * Decompiled with CFR 0.152.
 */
package template;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import template.BaseFunc;
import template.BreedFuncs;
import template.Util;
import template.turtleFuncs.Custom;

public class BreedProps
extends JPanel
implements ActionListener,
ListSelectionListener {
    static String noFunctions = "<no functions>";
    Collection commands = new ArrayList();
    Collection functions = new ArrayList();
    DefaultListModel fdModel = new DefaultListModel();
    JList functionsDefined = new JList(this.fdModel);
    String name;
    JLabel title;
    boolean firstTime = true;
    BaseFunc[] possibleFunctions;
    JButton editFunction = new JButton("Edit Function");
    JButton newFunction = new JButton("New");
    JButton removeFunction = new JButton("Remove");
    JButton describeFunction = new JButton("Describe");
    final String editCommand;
    final String newCommand;
    final String removeCommand;
    final String listCommand;
    final String describeCommand;
    BreedFuncs funcs;
    JPanel subPanel = new JPanel();
    boolean enabled = false;

    public boolean addFunc(BaseFunc baseFunc) {
        if (this.firstTime) {
            this.fdModel.removeElement(noFunctions);
            this.firstTime = false;
            this.editFunction.setEnabled(true);
        }
        if (!this.functions.contains(baseFunc)) {
            this.functions.add(baseFunc);
            this.fdModel.addElement(baseFunc);
            this.functionsDefined.setSelectedIndex(this.fdModel.indexOf(baseFunc));
        }
        return true;
    }

    public void setPossibleFuncs(BaseFunc[] baseFuncArray) {
        this.possibleFunctions = baseFuncArray;
    }

    public void removeFunc(BaseFunc baseFunc) {
        if (this.fdModel.contains(baseFunc)) {
            int n = this.functionsDefined.getSelectedIndex();
            if (n < 1) {
                n = 1;
            }
            this.fdModel.removeElement(baseFunc);
            this.functionsDefined.setSelectedIndex(n - 1);
        }
        if (this.functions.contains(baseFunc)) {
            this.functions.remove(baseFunc);
        }
    }

    public void removeAll() {
        this.fdModel.clear();
        this.functions.clear();
    }

    public boolean contains(BaseFunc baseFunc) {
        return this.functions.contains(baseFunc);
    }

    public BaseFunc[] getDefinedFuncs() {
        if (this.functions.isEmpty()) {
            return null;
        }
        return (BaseFunc[])this.functions.toArray(new BaseFunc[0]);
    }

    public String[] getFuncNamesDefined() {
        BaseFunc[] baseFuncArray = this.getDefinedFuncs();
        if (baseFuncArray == null) {
            return null;
        }
        String[] stringArray = new String[baseFuncArray.length];
        int n = 0;
        while (n < baseFuncArray.length) {
            stringArray[n] = baseFuncArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    public BaseFunc getSelectedFunction() {
        if (this.functionsDefined.getSelectedIndex() < 0) {
            return null;
        }
        Object e = this.fdModel.elementAt(this.functionsDefined.getSelectedIndex());
        if (!(e instanceof BaseFunc)) {
            return null;
        }
        return (BaseFunc)e;
    }

    public void enable() {
        this.enabled = true;
    }

    public void updateCustoms() {
        boolean bl = false;
        boolean bl2 = false;
        BaseFunc[] baseFuncArray = this.getDefinedFuncs();
        int n = 0;
        while (n < baseFuncArray.length) {
            if (baseFuncArray[n] instanceof Custom) {
                bl = true;
                if (!((Custom)baseFuncArray[n]).isChanged()) {
                    if (bl2) {
                        this.removeFunc(baseFuncArray[n]);
                        this.funcs.remove(baseFuncArray[n]);
                    } else {
                        bl2 = true;
                    }
                } else {
                    Custom custom = new Custom(this.funcs.t.breeds);
                    Util.replaceFirst(this.possibleFunctions, baseFuncArray[n], custom);
                    this.funcs.add(custom);
                }
            }
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.enabled) {
            return;
        }
        String string = actionEvent.getActionCommand();
        if (string == "edit function") {
            this.editListen();
        } else if (string == "new function") {
            this.newListen();
        } else if (string == "remove function") {
            this.removeListen();
        } else if (string == "describe command") {
            this.describeListen();
        }
    }

    protected void editListen() {
        if (this.firstTime) {
            JOptionPane.showMessageDialog(this, "You must create a new function first", "Edit Function", 0);
            return;
        }
        if (this.fdModel.getSize() > 0) {
            this.funcs.show(this.getSelectedFunction());
        }
        this.updateCustoms();
    }

    protected void newListen() {
        if (this.possibleFunctions == null || this.possibleFunctions.length < 1) {
            JOptionPane.showMessageDialog(this, "This Template has no functions defined for " + this.funcs.getBreed(), "Nothing to do", 0);
            return;
        }
        BaseFunc baseFunc = (BaseFunc)JOptionPane.showInputDialog(this, "Choose a new Function to make", "New Function", 1, null, this.possibleFunctions, this.possibleFunctions[0]);
        if (baseFunc == null) {
            return;
        }
        if (this.funcs == null) {
            System.out.println("funcs == null");
        }
        this.addFunc(baseFunc);
        this.funcs.t.app.project.markChanged();
    }

    protected void removeListen() {
        BaseFunc baseFunc = this.getSelectedFunction();
        int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to remove the function \"" + baseFunc.getName() + "\"", "Remove Function", 0);
        if (n == 0) {
            this.removeFunc(baseFunc);
        }
    }

    protected void describeListen() {
        BaseFunc baseFunc = this.getSelectedFunction();
        if (baseFunc == null) {
            return;
        }
        JOptionPane.showMessageDialog(this, baseFunc.describe(), baseFunc.getName() + " description", 1);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.functionsDefined == null) {
            return;
        }
        BaseFunc baseFunc = this.getSelectedFunction();
        if (baseFunc == null) {
            return;
        }
        if (baseFunc.isPredefined()) {
            this.removeFunction.setEnabled(false);
        } else {
            this.removeFunction.setEnabled(true);
        }
        this.functionsDefined.ensureIndexIsVisible(this.functionsDefined.getSelectedIndex());
        this.editListen();
    }

    public BreedProps(String string, BreedFuncs breedFuncs) {
        Object object;
        this.editCommand = "edit function";
        this.newCommand = "new function";
        this.removeCommand = "remove function";
        this.listCommand = "list command";
        this.describeCommand = "describe command";
        this.name = string;
        this.funcs = breedFuncs;
        if (this.name.startsWith("<")) {
            object = this.name.trim();
            object = ((String)object).substring(0, ((String)object).length() - 1);
            this.title = new JLabel((String)object + " definitions>");
        } else {
            this.title = new JLabel(this.name + " define");
        }
        object = this.title.getFont();
        this.title.setFont(new Font(((Font)object).getName(), 1, ((Font)object).getSize()));
        this.functionsDefined.setSelectionMode(0);
        this.functionsDefined.setVisibleRowCount(6);
        this.title.setAlignmentX(0.5f);
        this.newFunction.setAlignmentX(0.5f);
        this.subPanel.setLayout(new BoxLayout(this.subPanel, 0));
        this.subPanel.add(this.newFunction);
        this.subPanel.add(Box.createHorizontalStrut(5));
        this.subPanel.add(this.removeFunction);
        this.subPanel.add(Box.createHorizontalStrut(5));
        this.subPanel.add(this.describeFunction);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Breed functions"), BorderFactory.createEmptyBorder(5, 15, 5, 15)));
        this.add(this.title);
        this.add(Box.createVerticalStrut(5));
        this.add(new JScrollPane(this.functionsDefined));
        this.add(Box.createVerticalStrut(5));
        this.add(this.subPanel);
        this.fdModel.addElement(noFunctions);
        this.editFunction.setEnabled(false);
        this.removeFunction.setEnabled(false);
        this.editFunction.setActionCommand("edit function");
        this.editFunction.addActionListener(this);
        this.newFunction.setActionCommand("new function");
        this.newFunction.addActionListener(this);
        this.removeFunction.setActionCommand("remove function");
        this.removeFunction.addActionListener(this);
        this.describeFunction.setActionCommand("describe command");
        this.describeFunction.addActionListener(this);
        this.functionsDefined.addListSelectionListener(this);
    }
}

