/*
 * Decompiled with CFR 0.152.
 */
package template;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import starlogo.Application;
import template.BaseFunc;
import template.BreedFuncs;
import template.BreedProps;
import template.ButtonInfo;
import template.ObsFuncs;
import template.SliderInfo;
import template.Util;

public class Template
extends JFrame
implements ActionListener,
ListSelectionListener,
CaretListener {
    public static String templateWord = "`template`";
    public Map allBreedFuncs = new HashMap();
    public Collection breeds = new ArrayList();
    public BreedFuncs funcs;
    public BreedProps props;
    protected DefaultListModel blModel = new DefaultListModel();
    protected JList breedList = new JList(this.blModel);
    protected JTextField breedBox = new JTextField(10);
    JButton makeBreed = new JButton("Add breed");
    JButton removeBreedButton = new JButton("Remove");
    JButton renameBreedButton = new JButton("Rename");
    JButton done = new JButton("Done");
    JButton clearButton = new JButton("Clear");
    JPanel menu = new JPanel();
    JPanel breedPanel = new JPanel();
    JPanel outerBreedPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JPanel leftPanel = new JPanel();
    JPanel topButtonPanel = new JPanel();
    Container CP;
    final String removeBreedCommand;
    final String makeBreedCommand;
    final String doneCommand;
    final String clearCommand;
    final String renameCommand;
    public final String DEFAULT;
    public final String OBSERVER;
    public Application app;

    protected void setup() {
        this.CP = this.getContentPane();
        this.CP.setLayout(new BoxLayout(this.CP, 0));
        this.setTitle("StarLogo Template");
        this.breedList.addListSelectionListener(this);
        this.breedList.setSelectionMode(0);
        this.breedList.setVisibleRowCount(6);
        this.removeBreedButton.setActionCommand("remove");
        this.removeBreedButton.addActionListener(this);
        this.removeBreedButton.setEnabled(false);
        this.makeBreed.setActionCommand("make breed");
        this.makeBreed.addActionListener(this);
        this.makeBreed.setEnabled(false);
        this.breedBox.setActionCommand("make breed");
        this.breedBox.addActionListener(this);
        this.breedBox.addCaretListener(this);
        this.clearButton.setActionCommand("clear");
        this.clearButton.addActionListener(this);
        this.renameBreedButton.setActionCommand("rename");
        this.renameBreedButton.addActionListener(this);
        this.addFirstBreeds();
        this.breedList.setSelectedIndex(0);
        this.props = this.funcs.getProps();
        int n = this.breedBox.getFont().getSize() + 10;
        this.breedBox.setMaximumSize(new Dimension(this.breedBox.getMaximumSize().width, n));
        this.breedPanel.add(this.breedBox);
        this.breedPanel.add(this.makeBreed);
        this.done.setActionCommand("done");
        this.done.addActionListener(this);
        this.breedPanel.setAlignmentX(0.5f);
        this.done.setAlignmentX(0.5f);
        this.removeBreedButton.setAlignmentX(0.5f);
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.buttonPanel.add(this.clearButton);
        this.buttonPanel.add(this.done);
        this.topButtonPanel.setLayout(new BoxLayout(this.topButtonPanel, 0));
        this.topButtonPanel.add(this.removeBreedButton);
        this.topButtonPanel.add(this.renameBreedButton);
        this.outerBreedPanel.setLayout(new BoxLayout(this.outerBreedPanel, 1));
        this.outerBreedPanel.add(this.breedPanel);
        this.outerBreedPanel.add(new JScrollPane(this.breedList));
        this.outerBreedPanel.add(this.topButtonPanel);
        this.outerBreedPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Breeds"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.leftPanel.setLayout(new BoxLayout(this.leftPanel, 1));
        this.leftPanel.add(this.outerBreedPanel);
        this.leftPanel.add(this.props);
        this.leftPanel.add(this.buttonPanel);
        this.CP.add(this.leftPanel);
        this.CP.add(this.funcs);
        this.pack();
        ((Component)this).setSize(this.getSize().width + 30, this.getSize().height);
    }

    protected void addFirstBreeds() {
        this.addBreed("<default>", false);
        this.addBreed(new ObsFuncs(this), false);
    }

    public void addBreed(String string) {
        this.addBreed(string, true);
    }

    public void addBreed(String string, boolean bl) {
        this.addBreed(new BreedFuncs(string, this), bl);
    }

    public void addBreed(BreedFuncs breedFuncs, boolean bl) {
        this.allBreedFuncs.put(breedFuncs.getBreed(), breedFuncs);
        this.funcs = breedFuncs;
        this.blModel.addElement(breedFuncs.getBreed());
        if (bl) {
            this.breeds.add(breedFuncs.getBreed());
        }
    }

    public BreedFuncs selectFuncs(String string) {
        return (BreedFuncs)this.allBreedFuncs.get(string);
    }

    public BreedProps selectProps(String string) {
        BreedFuncs breedFuncs = this.selectFuncs(string);
        if (breedFuncs != null) {
            return breedFuncs.getProps();
        }
        return null;
    }

    public BreedFuncs[] getAllFuncs() {
        return (BreedFuncs[])this.allBreedFuncs.values().toArray(new BreedFuncs[0]);
    }

    public String getSelectedBreed() {
        if (this.breedList.getSelectedIndex() < 0) {
            return null;
        }
        return (String)this.blModel.elementAt(this.breedList.getSelectedIndex());
    }

    public void updateBreeds() {
        Iterator iterator = this.allBreedFuncs.values().iterator();
        while (iterator.hasNext()) {
            ((BreedFuncs)iterator.next()).updateFuncBreeds();
        }
    }

    public void removeAllFuncs() {
        this.allBreedFuncs.clear();
        this.blModel.clear();
        this.breeds.clear();
    }

    public static void restart(Application application) {
        application.theTemplate.removeAllFuncs();
        application.theTemplate.addFirstBreeds();
    }

    public String writeWander() {
        return this.writeWander(null);
    }

    public String writeWander(String string) {
        int n;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        BaseFunc[] baseFuncArray = this.selectFuncs("<default>").getDefinedFuncs();
        ArrayList arrayList = new ArrayList();
        String string6 = "-";
        String[] stringArray = (String[])this.breeds.toArray(new String[0]);
        int n2 = 0;
        while (n2 < stringArray.length) {
            string3 = string3 + stringArray[n2] + " ";
            ++n2;
        }
        if (!string3.equals("")) {
            string2 = string2 + "breeds [ " + string3 + "]\n\n";
        }
        string2 = string2 + "to wander";
        if (baseFuncArray != null) {
            n = 0;
            while (n < baseFuncArray.length) {
                if (baseFuncArray[n].isInWander()) {
                    string4 = string4 + baseFuncArray[n].getCommand() + "\n    ";
                }
                arrayList.add(baseFuncArray[n]);
                ++n;
            }
        }
        if (!string4.equals("")) {
            string5 = string5 + "\n  if breed = 0\n    [" + string4 + "]";
        }
        n = 0;
        while (n < stringArray.length) {
            BreedFuncs breedFuncs;
            BaseFunc[] baseFuncArray2;
            if (!stringArray[n].startsWith("<") && (baseFuncArray2 = (breedFuncs = this.selectFuncs(stringArray[n])).getDefinedFuncs()) != null && (baseFuncArray2.length != 1 || baseFuncArray2[0].isInWander())) {
                string5 = string5 + "\n  if (breed = " + stringArray[n] + ")\n    [";
                int n3 = 0;
                while (n3 < baseFuncArray2.length) {
                    if (baseFuncArray2[n3].isInWander()) {
                        string5 = string5 + baseFuncArray2[n3].getCommand() + string6 + stringArray[n] + "\n    ";
                    }
                    ++n3;
                }
                string5 = string5 + "]";
            }
            ++n;
        }
        string2 = string5.equals("") ? string2 + "\n  ;this function is empty\n  ;the wander button will not do anything" : string2 + string5;
        string2 = string2 + "\nend\n";
        return string2;
    }

    public String writeWanderButton() {
        ButtonInfo buttonInfo = new ButtonInfo(true, "wander", true);
        String string = buttonInfo.writeButton();
        ButtonInfo.y += 40;
        SliderInfo.y += 40;
        ++ButtonInfo.buttons;
        return string;
    }

    public String templateType() {
        return "hard-coded ecology";
    }

    public String save() {
        String string = templateWord + "\n" + this.templateType() + "\n";
        BreedFuncs[] breedFuncsArray = this.getAllFuncs();
        if (breedFuncsArray == null) {
            return string;
        }
        int n = 0;
        while (n < breedFuncsArray.length) {
            string = string + breedFuncsArray[n].save() + "\n";
            ++n;
        }
        return string;
    }

    public boolean load(String string) {
        try {
            int n = string.indexOf(templateWord) + templateWord.length() + 1;
            int n2 = string.indexOf("`", n);
            if (n2 == -1) {
                n2 = string.length();
            }
            if ((string = string.substring(n, n2)).indexOf(this.templateType()) != 0) {
                return false;
            }
            string = string.substring(string.indexOf(this.templateType()) + this.templateType().length());
        }
        catch (Exception exception) {
            return false;
        }
        String[] stringArray = Util.split(string, "\n" + BreedFuncs.breedFuncsWord + " ");
        boolean bl = true;
        Template.restart(this.app);
        int n = 0;
        while (n < stringArray.length) {
            int n3 = stringArray[n].indexOf("\n");
            String string2 = stringArray[n].substring(0, n3);
            stringArray[n] = stringArray[n].substring(n3);
            BreedFuncs breedFuncs = this.selectFuncs(string2);
            if (breedFuncs == null) {
                this.addBreed(string2);
                breedFuncs = this.funcs;
                this.updateBreeds();
            }
            boolean bl2 = breedFuncs.load(stringArray[n]);
            this.breedList.setSelectedIndex(this.blModel.indexOf(string2));
            bl = bl && bl2;
            ++n;
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "remove") {
            this.removeBreedListen();
        } else if (string == "make breed") {
            this.makeBreedListen();
        } else if (string == "done") {
            this.doneListen();
        } else if (string == "clear") {
            this.clearListen();
        } else if (string == "rename") {
            this.renameListen();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.CP.removeAll();
        this.funcs = this.selectFuncs(this.getSelectedBreed());
        if (this.funcs == null) {
            return;
        }
        if (this.props != null) {
            this.leftPanel.remove(this.props);
            this.props = this.funcs.getProps();
            this.leftPanel.add(this.props);
            this.leftPanel.add(this.buttonPanel);
        } else {
            this.props = this.funcs.getProps();
        }
        this.leftPanel.validate();
        this.leftPanel.repaint();
        if (this.funcs.getBreed().startsWith("<")) {
            this.removeBreedButton.setEnabled(false);
            this.renameBreedButton.setEnabled(false);
        } else {
            this.removeBreedButton.setEnabled(true);
            this.renameBreedButton.setEnabled(true);
        }
        this.breedList.ensureIndexIsVisible(this.breedList.getSelectedIndex());
        this.CP.add(this.leftPanel);
        this.CP.add(this.funcs);
        this.CP.validate();
        this.CP.repaint();
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (this.breedBox.getText().trim().equals("")) {
            this.makeBreed.setEnabled(false);
        } else {
            this.makeBreed.setEnabled(true);
        }
    }

    protected void removeBreedListen() {
        String string = this.getSelectedBreed();
        if (string.startsWith("<")) {
            JOptionPane.showMessageDialog(this, "You can't remove the breed " + string, "Remove Breed", 0);
            return;
        }
        int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the breed \"" + string + "\"", "Remove Breed", 0);
        if (n == 0) {
            int n2 = this.breedList.getSelectedIndex();
            if (n2 < 1) {
                n2 = 1;
            }
            this.breeds.remove(string);
            this.updateBreeds();
            this.allBreedFuncs.remove(string);
            this.blModel.removeElement(string);
            this.breedList.setSelectedIndex(n2 - 1);
        }
    }

    protected void makeBreedListen() {
        String string = this.breedBox.getText();
        if (!this.allBreedFuncs.containsKey(string) && !string.trim().equals("") && string != null) {
            this.addBreed(string);
        }
        this.breedList.setSelectedIndex(this.blModel.indexOf(string));
        this.breedBox.setText("");
        this.app.project.markChanged();
    }

    protected void renameListen() {
        String string = JOptionPane.showInputDialog(this, (Object)("Change breed \"" + this.funcs.getBreed() + "\" to: "));
        if (string == null || string.equals("")) {
            return;
        }
        String string2 = this.funcs.getBreed();
        int n = this.breedList.getSelectedIndex();
        this.funcs.setBreed(string);
        this.blModel.removeElement(string2);
        this.blModel.addElement(string);
        this.breeds.remove(string2);
        this.breeds.add(string);
        this.allBreedFuncs.remove(string2);
        this.allBreedFuncs.put(string, this.funcs);
        this.updateBreeds();
        this.breedList.setSelectedIndex(n);
    }

    protected void doneListen() {
        Iterator iterator = this.allBreedFuncs.values().iterator();
        String string = "; These functions are generated automatically\n; Any changes will be erased the next time \n; the template is run\n\n";
        String string2 = "";
        String string3 = "Java StarLogo\n1.1\n`turtle`\n";
        String string4 = "";
        String string5 = "`interface`\n";
        String string6 = "`observer`\n";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        SliderInfo.resetStatics();
        ButtonInfo.resetStatics();
        string5 = string5 + this.writeWanderButton();
        while (iterator.hasNext()) {
            BreedFuncs breedFuncs = (BreedFuncs)iterator.next();
            string7 = string7 + breedFuncs.writeFunctions(true);
            string2 = string2 + breedFuncs.writeFunctions(false);
            string5 = string5 + breedFuncs.writeSliders();
            string5 = string5 + breedFuncs.writeButtons();
            string9 = breedFuncs.writeVariables(string9, 1);
            string8 = breedFuncs.writeVariables(string8, 0);
            string10 = breedFuncs.writeVariables(string10, 2);
        }
        if (!string8.trim().equals("")) {
            string8 = "turtles-own [ " + string8 + "]\n";
        }
        if (!string9.trim().equals("")) {
            string9 = "globals [ " + string9 + "]\n";
        }
        if (!string10.trim().equals("")) {
            string10 = "patches-own [ " + string10 + "]\n";
        }
        string4 = string4 + this.writeWander();
        string2 = string + string4.trim() + "\n\n" + string2.trim() + "\n\n";
        string7 = string + string8 + string9 + string10 + "\n" + string7.trim();
        this.app.procWin.getSLProc(0).setText(string2);
        this.app.procWin.getSLProc(1).setText(string7);
        this.app.iface.loadFromString(string5.trim(), false);
        this.app.iface.repaint();
        this.app.project.compile(this.app);
    }

    protected void saveListen() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save Template as...", 1);
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 == null) {
            return;
        }
        if (string2.indexOf(".") == -1) {
            string2 = string2 + ".tem";
        }
        fileDialog.dispose();
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(new File(string, string2));
            String string3 = this.save();
            fileWriter.write(string3);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
        catch (IOException iOException) {
            System.err.println("uh oh, bad file name");
        }
    }

    protected void loadListen() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Load Template...", 1);
        fileDialog.show();
        String string = fileDialog.getDirectory();
        String string2 = fileDialog.getFile();
        if (string2 == null) {
            return;
        }
        if (string2.indexOf(".") == -1) {
            string2 = string2 + ".tem";
        }
        fileDialog.dispose();
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(new File(string, string2));
            String string3 = Util.readToString(fileReader);
            this.load(string3);
        }
        catch (IOException iOException) {
            System.err.println("uh oh, bad file name");
        }
    }

    protected void clearListen() {
        int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to start over?", "Clear Template", 0);
        if (n == 0) {
            Template.restart(this.app);
        }
    }

    protected Template() {
        this.removeBreedCommand = "remove";
        this.makeBreedCommand = "make breed";
        this.doneCommand = "done";
        this.clearCommand = "clear";
        this.renameCommand = "rename";
        this.DEFAULT = "<default>";
        this.OBSERVER = "<observer>";
    }

    protected Template(Application application) {
        this.removeBreedCommand = "remove";
        this.makeBreedCommand = "make breed";
        this.doneCommand = "done";
        this.clearCommand = "clear";
        this.renameCommand = "rename";
        this.DEFAULT = "<default>";
        this.OBSERVER = "<observer>";
        this.app = application;
    }

    static {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

