/*
 * Decompiled with CFR 0.152.
 */
package template.arguments;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Hashtable;
import com.sun.java.util.collections.Iterator;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import template.SliderInfo;
import template.Util;
import template.arguments.BaseArg;

public class SliderArg
extends BaseArg
implements ActionListener,
ChangeListener {
    JRadioButton newSlider = new JRadioButton("Create StarLogo slider");
    JRadioButton noNewSlider = new JRadioButton("Use a constant value");
    ButtonGroup bg = new ButtonGroup();
    JSlider value;
    JTextField sliderName = new JTextField(10);
    String prompt;
    JLabel info = new JLabel();
    boolean newSliderP = false;
    JPanel left = new JPanel();
    JPanel right = new JPanel();
    final String newSliderCommand;
    final String noNewSliderCommand;
    final String valueCommand;

    public void setSliderLabels(int n, int n2) {
        Hashtable hashtable = new Hashtable();
        JLabel jLabel = new JLabel("" + n);
        JLabel jLabel2 = new JLabel("" + (n + n2) / 2);
        JLabel jLabel3 = new JLabel("" + n2);
        jLabel.setFont(this.argFont);
        jLabel2.setFont(this.argFont);
        jLabel3.setFont(this.argFont);
        jLabel.setAlignmentX(1.0f);
        jLabel2.setAlignmentX(1.0f);
        jLabel3.setAlignmentX(1.0f);
        hashtable.put(new Integer(n), jLabel);
        hashtable.put(new Integer((n + n2) / 2), jLabel2);
        hashtable.put(new Integer(n2), jLabel3);
        this.value.setLabelTable(hashtable);
    }

    public String toString() {
        if (this.newSlider.isSelected() && !this.sliderName.getText().trim().equals("")) {
            return BaseArg.replace(this.sliderName.getText().trim(), " ", "-");
        }
        return "" + this.value.getValue();
    }

    public String setLabel(String string) {
        String string2 = this.getLabel();
        this.setBorder(BorderFactory.createTitledBorder(null, string, 1, 2, this.argFont));
        return string2;
    }

    public String getLabel() {
        return ((TitledBorder)this.getBorder()).getTitle();
    }

    public boolean isNewSlider() {
        return this.newSlider.isSelected() && this.isVisible();
    }

    public SliderInfo getSliderInfo() {
        if (this.newSlider.isSelected() && this.isVisible()) {
            return new SliderInfo(this.sliderName.getText(), this.value.getMinimum(), this.value.getMaximum(), this.value.getValue());
        }
        return null;
    }

    public String save() {
        String string = SliderArg.argType() + "   ";
        string = string + Util.quote(this.getLabel()) + " ";
        string = string + this.newSlider.isSelected() + " ";
        string = string + this.isVisible() + " ";
        string = string + Util.quote(this.sliderName.getText()) + " ";
        string = string + this.value.getMinimum() + " ";
        string = string + this.value.getMaximum() + " ";
        string = string + this.value.getValue() + "\n";
        return string;
    }

    public boolean load(ArrayList arrayList) {
        try {
            Iterator iterator = arrayList.iterator();
            String string = (String)iterator.next();
            if (!string.equals(SliderArg.argType())) {
                this.setLabel(string);
            } else {
                this.setLabel((String)iterator.next());
            }
            if (new Boolean((String)iterator.next()).booleanValue()) {
                this.newSlider.doClick();
            } else {
                this.noNewSlider.doClick();
            }
            this.setVisible(new Boolean((String)iterator.next()));
            this.sliderName.setText((String)iterator.next());
            this.value.setMinimum(new Integer((String)iterator.next()));
            this.value.setMaximum(new Integer((String)iterator.next()));
            this.value.setValue(new Integer((String)iterator.next()));
            this.setSliderLabels(this.value.getMinimum(), this.value.getMaximum());
            this.value.setPaintLabels(true);
            return true;
        }
        catch (Exception exception) {
            System.err.println("Error loading sliderArg: " + exception);
            return false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (this.newSlider.isSelected()) {
            this.right.setVisible(false);
            this.sliderName.setVisible(true);
        } else {
            this.sliderName.setVisible(false);
            this.right.setVisible(true);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.info.setText("" + this.value.getValue());
    }

    public static String argType() {
        return "SliderArg";
    }

    public SliderArg() {
        this(null, 0, 0);
    }

    public SliderArg(String string, int n) {
        this(string, n, n / 2);
    }

    public SliderArg(String string, int n, int n2) {
        this(string, null, 0, n2, n);
    }

    public SliderArg(String string, String string2, int n, int n2, int n3) {
        this.newSliderCommand = "new slider";
        this.noNewSliderCommand = "no new slider";
        this.valueCommand = "value";
        this.value = new JSlider(0, n, n3, n2);
        this.value.setPaintLabels(true);
        this.setSliderLabels(n, n3);
        this.sliderName.setVisible(false);
        this.prompt = string;
        this.variable = string2;
        int n4 = this.sliderName.getFont().getSize() + 10;
        this.sliderName.setMaximumSize(new Dimension(this.value.getPreferredSize().width + 45, n4));
        this.bg.add(this.newSlider);
        this.bg.add(this.noNewSlider);
        this.noNewSlider.setSelected(true);
        this.left.setLayout(new BoxLayout(this.left, 1));
        this.left.add(this.noNewSlider);
        this.left.add(this.newSlider);
        this.right.setLayout(new BoxLayout(this.right, 1));
        this.info.setAlignmentX(0.5f);
        this.right.add(this.info);
        this.right.add(this.value);
        this.info.setText("" + this.value.getValue());
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createTitledBorder(null, string, 1, 2, this.argFont));
        this.add(this.left);
        this.add(this.right);
        this.add(this.sliderName);
        this.newSlider.setActionCommand("new slider");
        this.noNewSlider.setActionCommand("no new slider");
        this.newSlider.addActionListener(this);
        this.noNewSlider.addActionListener(this);
        this.value.addChangeListener(this);
        this.newSlider.setFont(this.argFont);
        this.noNewSlider.setFont(this.argFont);
        ((JComponent)this.value).setFont(this.argFont);
        this.sliderName.setFont(this.argFont);
        this.info.setFont(this.argFont);
    }
}

