/*
 * Decompiled with CFR 0.152.
 */
package template.turtleFuncs;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import template.BaseFunc;
import template.ButtonInfo;
import template.SliderInfo;
import template.Util;

public class Custom
extends BaseFunc
implements ActionListener {
    public static String customWord = "<custom function>";
    public static String buttonWord = "Button";
    public static String sliderWord = "Slider";
    public static String nameWord = "Name";
    public static String bodyWord = "Body";
    JTextField title = new JTextField(13);
    JLabel nameLabel = new JLabel("Function name:  ");
    JLabel bodyLabel = new JLabel("Function Body:  ");
    JTextArea body = new JTextArea(15, 25);
    JPanel top = new JPanel();
    JPanel middle = new JPanel();
    JButton addSlider = new JButton("Add slider");
    JButton addButton = new JButton("Add button");
    final String offset;
    final String addSliderCommand;
    final String addButtonCommand;
    final String toBodyCommand;
    Collection sliders = new ArrayList();
    Collection buttons = new ArrayList();
    String oldName = "";

    public String getName() {
        String string = this.title.getText().trim().equals("") ? customWord : "u-" + this.title.getText();
        if (!this.oldName.equals(string)) {
            this.oldName = string;
        }
        return string;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getCommand() {
        if (this.title.getText().trim().equals("")) {
            return "custom";
        }
        return "u-" + BaseFunc.replace(this.title.getText(), " ", "-");
    }

    public String getBody() {
        String string = this.body.getText().trim();
        if (string.indexOf("\nend") != -1) {
            string = string.substring(0, string.indexOf("\nend"));
        }
        if (string.startsWith("to ")) {
            String string2 = string;
            try {
                string = string.substring(this.body.getLineEndOffset(0), string.length()) + "\nend";
            }
            catch (Exception exception) {
                System.out.println("uh oh");
                string = string2;
            }
        } else {
            string = string + "\nend";
        }
        return BaseFunc.replace(Util.indent(string, "  "), "\n  end", "\nend");
    }

    public boolean finished() {
        if (this.title.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(this, "Please name your custom function", "Naming error", 0);
            return false;
        }
        return true;
    }

    public String describe() {
        return "Write your own function here.  You don't need to include the\n\"to [function name]\", just write the body of the function.  You\ndon't need the \"end\" either.  A \"u-\" will be appended to the\nbeginning of the name you give this function.  Keep in mind that you\nwill have to append \"-<breed>\" to any other function in this model\nyou would like to call from your custom procedure, i.e. \"walk-frogs\",\nthis even applies to other custom functions, which already have the\n\"u-\" appended to the beginning of their names, i.e. \"u-jump-frogs\".";
    }

    public SliderInfo[] getSliderInfo() {
        Object[] objectArray = new SliderInfo[]{};
        return (SliderInfo[])this.sliders.toArray(objectArray);
    }

    public ButtonInfo[] getButtonInfo() {
        Object[] objectArray = new ButtonInfo[]{};
        return (ButtonInfo[])this.buttons.toArray(objectArray);
    }

    public void addButton(String string) {
        this.buttons.add(new ButtonInfo(!this.obsFuncP, string, false));
    }

    public void addSlider(String string) {
        this.sliders.add(new SliderInfo(string, 0, 99, 50));
    }

    public void setObsFunc(boolean bl) {
        this.obsFuncP = bl;
    }

    public String save() {
        String string = BaseFunc.functionWord + " " + customWord + "\n";
        string = string + nameWord + "  " + Util.quote(this.title.getText()) + "\n";
        string = string + this.saveButtons();
        string = string + this.saveSliders();
        string = string + bodyWord + "  " + Util.quote(Util.replace(this.body.getText().trim(), "\n", "\\n"));
        return string;
    }

    public String saveButtons() {
        String string = "";
        ButtonInfo[] buttonInfoArray = this.getButtonInfo();
        int n = 0;
        while (n < buttonInfoArray.length) {
            string = string + buttonWord + "  " + Util.quote(buttonInfoArray[n].lineToRun) + "\n";
            ++n;
        }
        return string;
    }

    public String saveSliders() {
        String string = "";
        SliderInfo[] sliderInfoArray = this.getSliderInfo();
        int n = 0;
        while (n < sliderInfoArray.length) {
            string = string + sliderWord + "  " + Util.quote(sliderInfoArray[n].variable) + "\n";
            ++n;
        }
        return string;
    }

    public boolean load(String string) {
        String[] stringArray = Util.split(string, "\n");
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith(nameWord)) {
                this.title.setText(Util.unquote(stringArray[n].substring(nameWord.length())).trim());
            } else if (stringArray[n].startsWith(bodyWord)) {
                String string2 = Util.unquote(stringArray[n].substring(bodyWord.length())).trim();
                this.body.setText(Util.replace(string2, "\\n", "\n"));
            } else if (stringArray[n].startsWith(buttonWord)) {
                bl &= this.loadButton(stringArray[n]);
            } else if (stringArray[n].startsWith(sliderWord)) {
                bl &= this.loadSlider(stringArray[n]);
            }
            ++n;
        }
        return bl;
    }

    public boolean loadButton(String string) {
        string = string.substring(buttonWord.length());
        this.addButton(Util.quote(string.trim()));
        return true;
    }

    public boolean loadSlider(String string) {
        string = string.substring(sliderWord.length());
        this.addSlider(Util.unquote(string.trim()));
        return true;
    }

    public boolean isChanged() {
        boolean bl = this.getName() == customWord && this.body.getText().trim().equals("");
        return !bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "add slider") {
            String string2 = JOptionPane.showInputDialog(this, "What would you like to name the\nnew slider variable?", "New Slider", -1);
            if (string2 == null) {
                return;
            }
            this.addSlider(string2);
        } else if (string == "add button") {
            String string3 = JOptionPane.showInputDialog(this, "What command would you like \nthe new button to execute?", "New Button", -1);
            if (string3 == null) {
                return;
            }
            this.addButton(string3);
        } else if (string == "to body") {
            this.body.requestFocus();
        }
    }

    static /* synthetic */ Collection access$0(Custom custom) {
        return custom.breeds;
    }

    public Custom(Collection collection) {
        this.offset = "  ";
        this.addSliderCommand = "add slider";
        this.addButtonCommand = "add button";
        this.toBodyCommand = "to body";
        this.breeds = collection;
        this.body.setLineWrap(true);
        this.top.setLayout(new BoxLayout(this.top, 0));
        this.title.setMaximumSize(new Dimension(this.title.getMaximumSize().width, this.title.getFont().getSize() + 10));
        this.title.setNextFocusableComponent(this.body);
        this.top.add(this.nameLabel);
        this.top.add(this.title);
        this.addSlider.setActionCommand("add slider");
        this.addSlider.addActionListener(this);
        this.addButton.setActionCommand("add button");
        this.addButton.addActionListener(this);
        this.title.setActionCommand("to body");
        this.title.addActionListener(this);
        this.middle.setLayout(new BoxLayout(this.middle, 0));
        this.middle.add(this.addSlider);
        this.middle.add(this.addButton);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.top);
        this.add(Box.createVerticalStrut(10));
        this.add(this.middle);
        this.add(Box.createVerticalStrut(10));
        this.add(this.bodyLabel);
        this.add(new JScrollPane(this.body));
        this.add(Box.createVerticalGlue());
    }
}

