/*
 * Decompiled with CFR 0.152.
 */
package yoyo;

import java.util.Vector;
import yoyo.Context;
import yoyo.LocalRef;
import yoyo.LogoError;
import yoyo.PrimMath;
import yoyo.Primitive;
import yoyo.Reader;
import yoyo.Symbol;
import yoyo.YoYo;
import yoyo.YoYoMethods;

public class PrimList
implements YoYoMethods {
    public String[] methodList() {
        String[] stringArray = new String[]{"list", "prim_list", "make-list", "prim_makelist", "sentence", "prim_sentence", "se", "prim_sentence", "fput", "prim_fput", "lput", "prim_lput", "butfirst", "prim_butfirst", "bf", "prim_butfirst", "butlast", "prim_butlast", "bl", "prim_butlast", "first", "prim_first", "last", "prim_last", "item", "prim_item", "pick", "prim_random_item", "setitem", "prim_setitem", "insert", "prim_insert", "remove", "prim_remove", "remove-element", "prim_removeele", "nth", "prim_nth", "setnth", "prim_setnth", "length", "prim_length", "word", "prim_word", "position", "prim_position", "member?", "prim_memberp", "empty?", "prim_emptyp", "list?", "prim_listp", "string?", "prim_wordp", "substring", "prim_substring", "sublist", "prim_sublist", "copy-list", "prim_copylist", "string-to-list", "prim_wordtolist", "list-to-string", "prim_listtoword", "sort-num-list", "prim_sortnumlist", "min-of-list", "prim_listmin", "max-of-list", "prim_listmax", "median-of-list", "prim_listmedian", "average-of-list", "prim_listmean", "variance-of-list", "prim_listvariance", "sdev-of-list", "prim_listsdev", "mode-of-list", "prim_listmode", "dolist", "prim_dolist", "to-list", "prim_to_list", "replace", "prim_replace", "starts-with", "prim_startswith", "ends-with", "prim_endswith", "starts-with-ignore-case", "prim_startswithnocase", "ends-with-ignore-case", "prim_endswithnocase", "equals-ignore-case", "prim_equalsnocase", "trim", "prim_trim", "reverse", "prim_reverse"};
        return stringArray;
    }

    public String[] infixList() {
        return null;
    }

    public void prePrimCall(Primitive primitive, Object[] objectArray, Context context) {
    }

    public void postPrimCall(Primitive primitive, Context context) {
    }

    public static Object prim_list(Object object, Object object2, Context context) {
        Object[] objectArray = new Object[]{object, object2};
        return objectArray;
    }

    public static Object prim_makelist(Object object, Object object2, Context context) {
        int n = YoYo.aInteger(context, object);
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = object2;
            ++n2;
        }
        return objectArray;
    }

    public static Object prim_sentence(Object object, Object object2, Context context) {
        if (object instanceof Object[]) {
            int n = ((Object[])object).length;
            if (object2 instanceof Object[]) {
                int n2 = ((Object[])object2).length;
                Object[] objectArray = new Object[n + n2];
                System.arraycopy((Object[])object, 0, objectArray, 0, n);
                System.arraycopy((Object[])object2, 0, objectArray, n, n2);
                return objectArray;
            }
            Object[] objectArray = new Object[n + 1];
            System.arraycopy((Object[])object, 0, objectArray, 0, n);
            objectArray[n] = object2;
            return objectArray;
        }
        if (object2 instanceof Object[]) {
            int n = ((Object[])object2).length;
            Object[] objectArray = new Object[n + 1];
            System.arraycopy((Object[])object2, 0, objectArray, 1, n);
            objectArray[0] = object;
            return objectArray;
        }
        Object[] objectArray = new Object[]{object, object2};
        return objectArray;
    }

    public static Object prim_fput(Object object, Object object2, Context context) {
        if (object2 instanceof Object[]) {
            Object[] objectArray = new Object[((Object[])object2).length + 1];
            System.arraycopy((Object[])object2, 0, objectArray, 1, objectArray.length - 1);
            objectArray[0] = object;
            return objectArray;
        }
        if (object2 instanceof Symbol || object2 instanceof String) {
            String string = YoYo.aString(context, object);
            String string2 = YoYo.aString(context, object2);
            return string + string2;
        }
        LogoError.error(YoYo.printToString(object) + " and/or " + YoYo.printToString(object2) + " is not a list or a string", context);
        return null;
    }

    public static Object prim_lput(Object object, Object object2, Context context) {
        if (object2 instanceof Object[]) {
            Object[] objectArray = new Object[((Object[])object2).length + 1];
            System.arraycopy((Object[])object2, 0, objectArray, 0, objectArray.length - 1);
            objectArray[objectArray.length - 1] = object;
            return objectArray;
        }
        if (object2 instanceof Symbol || object2 instanceof String) {
            String string = YoYo.aString(context, object);
            String string2 = YoYo.aString(context, object2);
            return string + string2;
        }
        LogoError.error(YoYo.printToString(object) + " and/or " + YoYo.printToString(object2) + " is not a list or a string", context);
        return null;
    }

    public static Object prim_butfirst(Object object, Context context) {
        if (object instanceof Object[]) {
            if (((Object[])object).length == 0) {
                LogoError.error("can't take the butfirst of an empty list", context);
            }
            Object[] objectArray = new Object[((Object[])object).length - 1];
            System.arraycopy((Object[])object, 1, objectArray, 0, objectArray.length);
            return objectArray;
        }
        if (object instanceof String || object instanceof Symbol) {
            String string = YoYo.aString(context, object);
            return string.substring(1);
        }
        LogoError.error(YoYo.printToString(object) + " is not a list or a string", context);
        return null;
    }

    public static Object prim_butlast(Object object, Context context) {
        if (object instanceof Object[]) {
            if (((Object[])object).length == 0) {
                LogoError.error("can't take the butlast of an empty list", context);
            }
            Object[] objectArray = new Object[((Object[])object).length - 1];
            System.arraycopy((Object[])object, 0, objectArray, 0, objectArray.length);
            return objectArray;
        }
        if (object instanceof String || object instanceof Symbol) {
            String string = YoYo.aString(context, object);
            return string.substring(0, string.length() - 1);
        }
        LogoError.error(YoYo.printToString(object) + " is not a list or a string", context);
        return null;
    }

    public static Object prim_first(Object object, Context context) {
        block7: {
            if (object instanceof Object[]) {
                try {
                    return ((Object[])object)[0];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (((Object[])object).length == 0) {
                        LogoError.error("can't take the first of an empty list", context);
                    }
                    break block7;
                }
            }
            if (object instanceof String || object instanceof Symbol) {
                String string = YoYo.aString(context, object);
                try {
                    return String.valueOf(string.charAt(0));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    if (string.length() != 0) break block7;
                    LogoError.error("can't take the first of an empty string", context);
                }
            }
        }
        LogoError.error(YoYo.printToString(object) + " is not a list or a string", context);
        return null;
    }

    public static Object prim_last(Object object, Context context) {
        block7: {
            if (object instanceof Object[]) {
                try {
                    return ((Object[])object)[((Object[])object).length - 1];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (((Object[])object).length == 0) {
                        LogoError.error("can't take the last of an empty list", context);
                    }
                    break block7;
                }
            }
            if (object instanceof String || object instanceof Symbol) {
                String string = YoYo.aString(context, object);
                try {
                    return String.valueOf(string.charAt(string.length() - 1));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    if (string.length() != 0) break block7;
                    LogoError.error("can't take the last of an empty string", context);
                }
            }
        }
        LogoError.error(YoYo.printToString(object) + " is not a list or a string", context);
        return null;
    }

    public static Object prim_random_item(Object object, Context context) {
        if (object instanceof Object[]) {
            if (((Object[])object).length == 0) {
                LogoError.error("can't pick an element from an empty list", context);
            }
            int n = (int)Math.floor(PrimMath.random.nextDouble() * (double)((Object[])object).length);
            return ((Object[])object)[n];
        }
        if (object instanceof String || object instanceof Symbol) {
            String string = YoYo.aString(context, object);
            int n = (int)Math.floor(PrimMath.random.nextDouble() * (double)string.length());
            return String.valueOf(string.charAt(n));
        }
        LogoError.error(YoYo.printToString(object) + " is not a list or a string", context);
        return null;
    }

    public static Object prim_item(Object object, Object object2, Context context) {
        block9: {
            if (object2 instanceof Object[]) {
                int n = YoYo.aInteger(context, object);
                try {
                    return ((Object[])object2)[n - 1];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (n < 1) {
                        LogoError.error("index is too low", context);
                    }
                    if (n > ((Object[])object2).length) {
                        LogoError.error("index is too high", context);
                    }
                    break block9;
                }
            }
            if (object2 instanceof String || object2 instanceof Symbol) {
                String string = YoYo.aString(context, object2);
                int n = YoYo.aInteger(context, object);
                try {
                    return String.valueOf(string.charAt(n - 1));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    if (n < 1) {
                        LogoError.error("index is too low", context);
                    }
                    if (n <= string.length()) break block9;
                    LogoError.error("index is too high", context);
                }
            }
        }
        LogoError.error(YoYo.printToString(object2) + " is not a list or a string", context);
        return null;
    }

    public static void prim_setitem(Object object, Object object2, Object object3, Context context) {
        if (object2 instanceof Object[]) {
            block7: {
                int n = YoYo.aInteger(context, object);
                try {
                    Object object4 = object2;
                    synchronized (object4) {
                        ((Object[])object2)[n - 1] = object3;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (n < 1) {
                        LogoError.error("index: " + n + " is too low", context);
                    }
                    if (n <= ((Object[])object2).length) break block7;
                    LogoError.error("index: " + n + " is too high", context);
                }
            }
            return;
        }
        LogoError.error(YoYo.printToString(object2) + " is not a list", context);
    }

    public static Object prim_insert(Object object, Object object2, Object object3, Context context) {
        if (object2 instanceof Object[]) {
            Object[] objectArray;
            block4: {
                Object[] objectArray2 = (Object[])object2;
                int n = YoYo.aInteger(context, object);
                objectArray = new Object[objectArray2.length + 1];
                try {
                    System.arraycopy(objectArray2, 0, objectArray, 0, n - 1);
                    objectArray[n - 1] = object3;
                    System.arraycopy(objectArray2, n - 1, objectArray, n, objectArray2.length - n + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (n < 1) {
                        LogoError.error("index: " + n + " is too low", context);
                    }
                    if (n <= objectArray2.length) break block4;
                    LogoError.error("index: " + n + " is too high", context);
                }
            }
            return objectArray;
        }
        LogoError.error(YoYo.printToString(object2) + " is not a list", context);
        return null;
    }

    public static Object prim_remove(Object object, Object object2, Context context) {
        if (object2 instanceof Object[]) {
            Object[] objectArray;
            block4: {
                Object[] objectArray2 = (Object[])object2;
                int n = YoYo.aInteger(context, object);
                objectArray = new Object[objectArray2.length - 1];
                try {
                    System.arraycopy(objectArray2, 0, objectArray, 0, n - 1);
                    System.arraycopy(objectArray2, n, objectArray, n - 1, objectArray2.length - n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (n < 1) {
                        LogoError.error("index: " + n + " is too low", context);
                    }
                    if (n <= objectArray2.length) break block4;
                    LogoError.error("index: " + n + " is too high", context);
                }
            }
            return objectArray;
        }
        LogoError.error(YoYo.printToString(object2) + " is not a list", context);
        return null;
    }

    public static Object prim_removeele(Object object, Object object2, Context context) {
        if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            Object[] objectArray2 = new Object[objectArray.length];
            int n = 0;
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (YoYo.equal(objectArray[n2], object) == YoYo.symfalse) {
                    objectArray2[n++] = objectArray[n2];
                }
                ++n2;
            }
            Object[] objectArray3 = new Object[n];
            System.arraycopy(objectArray2, 0, objectArray3, 0, n);
            return objectArray3;
        }
        LogoError.error(YoYo.printToString(object2) + " is not a list", context);
        return null;
    }

    public static Object prim_nth(Object object, Object object2, Context context) {
        block9: {
            if (object2 instanceof Object[]) {
                int n = YoYo.aInteger(context, object);
                try {
                    return ((Object[])object2)[n];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (n < 0) {
                        LogoError.error("index is too low", context);
                    }
                    if (n >= ((Object[])object2).length) {
                        LogoError.error("index is too high", context);
                    }
                    break block9;
                }
            }
            if (object2 instanceof String || object2 instanceof Symbol) {
                String string = YoYo.aString(context, object2);
                int n = YoYo.aInteger(context, object);
                try {
                    return String.valueOf(string.charAt(n));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    if (n < 0) {
                        LogoError.error("index is too low", context);
                    }
                    if (n < string.length()) break block9;
                    LogoError.error("index is too high", context);
                }
            }
        }
        LogoError.error(YoYo.printToString(object2) + " is not a list or a string", context);
        return null;
    }

    public static void prim_setnth(Object object, Object object2, Object object3, Context context) {
        if (object2 instanceof Object[]) {
            block7: {
                int n = YoYo.aInteger(context, object);
                try {
                    Object object4 = object2;
                    synchronized (object4) {
                        ((Object[])object2)[n] = object3;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (n < 0) {
                        LogoError.error("index: " + n + " is too low", context);
                    }
                    if (n < ((Object[])object2).length) break block7;
                    LogoError.error("index: " + n + " is too high", context);
                }
            }
            return;
        }
        LogoError.error(YoYo.printToString(object2) + " is not a list", context);
    }

    public static Object prim_length(Object object, Context context) {
        if (object instanceof Object[]) {
            return new Integer(((Object[])object).length);
        }
        if (object instanceof String || object instanceof Symbol) {
            return new Integer(YoYo.aString(context, object).length());
        }
        LogoError.error(YoYo.printToString(object) + " is not a list or a string", context);
        return null;
    }

    public static Object prim_startswith(Object object, Object object2, Context context) {
        String string;
        String string2 = YoYo.aString(context, object);
        if (string2.startsWith(string = YoYo.aString(context, object2))) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }

    public static Object prim_endswith(Object object, Object object2, Context context) {
        String string;
        String string2 = YoYo.aString(context, object);
        if (string2.endsWith(string = YoYo.aString(context, object2))) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }

    public static Object prim_startswithnocase(Object object, Object object2, Context context) {
        String string = YoYo.aString(context, object);
        String string2 = YoYo.aString(context, object2);
        if (string.toLowerCase().startsWith(string2.toLowerCase())) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }

    public static Object prim_endswithnocase(Object object, Object object2, Context context) {
        String string = YoYo.aString(context, object);
        String string2 = YoYo.aString(context, object2);
        if (string.toLowerCase().endsWith(string2.toLowerCase())) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }

    public static Object prim_equalsnocase(Object object, Object object2, Context context) {
        String string = YoYo.aString(context, object);
        String string2 = YoYo.aString(context, object2);
        if (string.toLowerCase().equals(string2.toLowerCase())) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }

    public static Object prim_trim(Object object, Context context) {
        String string = YoYo.aString(context, object);
        return string.trim();
    }

    public static Object prim_word(Object object, Object object2, Context context) {
        return YoYo.printToString(object) + YoYo.printToString(object2);
    }

    public static Object prim_position(Object object, Object object2, Context context) {
        if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            int n = 0;
            while (n < objectArray.length) {
                if (YoYo.equal(objectArray[n], object) == YoYo.symtrue) {
                    return new Integer(n + 1);
                }
                ++n;
            }
            return YoYo.symfalse;
        }
        if (object2 instanceof String || object2 instanceof Symbol) {
            String string = YoYo.aString(context, object2);
            int n = string.indexOf(YoYo.aString(context, object));
            if (n >= 0) {
                return new Integer(n);
            }
            return YoYo.symfalse;
        }
        LogoError.error(YoYo.printToString(object) + " is not a list or a string", context);
        return null;
    }

    public static Object prim_memberp(Object object, Object object2, Context context) {
        if (object2 instanceof Object[]) {
            Object[] objectArray = (Object[])object2;
            int n = 0;
            while (n < objectArray.length) {
                if (YoYo.equal(objectArray[n], object) == YoYo.symtrue) {
                    return YoYo.symtrue;
                }
                ++n;
            }
            return YoYo.symfalse;
        }
        if (object2 instanceof String || object2 instanceof Symbol) {
            String string = YoYo.aString(context, object2);
            int n = string.indexOf(YoYo.aString(context, object));
            if (n >= 0) {
                return YoYo.symtrue;
            }
            return YoYo.symfalse;
        }
        LogoError.error(YoYo.printToString(object2) + " is not a list or a string", context);
        return null;
    }

    public static Object prim_listp(Object object, Context context) {
        if (object instanceof Object[]) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }

    public static Object prim_emptyp(Object object, Context context) {
        if (object instanceof Object[]) {
            if (((Object[])object).length == 0) {
                return YoYo.symtrue;
            }
            return YoYo.symfalse;
        }
        if (object instanceof String || object instanceof Symbol) {
            if (YoYo.aString(context, object).length() == 0) {
                return YoYo.symtrue;
            }
            return YoYo.symfalse;
        }
        return YoYo.symfalse;
    }

    public static Object prim_wordp(Object object, Context context) {
        if (object instanceof String || object instanceof Symbol || object instanceof Number) {
            return YoYo.symtrue;
        }
        return YoYo.symfalse;
    }

    public static Object prim_sublist(Object object, Object object2, Object object3, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        int n = YoYo.aInteger(context, object2);
        int n2 = YoYo.aInteger(context, object3);
        try {
            Object[] objectArray2 = new Object[n2 - n + 1];
            System.arraycopy(objectArray, n - 1, objectArray2, 0, objectArray2.length);
            return objectArray2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            if (n <= 0) {
                LogoError.error("starting index: " + n + " is too low", context);
            }
            if (n >= objectArray.length) {
                LogoError.error("starting index: " + n + " is too high", context);
            }
            if (n2 <= 0) {
                LogoError.error("ending index: " + n2 + " is too low", context);
            }
            if (n2 >= objectArray.length) {
                LogoError.error("ending index: " + n2 + " is too high", context);
            }
            if (n > n2) {
                LogoError.error("starting index: " + n + " is greater than ending index: " + n2, context);
            }
            return null;
        }
    }

    public static Object prim_substring(Object object, Object object2, Object object3, Context context) {
        String string = YoYo.aString(context, object);
        int n = YoYo.aInteger(context, object2);
        int n2 = YoYo.aInteger(context, object3);
        try {
            return string.substring(n, n2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            if (n < 0) {
                LogoError.error("starting index: " + n + " is too low", context);
            }
            if (n > string.length()) {
                LogoError.error("starting index: " + n + " is too high", context);
            }
            if (n2 < 0) {
                LogoError.error("ending index: " + n2 + " is too low", context);
            }
            if (n2 > string.length()) {
                LogoError.error("ending index: " + n2 + " is too high", context);
            }
            if (n > n2) {
                LogoError.error("starting index: " + n + " is greater than ending index: " + n2, context);
            }
            return null;
        }
    }

    public static Object prim_listtoword(Object object, Context context) {
        return YoYo.printToString(YoYo.aList(context, object));
    }

    public static Object prim_wordtolist(Object object, Context context) {
        return Reader.read(YoYo.aString(context, object));
    }

    public static Object prim_sortnumlist(Object object, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        if (objectArray.length == 0 || objectArray == null) {
            return object;
        }
        double[] dArray = new double[objectArray.length];
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = YoYo.aDouble(context, objectArray[n]);
            ++n;
        }
        dArray = PrimList.mergesort(dArray, 0, dArray.length - 1);
        Double[] doubleArray = new Double[dArray.length];
        int n2 = 0;
        while (n2 < doubleArray.length) {
            doubleArray[n2] = new Double(dArray[n2]);
            ++n2;
        }
        return doubleArray;
    }

    public static Object prim_listmin(Object object, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        double d = Double.MAX_VALUE;
        int n = 0;
        while (n < objectArray.length) {
            double d2;
            if (objectArray[n] instanceof Number && (d2 = YoYo.aDoubleNoWarn(context, objectArray[n])) < d) {
                d = d2;
            }
            ++n;
        }
        return new Double(d);
    }

    public static Object prim_listmax(Object object, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        double d = -1.7976931348623157E308;
        int n = 0;
        while (n < objectArray.length) {
            double d2;
            if (objectArray[n] instanceof Number && (d2 = YoYo.aDoubleNoWarn(context, objectArray[n])) > d) {
                d = d2;
            }
            ++n;
        }
        return new Double(d);
    }

    public static Object prim_listmedian(Object object, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        if (objectArray.length == 0) {
            LogoError.error("can't compute the median of an empty list", context);
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] instanceof Number) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            LogoError.error("can't compute the median of a list " + YoYo.printToString(object) + " that contains no numbers", context);
        }
        double[] dArray = new double[n];
        int n3 = 0;
        while (n3 < dArray.length) {
            if (objectArray[n3] instanceof Number) {
                dArray[--n] = YoYo.aDoubleNoWarn(context, objectArray[n3]);
            }
            ++n3;
        }
        if ((dArray = PrimList.mergesort(dArray, 0, dArray.length - 1)).length % 2 == 0) {
            return new Double((dArray[dArray.length / 2] + dArray[dArray.length / 2 - 1]) / 2.0);
        }
        return new Double(dArray[dArray.length / 2]);
    }

    public static Object prim_listmean(Object object, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        if (objectArray.length == 0) {
            LogoError.error("can't compute the average of an empty list", context);
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] instanceof Number) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            LogoError.error("can't compute the average of a list " + YoYo.printToString(object) + " that contains no numbers", context);
        }
        double[] dArray = new double[n];
        int n3 = 0;
        while (n3 < dArray.length) {
            if (objectArray[n3] instanceof Number) {
                dArray[--n] = YoYo.aDoubleNoWarn(context, objectArray[n3]);
            }
            ++n3;
        }
        double d = 0.0;
        int n4 = 0;
        while (n4 < dArray.length) {
            d += dArray[n4];
            ++n4;
        }
        return new Double(d / (double)dArray.length);
    }

    public static Object prim_listvariance(Object object, Context context) {
        return new Double(PrimList.internal_listvariance(object, false, context));
    }

    public static double internal_listvariance(Object object, boolean bl, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        if (objectArray.length == 0) {
            LogoError.error("can't compute the " + (bl ? "standard deviation" : "variance") + " of an empty list", context);
            return 0.0;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] instanceof Number) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            LogoError.error("can't compute the " + (bl ? "standard deviation" : "variance") + " of a list " + YoYo.printToString(object) + " that contains no numbers", context);
        }
        double[] dArray = new double[n];
        int n3 = 0;
        while (n3 < dArray.length) {
            if (objectArray[n3] instanceof Number) {
                dArray[--n] = YoYo.aDoubleNoWarn(context, objectArray[n3]);
            }
            ++n3;
        }
        double d = 0.0;
        int n4 = 0;
        while (n4 < dArray.length) {
            d += dArray[n4];
            ++n4;
        }
        double d2 = d / (double)dArray.length;
        d = 0.0;
        int n5 = 0;
        while (n5 < dArray.length) {
            double d3 = dArray[n5] - d2;
            d += d3 * d3;
            ++n5;
        }
        return d / (double)dArray.length;
    }

    public static Object prim_listsdev(Object object, Context context) {
        double d = PrimList.internal_listvariance(object, false, context);
        return new Double(Math.sqrt(d));
    }

    public static Object prim_listmode(Object object, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        if (objectArray.length == 0) {
            LogoError.error("can't compute the mode of an empty list", context);
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] instanceof Number) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            LogoError.error("can't compute the mode of a list " + YoYo.printToString(object) + " that contains no numbers", context);
        }
        double[] dArray = new double[n];
        int n3 = 0;
        while (n3 < dArray.length) {
            if (objectArray[n3] instanceof Number) {
                dArray[--n] = YoYo.aDoubleNoWarn(context, objectArray[n3]);
            }
            ++n3;
        }
        double d = 0.0;
        Vector<Double> vector = new Vector<Double>(0, 1);
        double d2 = 0.0;
        int n4 = 0;
        while (n4 < dArray.length) {
            d = dArray[n4];
            int n5 = 0;
            int n6 = 0;
            while (n5 < dArray.length) {
                if (d == dArray[n5]) {
                    Double d3;
                    if ((double)(++n6) == d2 && !vector.contains(d3 = new Double(dArray[n5]))) {
                        vector.addElement(d3);
                    }
                    if ((double)n6 > d2) {
                        d2 = n6;
                        vector = new Vector();
                        vector.addElement(new Double(dArray[n5]));
                    }
                }
                ++n5;
            }
            ++n4;
        }
        if (vector.size() == 1) {
            return vector.firstElement();
        }
        Object[] objectArray2 = new Object[vector.size()];
        vector.copyInto(objectArray2);
        return objectArray2;
    }

    public static double[] mergesort(double[] dArray, int n, int n2) {
        if (n == n2) {
            return new double[]{dArray[n]};
        }
        int n3 = (n + n2) / 2;
        double[] dArray2 = PrimList.mergesort(dArray, n, n3);
        double[] dArray3 = PrimList.mergesort(dArray, n3 + 1, n2);
        return PrimList.merge(dArray2, dArray3);
    }

    private static final double[] merge(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length + dArray2.length];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < dArray3.length) {
            if (n >= dArray.length) {
                System.arraycopy(dArray2, n2, dArray3, n3, dArray2.length - n2);
                break;
            }
            if (n2 >= dArray2.length) {
                System.arraycopy(dArray, n, dArray3, n3, dArray.length - n);
                break;
            }
            dArray3[n3] = dArray[n] <= dArray2[n2] ? dArray[n++] : dArray2[n2++];
            ++n3;
        }
        return dArray3;
    }

    public static Object prim_copylist(Object object, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
        return objectArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object prim_dolist(Object object, Object object2, Context context) {
        Object var13_19;
        Object var12_14;
        Object[] objectArray;
        LocalRef localRef;
        Object[] objectArray2 = YoYo.aList(context, object);
        Object[] objectArray3 = YoYo.aList(context, object2);
        Object object3 = null;
        Object[] objectArray4 = context.ilist;
        int n = context.ilistposptr;
        try {
            context.ilist = objectArray2;
            context.ilistposptr = 0;
            Object object4 = context.ilistNext();
            if (object4 instanceof LocalRef) {
                localRef = (LocalRef)object4;
                object3 = context.locals.lookupValue(localRef);
            } else {
                int n2;
                Symbol symbol = YoYo.aSymbol(context, object4);
                if (context.locals.boundp(symbol)) {
                    n2 = context.locals.index(symbol);
                    localRef = new LocalRef(n2, symbol);
                    context.setPrev(localRef);
                    object3 = context.locals.lookupValue(localRef);
                } else {
                    n2 = context.locals.defineVar(symbol);
                    localRef = new LocalRef(n2, symbol);
                    context.setPrev(localRef);
                    object3 = null;
                }
            }
            if (context.ufunobj != null && context.locals.names.length > context.ufunobj.arglist.length) {
                context.ufunobj.arglist = context.locals.names;
            }
            objectArray = YoYo.aList(context, YoYo.evalOneFromHere(context));
        }
        finally {
            var12_14 = null;
            context.ilist = objectArray4;
            context.ilistposptr = n;
        }
        try {
            int n3 = 0;
            while (n3 < objectArray.length) {
                context.locals.setValue(localRef, objectArray[n3]);
                YoYo.evalList(objectArray3, context);
                if (context.ufunreturn != null) {
                    Object var13_18 = null;
                    var12_14 = null;
                    if (object3 != null) {
                        context.locals.setValue(localRef, object3);
                        return var13_18;
                    } else {
                        context.locals.undefineVar(localRef);
                    }
                    return var13_18;
                }
                ++n3;
            }
            var13_19 = null;
        }
        catch (Throwable throwable) {
            var12_14 = null;
            if (object3 != null) {
                context.locals.setValue(localRef, object3);
                throw throwable;
            } else {
                context.locals.undefineVar(localRef);
            }
            throw throwable;
        }
        var12_14 = null;
        if (object3 != null) {
            context.locals.setValue(localRef, object3);
            return var13_19;
        }
        context.locals.undefineVar(localRef);
        return var13_19;
    }

    public static Object prim_to_list(Object object, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        Vector<Object> vector = new Vector<Object>();
        Object[] objectArray2 = context.ilist;
        int n = context.ilistposptr;
        try {
            context.ilist = objectArray;
            context.ilistposptr = 0;
            while (context.ilistPeek() != null) {
                vector.addElement(YoYo.evalOneFromHere(context));
            }
            Object[] objectArray3 = new Object[vector.size()];
            vector.copyInto(objectArray3);
            Object[] objectArray4 = objectArray3;
            Object var7_8 = null;
            context.ilist = objectArray2;
            context.ilistposptr = n;
            return objectArray4;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            context.ilist = objectArray2;
            context.ilistposptr = n;
            throw throwable;
        }
    }

    public static Object prim_replace(Object object, Object object2, Object object3, Context context) {
        if (object3 instanceof Object[]) {
            Object[] objectArray = new Object[((Object[])object3).length];
            System.arraycopy((Object[])object3, 0, objectArray, 0, objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                if (YoYo.equal(object, objectArray[n]) == YoYo.symtrue) {
                    objectArray[n] = object2;
                }
                ++n;
            }
            return objectArray;
        }
        if (object3 instanceof String) {
            char c = YoYo.aString(context, object).charAt(0);
            char c2 = YoYo.aString(context, object2).charAt(0);
            return ((String)object3).replace(c, c2);
        }
        LogoError.error(YoYo.printToString(object) + " is not a list or a string", context);
        return null;
    }

    public static Object prim_reverse(Object object, Context context) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[objectArray.length - n - 1] = objectArray[n];
                ++n;
            }
            return objectArray2;
        }
        LogoError.error(YoYo.printToString(object) + " is not a list", context);
        return null;
    }
}

