/*
 * Decompiled with CFR 0.152.
 */
package yoyo;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import yoyo.Closure;
import yoyo.CompoundSymbol;
import yoyo.Context;
import yoyo.Ilist;
import yoyo.LocalRef;
import yoyo.LogoError;
import yoyo.Primitive;
import yoyo.Reader;
import yoyo.Sym;
import yoyo.Symbol;
import yoyo.YoYo;
import yoyo.YoYoMethods;
import yoyo.YoYoObject;

public class PrimVar
implements YoYoMethods {
    private static /* synthetic */ Class class$Ljava$lang$Object;

    public String[] methodList() {
        String[] stringArray = new String[]{"set", "prim_set", "unset", "prim_unset", "type-of", "prim_typeof", "value-of", "prim_valueof", "bound?", "prim_boundp", "let", "prim_let", "dlet", "prim_dlet", "get-properties", "prim_getprops", "get-property", "prim_getprop", "get-parameter", "prim_getparam", "weak-reference", "prim_weakref", "dereference", "prim_deref", "weak-reference?", "prim_weakrefp"};
        return stringArray;
    }

    public String[] infixList() {
        return null;
    }

    public void prePrimCall(Primitive primitive, Object[] objectArray, Context context) {
    }

    public void postPrimCall(Primitive primitive, Context context) {
    }

    public static void prim_set(Context context) {
        Object object = context.ilistNext();
        if (object instanceof LocalRef) {
            context.locals.setValue((LocalRef)object, YoYo.evalOneFromHere(context));
            return;
        }
        Sym sym = YoYo.aSym(context, object);
        if (context.ilistPeek() == null) {
            LogoError.error("not enough inputs to  set", context);
        }
        if (sym instanceof CompoundSymbol) {
            PrimVar.prim_set_record((CompoundSymbol)sym, context);
            return;
        }
        Symbol symbol = (Symbol)sym;
        if (context.locals.boundp(symbol)) {
            int n = context.locals.index(symbol);
            LocalRef localRef = new LocalRef(n, symbol);
            context.setPrev(localRef);
            context.locals.setValue(localRef, YoYo.evalOneFromHere(context));
            return;
        }
        Object object2 = YoYo.evalOneFromHere(context);
        if (context.objenv.boundp(symbol)) {
            context.objenv.setValue(symbol, object2);
            return;
        }
        if (context.ufunenv != context.objenv && context.ufunenv.boundp(symbol)) {
            context.ufunenv.setValue(symbol, object2);
            return;
        }
        context.getGlobalObj().setValue(symbol, object2);
    }

    public static void prim_set_record(CompoundSymbol compoundSymbol, Context context) {
        Object object = YoYo.evalOneFromHere(context);
        Closure closure = YoYo.evalCompound(compoundSymbol, context);
        if (closure.object instanceof YoYoObject) {
            YoYoObject yoYoObject = (YoYoObject)closure.object;
            Object object2 = closure.last;
            if (object2 instanceof String) {
                object2 = Symbol.lookup((String)object2);
            }
            if (object2 instanceof Symbol) {
                yoYoObject.setValue((Symbol)object2, object);
            }
            if (object2 instanceof Ilist) {
                yoYoObject.setValue(YoYo.aSymbol(context, YoYo.evalOne((Ilist)object2, context)), object);
            }
            return;
        }
        Object object3 = closure.object;
        Object object4 = closure.last;
        if (object4 instanceof String) {
            object4 = Symbol.lookup((String)object4);
        }
        Class<?> clazz = object3.getClass();
        Field field = null;
        try {
            if (object4 instanceof Symbol) {
                field = clazz.getField(((Symbol)object4).name);
            } else if (object4 instanceof Ilist) {
                field = clazz.getField(YoYo.aSymbol((Context)context, (Object)YoYo.evalOne((Ilist)((Ilist)object4), (Context)context)).name);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (field == null) {
            LogoError.error("no such field of object type " + clazz.getName(), context);
        }
        try {
            field.set(object3, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            LogoError.error("you forgot to make " + field.toString() + "public", context);
        }
    }

    public static void prim_unset(Context context) {
        Object object = context.ilistNext();
        if (object instanceof LocalRef) {
            context.locals.undefineVar((LocalRef)object);
            return;
        }
        Sym sym = YoYo.aSym(context, object);
        if (sym instanceof CompoundSymbol) {
            PrimVar.prim_unset_record((CompoundSymbol)sym, context);
            return;
        }
        Symbol symbol = (Symbol)sym;
        if (context.locals.boundp(symbol)) {
            int n = context.locals.index(symbol);
            LocalRef localRef = new LocalRef(n, symbol);
            context.setPrev(localRef);
            context.locals.undefineVar(localRef);
            return;
        }
        if (context.objenv.boundp(symbol)) {
            context.objenv.undefineValue(symbol);
            return;
        }
        if (context.ufunenv != context.objenv && context.ufunenv.boundp(symbol)) {
            context.ufunenv.undefineValue(symbol);
            return;
        }
        context.getGlobalObj().undefineValue(symbol);
    }

    public static void prim_unset_record(CompoundSymbol compoundSymbol, Context context) {
        Closure closure = YoYo.evalCompound(compoundSymbol, context);
        if (closure.object instanceof YoYoObject) {
            YoYoObject yoYoObject = (YoYoObject)closure.object;
            Object object = closure.last;
            if (object instanceof String) {
                object = Symbol.lookup((String)object);
            }
            if (object instanceof Symbol) {
                yoYoObject.undefineValue((Symbol)object);
            }
            if (object instanceof Ilist) {
                yoYoObject.undefineValue(YoYo.aSymbol(context, YoYo.evalOne((Ilist)object, context)));
            }
            return;
        }
        LogoError.error("can't undefine a java field", context);
    }

    public static Object prim_typeof(Object object, Context context) {
        if (object instanceof Number) {
            return "number";
        }
        if (object instanceof Sym || object instanceof LocalRef) {
            if (object == YoYo.symtrue || object == YoYo.symfalse) {
                return "boolean";
            }
            return "symbol";
        }
        if (object instanceof String) {
            return "string";
        }
        if (object instanceof YoYoObject) {
            return ((YoYoObject)object).lookupValue(Symbol.lookup("type"));
        }
        if (object instanceof Object[]) {
            return "list";
        }
        if (object instanceof Ilist) {
            return "paren-expression";
        }
        return object.getClass().getName();
    }

    public static Object prim_valueof(Object object, Context context) {
        if (object instanceof String) {
            Sym sym = YoYo.aSym(context, Reader.read(YoYo.aString(context, object))[0]);
            Object object2 = YoYo.lookupSymbol(sym, context);
            if (object2 == null) {
                LogoError.error("i don't know how to " + YoYo.printToString(object), context);
            }
            return object2;
        }
        return object;
    }

    public static Object prim_boundp(Object object, Context context) {
        Sym sym = YoYo.aSym(context, Reader.read(YoYo.aString(context, object))[0]);
        try {
            Object object2 = YoYo.lookupSymbol(sym, context);
            if (object2 == null) {
                return YoYo.symfalse;
            }
            return YoYo.symtrue;
        }
        catch (LogoError logoError) {
            return YoYo.symfalse;
        }
    }

    public static Object prim_getprops(Context context) {
        Properties properties = System.getProperties();
        Object[] objectArray = new Object[((Hashtable)properties).size()];
        int n = 0;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray2;
            String string = (String)enumeration.nextElement();
            objectArray[n] = objectArray2 = new Object[]{string, properties.getProperty(string)};
            ++n;
        }
        return objectArray;
    }

    public static Object prim_getprop(Object object, Context context) {
        Properties properties = System.getProperties();
        String string = properties.getProperty(YoYo.aString(context, object));
        if (string != null) {
            return string;
        }
        return YoYo.symfalse;
    }

    public static Object prim_weakref(Object object, Context context) {
        return PrimVar.newWeakReference(object);
    }

    public static Object prim_deref(Object object, Context context) {
        return PrimVar.aWeakReference(object, context);
    }

    public static Object prim_weakrefp(Object object, Context context) {
        return YoYo.truefalse(PrimVar.weakReferencep(object));
    }

    public static Object prim_let(Object object, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        Object[] objectArray2 = context.ilist;
        int n = context.ilistposptr;
        try {
            int n2 = 0;
            while (n2 < objectArray.length) {
                Object[] objectArray3 = YoYo.aList(context, objectArray[n2]);
                if (objectArray3.length < 2) {
                    LogoError.error("not enough inputs to let", context);
                }
                context.ilist = objectArray3;
                context.ilistposptr = 0;
                Object object2 = context.ilistNext();
                if (object2 instanceof LocalRef) {
                    context.locals.setValue((LocalRef)object2, YoYo.evalOneFromHere(context));
                } else {
                    Symbol symbol = YoYo.aSymbol(context, object2);
                    int n3 = context.locals.boundp(symbol) ? context.locals.index(symbol) : context.locals.defineVar(symbol);
                    LocalRef localRef = new LocalRef(n3, symbol);
                    context.setPrev(localRef);
                    context.locals.setValue(localRef, YoYo.evalOneFromHere(context));
                }
                ++n2;
            }
        }
        finally {
            Object var6_11 = null;
            context.ilist = objectArray2;
            context.ilistposptr = n;
        }
        return null;
    }

    public static Object prim_dlet(Object object, Context context) {
        Object[] objectArray = YoYo.aList(context, object);
        if (context.savedynamics == null) {
            context.savedynamics = new Vector();
        }
        Object[] objectArray2 = context.ilist;
        int n = context.ilistposptr;
        try {
            context.ilist = objectArray;
            context.ilistposptr = 0;
            while (context.ilistPeek() != null) {
                Symbol symbol = YoYo.aSymbol(context, context.ilistNext());
                if (context.ilistPeek() == null) {
                    LogoError.error("not enough inputs to dlet", context);
                }
                Object object2 = YoYo.evalOneFromHere(context);
                context.savedynamics.addElement(symbol);
                context.savedynamics.addElement(context.objenv.lookupValue(symbol));
                context.objenv.defineValue(symbol, object2);
            }
        }
        finally {
            Object var6_7 = null;
            context.ilist = objectArray2;
            context.ilistposptr = n;
        }
        return null;
    }

    static Object newWeakReference(Object object) {
        try {
            Class<?> clazz = Class.forName("java.lang.ref.WeakReference");
            Constructor<?> constructor = clazz.getConstructor(class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = PrimVar.class$("java.lang.Object")));
            return constructor.newInstance(object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return object;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return object;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return object;
        }
        catch (InstantiationException instantiationException) {
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            return object;
        }
    }

    static boolean weakReferencep(Object object) {
        try {
            if (object != null) {
                Class<?> clazz = Class.forName("java.lang.ref.WeakReference");
                return clazz.isAssignableFrom(object.getClass());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static Object aWeakReference(Object object, Context context) {
        try {
            Class<?> clazz;
            if (object != null && (clazz = Class.forName("java.lang.ref.WeakReference")).isAssignableFrom(object.getClass())) {
                Method method = clazz.getMethod("get", new Class[0]);
                Object object2 = method.invoke(object, new Object[0]);
                if (object2 == null) {
                    return YoYo.symfalse;
                }
                return object2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        LogoError.error(YoYo.printToString(object) + " is not a weak reference", context);
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

