/*
 * Decompiled with CFR 0.152.
 */
package yoyo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import yoyo.Context;
import yoyo.LogoError;
import yoyo.PromptedListener;
import yoyo.TCPPrintWriter;
import yoyo.UberContext;

public class TCPServer
implements Runnable {
    static URL base;
    int port;
    ServerSocket listener;

    public static void main(String[] stringArray) {
        URL uRL = null;
        try {
            uRL = new URL("file", "", System.getProperty("user.dir") + "/");
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException);
        }
        TCPServer tCPServer = null;
        try {
            tCPServer = new TCPServer(6666, uRL);
            new Thread(tCPServer).start();
        }
        catch (LogoError logoError) {
            System.out.println(logoError.getMessage());
            System.out.print("Shutting down server...");
            System.out.println("done.");
            return;
        }
    }

    public void run() {
        while (true) {
            Socket socket = null;
            try {
                socket = this.listener.accept();
            }
            catch (IOException iOException) {
                LogoError.error("Error accepting connection on port: " + this.port);
            }
            System.out.println("Connection made from: " + socket.getInetAddress());
            BufferedReader bufferedReader = null;
            TCPPrintWriter tCPPrintWriter = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                tCPPrintWriter = new TCPPrintWriter(socket.getOutputStream(), true);
            }
            catch (IOException iOException) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                if (tCPPrintWriter != null) {
                    tCPPrintWriter.close();
                }
                LogoError.error("Couldn't open input or output stream");
            }
            PromptedListener promptedListener = new PromptedListener(bufferedReader, tCPPrintWriter);
            UberContext uberContext = new UberContext(base);
            Context context = new Context(null, base, tCPPrintWriter, promptedListener, uberContext);
            promptedListener.ub = uberContext;
            promptedListener.c = context;
            promptedListener.printHello();
            try {
                new Thread(promptedListener).start();
                continue;
            }
            catch (LogoError logoError) {
                System.out.println(logoError.toString());
                System.out.print("Shutting down server...");
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                tCPPrintWriter.close();
                System.out.println("done.");
                continue;
            }
            break;
        }
    }

    public TCPServer(int n, URL uRL) {
        this.port = n;
        base = uRL;
        try {
            this.listener = new ServerSocket(n);
        }
        catch (IOException iOException) {
            LogoError.error("Error opening socket on port: " + n);
        }
    }
}

