/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtreemap.swing.example;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;
import net.sf.jtreemap.swing.ColorProvider;
import net.sf.jtreemap.swing.JTreeMap;
import net.sf.jtreemap.swing.SplitByNumber;
import net.sf.jtreemap.swing.SplitBySlice;
import net.sf.jtreemap.swing.SplitBySortedWeight;
import net.sf.jtreemap.swing.SplitByWeight;
import net.sf.jtreemap.swing.SplitSquarified;
import net.sf.jtreemap.swing.SplitStrategy;
import net.sf.jtreemap.swing.TreeMapNode;
import net.sf.jtreemap.swing.example.BuilderTM3;
import net.sf.jtreemap.swing.example.BuilderXML;
import net.sf.jtreemap.swing.example.DemoUtil;
import net.sf.jtreemap.swing.provider.HSBTreeMapColorProvider;
import net.sf.jtreemap.swing.provider.RandomColorProvider;
import net.sf.jtreemap.swing.provider.RedGreenColorProvider;
import net.sf.jtreemap.swing.provider.ZoomPopupMenu;

public class JTreeMapExample
extends JFrame
implements ActionListener {
    private static final double CONSTRAINT_WEIGHTX = 0.5;
    private static final int SCROLLPANE_WIDTH = 140;
    private static final int APPLICATION_HEIGHT = 400;
    private static final int APPLICATION_WIDTH = 600;
    private static final int DEFAULT_FONT_SIZE = 16;
    private static final long serialVersionUID = 2813934810390001709L;
    private static final String EXIT = "Exit";
    private static final String OPEN_TM3_FILE = "Open TM3 File";
    private static final String OPEN_XML_FILE = "Open Xml File";
    private JTreeMap jTreeMap;
    private JTree treeView = new JTree();
    private BuilderTM3 builderTM3;
    private CardLayout cardLayout;
    private JComboBox cmbColorProvider;
    private JComboBox cmbStrategy;
    private JComboBox cmbValue;
    private JComboBox cmbWeight;
    private final LinkedHashMap<String, ColorProvider> colorProviders = new LinkedHashMap();
    private JPanel panelLegend;
    private JPanel panelTM3;
    private TreeMapNode root;
    private final LinkedHashMap<String, SplitStrategy> strategies = new LinkedHashMap();
    private DefaultTreeModel treeModel;

    public JTreeMapExample() {
        this.root = DemoUtil.buildDemoRoot();
        this.jTreeMap = new JTreeMap(this.root, this.treeView);
        this.jTreeMap.setFont(new Font(null, 1, 16));
        this.jTreeMap.setPreferredSize(new Dimension(600, 400));
        this.jTreeMap.setBorder(BorderFactory.createEtchedBorder(1));
        new ZoomPopupMenu(this.jTreeMap);
        try {
            this.initGUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JTreeMapExample example = new JTreeMapExample();
        example.setVisible(true);
        example.pack();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (OPEN_XML_FILE.equals(command)) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
            XMLFileFilter filter = new XMLFileFilter();
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.setXmlFile(chooser.getSelectedFile().getPath());
            }
            this.createColorProviders();
            this.updateLegendPanel();
        } else if (OPEN_TM3_FILE.equals(command)) {
            JFileChooser chooser = new JFileChooser(System.getProperty("user.home"));
            TM3FileFilter filter = new TM3FileFilter();
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                this.setTm3File(chooser.getSelectedFile().getPath());
            }
            this.createColorProviders();
            this.updateLegendPanel();
        } else if (EXIT.equals(command)) {
            this.windowClosingEvent(null);
        }
    }

    public void setTm3File(String path) {
        try {
            this.builderTM3 = new BuilderTM3(new File(path));
            this.root = this.builderTM3.getRoot();
            this.jTreeMap.setRoot(this.root);
            this.treeModel.setRoot(this.root);
            this.setTM3Fields();
            this.panelTM3.setVisible(true);
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "File error", 0);
        }
    }

    public void setXmlFile(String xmlFileName) {
        try {
            BuilderXML bXml = new BuilderXML(xmlFileName);
            this.root = bXml.getRoot();
            this.jTreeMap.setRoot(this.root);
            this.treeModel.setRoot(this.root);
            this.panelTM3.setVisible(false);
        }
        catch (ParseException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "File error", 0);
        }
    }

    protected void windowClosingEvent(WindowEvent e) {
        System.exit(0);
    }

    private void addMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        JMenuItem item = new JMenuItem(OPEN_XML_FILE);
        item.addActionListener(this);
        item.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        menu.add(item);
        item = new JMenuItem(OPEN_TM3_FILE);
        item.addActionListener(this);
        item.setAccelerator(KeyStroke.getKeyStroke(84, 8));
        menu.add(item);
        item = new JMenuItem(EXIT);
        item.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        item.addActionListener(this);
        menu.add(item);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
    }

    private void addPanelCenter(Container parent) {
        JSplitPane splitPaneCenter = new JSplitPane();
        splitPaneCenter.setBorder(BorderFactory.createEmptyBorder());
        parent.add((Component)splitPaneCenter, "Center");
        JScrollPane jScrollPane1 = new JScrollPane();
        splitPaneCenter.setTopComponent(jScrollPane1);
        splitPaneCenter.setBottomComponent(this.jTreeMap);
        this.treeModel = new DefaultTreeModel(this.root);
        this.treeView = new JTree(this.treeModel);
        this.jTreeMap.setTreeView(this.treeView);
        jScrollPane1.getViewport().add(this.treeView);
        jScrollPane1.setPreferredSize(new Dimension(140, this.jTreeMap.getRoot().getHeight()));
        this.treeView.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreeMapNode dest = (TreeMapNode)JTreeMapExample.this.treeView.getLastSelectedPathComponent();
                if (dest != null && dest.isLeaf()) {
                    dest = (TreeMapNode)dest.getParent();
                }
                if (dest == null) {
                    return;
                }
                JTreeMapExample.this.jTreeMap.zoom(dest);
                JTreeMapExample.this.jTreeMap.repaint();
            }
        });
    }

    private void addPanelEast(Container parent) {
        this.panelTM3 = new JPanel();
        parent.add((Component)this.panelTM3, "East");
        JPanel choicePanel = new JPanel();
        choicePanel.setLayout(new GridBagLayout());
        choicePanel.setBorder(new TitledBorder("Choose the TM3 fields"));
        this.panelTM3.add(choicePanel);
        JLabel lblWeight = new JLabel(" weight : ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        choicePanel.add((Component)lblWeight, gridBagConstraints);
        this.cmbWeight = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        choicePanel.add((Component)this.cmbWeight, gridBagConstraints);
        this.cmbWeight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cmb = (JComboBox)e.getSource();
                String field = (String)cmb.getSelectedItem();
                JTreeMapExample.this.builderTM3.setWeights(field);
                JTreeMapExample.this.repaint();
            }
        });
        JLabel lblValue = new JLabel(" value : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        choicePanel.add((Component)lblValue, gridBagConstraints);
        this.cmbValue = new JComboBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        choicePanel.add((Component)this.cmbValue, gridBagConstraints);
        this.cmbValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cmb = (JComboBox)e.getSource();
                String field = (String)cmb.getSelectedItem();
                JTreeMapExample.this.builderTM3.setValues(field);
                JTreeMapExample.this.createColorProviders();
                JTreeMapExample.this.updateLegendPanel();
                JTreeMapExample.this.repaint();
            }
        });
        this.panelTM3.setVisible(false);
    }

    private void addPanelNorth(Container parent) {
        JPanel panelNorth = new JPanel();
        panelNorth.setBorder(BorderFactory.createEmptyBorder());
        JLabel lblStrategy = new JLabel();
        lblStrategy.setText("Strategy :");
        parent.add((Component)panelNorth, "North");
        panelNorth.add(lblStrategy);
        this.cmbStrategy = new JComboBox();
        panelNorth.add(this.cmbStrategy);
        this.createStrategies();
        this.cmbStrategy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTreeMapExample.this.updateStrategy();
            }
        });
    }

    private void addPanelSouth(Container parent) {
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BorderLayout());
        JPanel jPanelLegendNorth = new JPanel();
        JLabel lblColorProvider = new JLabel();
        lblColorProvider.setText("Color Provider :");
        jPanelLegendNorth.add(lblColorProvider);
        this.cmbColorProvider = new JComboBox();
        jPanelLegendNorth.add(this.cmbColorProvider);
        southPanel.add((Component)jPanelLegendNorth, "North");
        this.panelLegend = new JPanel();
        southPanel.add((Component)this.panelLegend, "Center");
        parent.add((Component)southPanel, "South");
        this.cardLayout = new CardLayout();
        this.panelLegend.setLayout(this.cardLayout);
        this.createColorProviders();
        for (String key : this.colorProviders.keySet()) {
            this.cmbColorProvider.addItem(key);
        }
        this.cmbColorProvider.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JTreeMapExample.this.cmbColorProvider.getSelectedIndex() > -1) {
                    JTreeMapExample.this.updateLegendPanel();
                }
            }
        });
        this.cmbColorProvider.setSelectedIndex(0);
    }

    protected void createColorProviders() {
        this.colorProviders.put("Red Green", new RedGreenColorProvider(this.jTreeMap));
        this.colorProviders.put("Random", new RandomColorProvider(this.jTreeMap));
        this.colorProviders.put("HSB linear", new HSBTreeMapColorProvider(this.jTreeMap, HSBTreeMapColorProvider.ColorDistributionTypes.Linear, Color.GREEN, Color.RED));
        this.colorProviders.put("HSB log", new HSBTreeMapColorProvider(this.jTreeMap, HSBTreeMapColorProvider.ColorDistributionTypes.Log, Color.GREEN, Color.RED));
        this.colorProviders.put("HSB SquareRoot", new HSBTreeMapColorProvider(this.jTreeMap, HSBTreeMapColorProvider.ColorDistributionTypes.SquareRoot, Color.GREEN, Color.RED));
        this.colorProviders.put("HSB CubicRoot", new HSBTreeMapColorProvider(this.jTreeMap, HSBTreeMapColorProvider.ColorDistributionTypes.CubicRoot, Color.GREEN, Color.RED));
        this.colorProviders.put("HSB exp", new HSBTreeMapColorProvider(this.jTreeMap, HSBTreeMapColorProvider.ColorDistributionTypes.Exp, Color.GREEN, Color.RED));
        for (String key : this.colorProviders.keySet()) {
            ColorProvider cp = this.colorProviders.get(key);
            this.panelLegend.add((Component)cp.getLegendPanel(), key);
        }
    }

    private void createStrategies() {
        this.strategies.put("Squarified", new SplitSquarified());
        this.strategies.put("Sorted Weight", new SplitBySortedWeight());
        this.strategies.put("Weight", new SplitByWeight());
        this.strategies.put("Slice", new SplitBySlice());
        this.strategies.put("Equal Weight", new SplitByNumber());
        this.cmbStrategy.removeAllItems();
        for (String key : this.strategies.keySet()) {
            this.cmbStrategy.addItem(key);
        }
    }

    private void initGUI() throws Exception {
        this.setTitle("JTreeMap Example");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JTreeMapExample.this.windowClosingEvent(e);
            }
        });
        this.addMenu();
        this.addPanelNorth(this.getContentPane());
        this.addPanelCenter(this.getContentPane());
        this.addPanelSouth(this.getContentPane());
        this.addPanelEast(this.getContentPane());
        this.updateStrategy();
        this.updateLegendPanel();
    }

    private void setTM3Fields() {
        String[] numberFields = this.builderTM3.getNumberFields();
        String[] cmbValues = new String[numberFields.length + 1];
        cmbValues[0] = "";
        for (int i = 1; i < cmbValues.length; ++i) {
            cmbValues[i] = numberFields[i - 1];
        }
        this.cmbWeight.removeAllItems();
        this.cmbValue.removeAllItems();
        for (String item : cmbValues) {
            this.cmbWeight.addItem(item);
            this.cmbValue.addItem(item);
        }
    }

    protected void updateLegendPanel() {
        String key = (String)this.cmbColorProvider.getSelectedItem();
        ColorProvider cp = this.colorProviders.get(key);
        if (cp != null) {
            this.jTreeMap.setColorProvider(cp);
            this.cardLayout.show(this.panelLegend, key);
        }
        this.repaint();
    }

    void updateStrategy() {
        String key = (String)this.cmbStrategy.getSelectedItem();
        SplitStrategy strat = this.strategies.get(key);
        this.jTreeMap.setStrategy(strat);
        this.jTreeMap.repaint();
    }

    static class XMLFileFilter
    extends FileFilter {
        XMLFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String path = f.getPath().toLowerCase(Locale.getDefault());
            return path.endsWith(".xml");
        }

        public String getDescription() {
            return "XML file (*.xml)";
        }
    }

    static class TM3FileFilter
    extends FileFilter {
        TM3FileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String path = f.getPath().toLowerCase(Locale.getDefault());
            return path.endsWith(".tm3");
        }

        public String getDescription() {
            return "TM3 file (*.tm3)";
        }
    }
}

