/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

public class PropertySet
extends DataType {
    private boolean dynamic = true;
    private boolean negate = false;
    private Set cachedNames;
    private Vector ptyRefs = new Vector();
    private Vector setRefs = new Vector();
    private Mapper _mapper;
    private boolean noAttributeSet = true;

    public void appendName(String name) {
        PropertyRef ref = new PropertyRef();
        ref.setName(name);
        this.addPropertyref(ref);
    }

    public void appendRegex(String regex) {
        PropertyRef ref = new PropertyRef();
        ref.setRegex(regex);
        this.addPropertyref(ref);
    }

    public void appendPrefix(String prefix) {
        PropertyRef ref = new PropertyRef();
        ref.setPrefix(prefix);
        this.addPropertyref(ref);
    }

    public void appendBuiltin(BuiltinPropertySetName b) {
        PropertyRef ref = new PropertyRef();
        ref.setBuiltin(b);
        this.addPropertyref(ref);
    }

    public void setMapper(String type, String from, String to) {
        Mapper mapper = this.createMapper();
        Mapper.MapperType mapperType = new Mapper.MapperType();
        mapperType.setValue(type);
        mapper.setFrom(from);
        mapper.setTo(to);
    }

    public void addPropertyref(PropertyRef ref) {
        this.assertNotReference();
        this.ptyRefs.addElement(ref);
    }

    public void addPropertyset(PropertySet ref) {
        this.assertNotReference();
        this.setRefs.addElement(ref);
    }

    public Mapper createMapper() {
        this.assertNotReference();
        if (this._mapper != null) {
            throw new BuildException("Too many <mapper>s!");
        }
        this._mapper = new Mapper(this.getProject());
        return this._mapper;
    }

    public void setDynamic(boolean dynamic) {
        this.assertNotReference();
        this.dynamic = dynamic;
    }

    public void setNegate(boolean negate) {
        this.assertNotReference();
        this.negate = negate;
    }

    public boolean getDynamic() {
        return this.isReference() ? this.getRef().dynamic : this.dynamic;
    }

    public Mapper getMapper() {
        return this.isReference() ? this.getRef()._mapper : this._mapper;
    }

    public Properties getProperties() {
        Hashtable props;
        Set<Object> names = null;
        Project prj = this.getProject();
        Hashtable hashtable = props = prj == null ? System.getProperties() : prj.getProperties();
        if (this.getDynamic() || this.cachedNames == null) {
            names = new HashSet();
            if (this.isReference()) {
                this.getRef().addPropertyNames(names, props);
            } else {
                this.addPropertyNames(names, props);
            }
            Enumeration e = this.setRefs.elements();
            while (e.hasMoreElements()) {
                PropertySet set = (PropertySet)e.nextElement();
                names.addAll(set.getProperties().keySet());
            }
            if (this.negate) {
                HashSet complement = new HashSet(props.keySet());
                complement.removeAll(names);
                names = complement;
            }
            if (!this.getDynamic()) {
                this.cachedNames = names;
            }
        } else {
            names = this.cachedNames;
        }
        FileNameMapper mapper = null;
        Mapper myMapper = this.getMapper();
        if (myMapper != null) {
            mapper = myMapper.getImplementation();
        }
        Properties properties = new Properties();
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String[] newname;
            String name = (String)iter.next();
            String value = (String)props.get(name);
            if (mapper != null && (newname = mapper.mapFileName(name)) != null) {
                name = newname[0];
            }
            properties.setProperty(name, value);
        }
        return properties;
    }

    private void addPropertyNames(Set names, Hashtable properties) {
        Project prj = this.getProject();
        Enumeration e = this.ptyRefs.elements();
        while (e.hasMoreElements()) {
            PropertyRef ref = (PropertyRef)e.nextElement();
            if (ref.name != null) {
                if (prj == null || prj.getProperty(ref.name) == null) continue;
                names.add(ref.name);
                continue;
            }
            if (ref.prefix != null) {
                Enumeration p = properties.keys();
                while (p.hasMoreElements()) {
                    String name = (String)p.nextElement();
                    if (!name.startsWith(ref.prefix)) continue;
                    names.add(name);
                }
                continue;
            }
            if (ref.regex != null) {
                RegexpMatcherFactory matchMaker = new RegexpMatcherFactory();
                RegexpMatcher matcher = matchMaker.newRegexpMatcher();
                matcher.setPattern(ref.regex);
                Enumeration p = properties.keys();
                while (p.hasMoreElements()) {
                    String name = (String)p.nextElement();
                    if (!matcher.matches(name)) continue;
                    names.add(name);
                }
                continue;
            }
            if (ref.builtin != null) {
                if (ref.builtin.equals("all")) {
                    names.addAll(properties.keySet());
                    continue;
                }
                if (ref.builtin.equals("system")) {
                    names.addAll(System.getProperties().keySet());
                    continue;
                }
                if (ref.builtin.equals("commandline")) {
                    names.addAll(this.getProject().getUserProperties().keySet());
                    continue;
                }
                throw new BuildException("Impossible: Invalid builtin attribute!");
            }
            throw new BuildException("Impossible: Invalid PropertyRef!");
        }
    }

    protected PropertySet getRef() {
        Object o;
        if (!this.isChecked()) {
            Stack<PropertySet> stk = new Stack<PropertySet>();
            stk.push(this);
            this.dieOnCircularReference(stk, this.getProject());
        }
        if (!((o = this.getRefid().getReferencedObject(this.getProject())) instanceof PropertySet)) {
            String msg = this.getRefid().getRefId() + " doesn't denote a propertyset";
            throw new BuildException(msg);
        }
        return (PropertySet)o;
    }

    public final void setRefid(Reference r) {
        if (!this.noAttributeSet) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    protected final void assertNotReference() {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.noAttributeSet = false;
    }

    public static class BuiltinPropertySetName
    extends EnumeratedAttribute {
        static final String ALL = "all";
        static final String SYSTEM = "system";
        static final String COMMANDLINE = "commandline";

        public String[] getValues() {
            return new String[]{ALL, SYSTEM, COMMANDLINE};
        }
    }

    public static class PropertyRef {
        private int count;
        private String name;
        private String regex;
        private String prefix;
        private String builtin;

        public void setName(String name) {
            this.assertValid("name", name);
            this.name = name;
        }

        public void setRegex(String regex) {
            this.assertValid("regex", regex);
            this.regex = regex;
        }

        public void setPrefix(String prefix) {
            this.assertValid("prefix", prefix);
            this.prefix = prefix;
        }

        public void setBuiltin(BuiltinPropertySetName b) {
            String builtin = b.getValue();
            this.assertValid("builtin", builtin);
            this.builtin = builtin;
        }

        private void assertValid(String attr, String value) {
            if (value == null || value.length() < 1) {
                throw new BuildException("Invalid attribute: " + attr);
            }
            if (++this.count != 1) {
                throw new BuildException("Attributes name, regex, and prefix are mutually exclusive");
            }
        }

        public String toString() {
            return "name=" + this.name + ", regex=" + this.regex + ", prefix=" + this.prefix + ", builtin=" + this.builtin;
        }
    }
}

