/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.charts;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import net.sf.statcvs.Messages;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.charts.SymbolicNameAnnotation;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.output.ReportConfig;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class CommitScatterChartMaker {
    private static final Color ALL_COMMITS_COLOR = new Color(128, 128, 255);
    private final ReportConfig config;
    private final Repository repository;
    private final int width;

    public CommitScatterChartMaker(ReportConfig config, int width) {
        this.config = config;
        this.repository = config.getRepository();
        this.width = width;
    }

    public ChartImage toFile() {
        DateAxis timeAxis = new DateAxis(Messages.getString("TIME_CSC_DOMAIN"));
        timeAxis.setVerticalTickLabels(true);
        CombinedDomainXYPlot combinedPlot = new CombinedDomainXYPlot(timeAxis);
        List annotations = SymbolicNameAnnotation.createAnnotations(this.repository.getSymbolicNames());
        combinedPlot.add(this.createPlot(this.createTimeSeries(this.repository.getRevisions()), "All (" + Messages.getString("TIME_CSC_RANGE") + ")", ALL_COMMITS_COLOR, annotations));
        annotations = SymbolicNameAnnotation.createAnnotations(this.repository.getSymbolicNames(), 1);
        ArrayList authors = new ArrayList(this.repository.getAuthors());
        Collections.sort(authors);
        Iterator it = authors.iterator();
        while (it.hasNext()) {
            Author author = (Author)it.next();
            Color color = this.config.isDeveloper(author) ? Color.RED : Color.GRAY;
            combinedPlot.add(this.createPlot(this.createTimeSeries(author.getRevisions()), author.getName(), color, annotations));
        }
        combinedPlot.setGap(10.0);
        JFreeChart chart = new JFreeChart(this.config.getProjectName() + ": " + Messages.getString("TIME_CSC_SUBTITLE"), JFreeChart.DEFAULT_TITLE_FONT, combinedPlot, false);
        return this.config.createChartImage("commitscatterauthors.png", Messages.getString("TIME_CSC_SUBTITLE"), chart, this.getSize());
    }

    private TimeSeries createTimeSeries(SortedSet revisions) {
        TimeSeries result = new TimeSeries("Dummy", Second.class);
        Iterator it = revisions.iterator();
        Date lastDate = new Date();
        while (it.hasNext()) {
            Calendar cal;
            Revision rev = (Revision)it.next();
            if (lastDate != null) {
                cal = Calendar.getInstance();
                cal.setTime(lastDate);
                double lastDateSeconds = cal.get(13);
                cal.setTime(rev.getDate());
                double dateSeconds = cal.get(13);
                if (lastDateSeconds == dateSeconds) continue;
            }
            lastDate = rev.getDate();
            cal = Calendar.getInstance();
            cal.setTime(lastDate);
            double hour = cal.get(11);
            double minutes = cal.get(12);
            result.add((RegularTimePeriod)new Second(lastDate), hour + minutes / 60.0);
        }
        return result;
    }

    private XYPlot createPlot(TimeSeries series, String label, Color color, List annotations) {
        NumberAxis valueAxis = new NumberAxis(label);
        valueAxis.setTickUnit(new NumberTickUnit(6.0, new DecimalFormat("0")));
        valueAxis.setAutoRangeIncludesZero(false);
        valueAxis.setRange(0.0, 24.0);
        valueAxis.setLabelFont(new Font("SansSerif", 0, 9));
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1);
        renderer.setShape(new Rectangle(new Dimension(2, 2)));
        XYPlot result = new XYPlot(new TimeSeriesCollection(series), null, valueAxis, renderer);
        result.getRenderer().setSeriesPaint(0, color);
        Iterator it = annotations.iterator();
        while (it.hasNext()) {
            XYAnnotation annotation = (XYAnnotation)it.next();
            result.addAnnotation(annotation);
        }
        return result;
    }

    private Dimension getSize() {
        return new Dimension(this.width, 70 * (this.repository.getAuthors().size() + 1) + 110);
    }
}

