/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.statcvs.output.ChoraIntegration;
import net.sf.statcvs.output.ConfigurationException;
import net.sf.statcvs.output.CssHandler;
import net.sf.statcvs.output.CvswebIntegration;
import net.sf.statcvs.output.DefaultCssHandler;
import net.sf.statcvs.output.JCVSWebIntegration;
import net.sf.statcvs.output.LocalFileCssHandler;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.output.TracIntegration;
import net.sf.statcvs.output.UrlCssHandler;
import net.sf.statcvs.output.ViewCvsIntegration;
import net.sf.statcvs.output.ViewVcIntegration;
import net.sf.statcvs.output.WebRepositoryIntegration;
import net.sf.statcvs.pages.MarkupSyntax;
import net.sf.statcvs.util.FilePatternMatcher;
import net.sf.statcvs.util.FileUtils;
import net.sf.statcvs.weblinks.bugs.BugTracker;
import net.sf.statcvs.weblinks.bugs.Bugzilla;
import net.sf.statcvs.weblinks.bugs.Mantis;

public class ConfigurationOptions {
    private static final String LOGGING_CONFIG_DEFAULT = "logging.properties";
    private static final String LOGGING_CONFIG_VERBOSE = "logging-verbose.properties";
    private static final String LOGGING_CONFIG_DEBUG = "logging-debug.properties";
    private static String logFileName = null;
    private static String checkedOutDirectory = null;
    private static String projectName = null;
    private static String outputDir = "";
    private static String loggingProperties = "logging.properties";
    private static String notesFile = null;
    private static String notes = null;
    private static FilePatternMatcher includePattern = null;
    private static FilePatternMatcher excludePattern = null;
    private static Collection nonDeveloperLogins = new ArrayList();
    private static CssHandler cssHandler = new DefaultCssHandler("statcvs.css");
    private static String charSet = "ISO-8859-1";
    private static WebRepositoryIntegration webRepository = null;
    private static Pattern symbolicNamesPattern;
    private static BugTracker webBugTracker;
    private static String outputFormat;
    private static Properties properties;

    public static String getCharSet() {
        return charSet;
    }

    public static void setCharSet(String cs) {
        charSet = cs;
    }

    public static CssHandler getCssHandler() {
        return cssHandler;
    }

    public static String getProjectName() {
        return projectName;
    }

    public static String getCheckedOutDirectory() {
        return checkedOutDirectory;
    }

    public static String getLogFileName() {
        return logFileName;
    }

    public static String getOutputDir() {
        return outputDir;
    }

    public static String getNotes() {
        return notes;
    }

    public static WebRepositoryIntegration getWebRepository() {
        return webRepository;
    }

    public static void setCheckedOutDirectory(String checkedOutDirectory) throws ConfigurationException {
        File directory = new File(checkedOutDirectory);
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ConfigurationException("directory does not exist: " + checkedOutDirectory);
        }
        ConfigurationOptions.checkedOutDirectory = checkedOutDirectory;
    }

    public static void setCssFile(String cssFile) throws ConfigurationException {
        try {
            URL url = new URL(cssFile);
            if (!url.getProtocol().equals("http")) {
                throw new ConfigurationException("Only HTTP URLs or local files allowed for -css");
            }
            cssHandler = new UrlCssHandler(url);
        }
        catch (MalformedURLException isLocalFile) {
            cssHandler = new LocalFileCssHandler(cssFile);
        }
        cssHandler.checkForMissingResources();
    }

    public static void setLogFileName(String logFileName) throws ConfigurationException {
        File inputFile = new File(logFileName);
        if (!inputFile.exists()) {
            throw new ConfigurationException("Specified logfile not found: " + logFileName);
        }
        ConfigurationOptions.logFileName = logFileName;
    }

    public static void setOutputDir(String outputDir) throws ConfigurationException {
        File outDir;
        if (!outputDir.endsWith(FileUtils.getDirSeparator())) {
            outputDir = outputDir + FileUtils.getDefaultDirSeparator();
        }
        if (!(outDir = new File(outputDir)).exists() && !outDir.mkdirs()) {
            throw new ConfigurationException("Can't create output directory: " + outputDir);
        }
        ConfigurationOptions.outputDir = outputDir;
    }

    public static void setNotesFile(String notesFile) throws ConfigurationException {
        File f = new File(notesFile);
        if (!f.exists()) {
            throw new ConfigurationException("Notes file not found: " + notesFile);
        }
        if (!f.canRead()) {
            throw new ConfigurationException("Can't read notes file: " + notesFile);
        }
        ConfigurationOptions.notesFile = notesFile;
        try {
            notes = ConfigurationOptions.readNotesFile();
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    public static void setViewCvsURL(String url) {
        webRepository = new ViewCvsIntegration(url);
    }

    public static void setCvswebURL(String url) {
        webRepository = new CvswebIntegration(url);
    }

    public static void setChoraURL(String url) {
        webRepository = new ChoraIntegration(url);
    }

    public static void setJCVSWebURL(String url) {
        webRepository = new JCVSWebIntegration(url);
    }

    public static void setViewVcURL(String url) {
        webRepository = new ViewVcIntegration(url);
    }

    public static void setViewTracURL(String url) {
        webRepository = new TracIntegration(url);
    }

    public static void setProjectName(String projectName) {
        ConfigurationOptions.projectName = projectName;
    }

    public static String getLoggingProperties() {
        return loggingProperties;
    }

    public static void setVerboseLogging() {
        loggingProperties = LOGGING_CONFIG_VERBOSE;
    }

    public static void setDebugLogging() {
        loggingProperties = LOGGING_CONFIG_DEBUG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readNotesFile() throws IOException {
        BufferedReader r = null;
        StringBuffer result = new StringBuffer();
        try {
            r = new BufferedReader(new FileReader(notesFile));
            String line = r.readLine();
            while (line != null) {
                result.append(line);
                line = r.readLine();
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
        return result.toString();
    }

    public static void setIncludePattern(String patternList) {
        includePattern = new FilePatternMatcher(patternList);
    }

    public static void setExcludePattern(String patternList) {
        excludePattern = new FilePatternMatcher(patternList);
    }

    public static FilePatternMatcher getExcludePattern() {
        return excludePattern;
    }

    public static FilePatternMatcher getIncludePattern() {
        return includePattern;
    }

    public static void setSymbolicNamesPattern(String symbolicNamesPattern) throws ConfigurationException {
        try {
            ConfigurationOptions.symbolicNamesPattern = Pattern.compile(symbolicNamesPattern);
        }
        catch (PatternSyntaxException e) {
            throw new ConfigurationException("Invalid regular expression for tags: " + e.getLocalizedMessage());
        }
    }

    public static Pattern getSymbolicNamesPattern() {
        return symbolicNamesPattern;
    }

    public static void setBugzillaUrl(String bugzillaUrl) {
        webBugTracker = new Bugzilla(bugzillaUrl);
    }

    public static void setMantisUrl(String mantisUrl) {
        webBugTracker = new Mantis(mantisUrl);
    }

    public static BugTracker getWebBugtracker() {
        return webBugTracker;
    }

    public static void setOutputFormat(String outputFormat) throws ConfigurationException {
        if (!("html".equals(outputFormat) || "xdoc".equals(outputFormat) || "xml".equals(outputFormat))) {
            throw new ConfigurationException("Invalid output format, use only 'html', 'xdoc' or 'xml'");
        }
        ConfigurationOptions.outputFormat = outputFormat;
    }

    public static String getOutputFormat() {
        return outputFormat;
    }

    public static MarkupSyntax getMarkupSyntax() {
        if ("xdoc".equals(outputFormat)) {
            return ReportConfig.XDOC;
        }
        if ("xml".equals(outputFormat)) {
            return ReportConfig.XML;
        }
        return ReportConfig.HTML;
    }

    public static void setWebRepositoryIntegration(WebRepositoryIntegration webRepo) {
        webRepository = webRepo;
    }

    public static void setDefaultCssFile(String cssName) {
        cssHandler = new DefaultCssHandler(cssName);
    }

    public static void addNonDeveloperLogin(String loginName) {
        nonDeveloperLogins.add(loginName);
    }

    public static Collection getNonDeveloperLogins() {
        return nonDeveloperLogins;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setConfigFile(String propertiesFilename) throws ConfigurationException {
        if (propertiesFilename == null) return;
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(propertiesFilename);
                properties.load(is);
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException("Unable to find the configuration file " + propertiesFilename);
            }
            catch (IOException e) {
                throw new ConfigurationException("Problem reading the configuration file " + propertiesFilename);
            }
            Object var4_2 = null;
            if (is == null) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (is == null) throw throwable;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ConfigurationException("Problem closing stream to the configuration file " + propertiesFilename);
            }
        }
        try {}
        catch (IOException e) {
            throw new ConfigurationException("Problem closing stream to the configuration file " + propertiesFilename);
        }
        ((InputStream)is).close();
    }

    public static Properties getConfigProperties() {
        return properties;
    }

    static {
        webBugTracker = BugTracker.NO_BUG_TRACKER;
        outputFormat = "html";
        properties = new Properties();
    }
}

