/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.util.HashSet;
import java.util.Set;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.WebRepositoryIntegration;

public class CvswebIntegration
implements WebRepositoryIntegration {
    private String baseURL;
    private Set atticFileNames = new HashSet();
    private String postfix;

    public CvswebIntegration(String baseURL) {
        int i = baseURL.indexOf("?");
        if (i != -1) {
            this.postfix = baseURL.substring(i + 1);
            baseURL = baseURL.substring(0, i);
        }
        this.baseURL = baseURL.endsWith("/") ? baseURL.substring(0, baseURL.length() - 1) : baseURL;
    }

    public String getName() {
        return "cvsweb";
    }

    public String getDirectoryUrl(Directory directory) {
        return this.baseURL + "/" + directory.getPath();
    }

    private String getFileUrl(VersionedFile file, String parameter) {
        String filename;
        if (this.isInAttic(file)) {
            String path = file.getDirectory().getPath();
            filename = "/" + path + "Attic/" + file.getFilename();
        } else {
            filename = "/" + file.getFilenameWithPath();
        }
        String append = parameter;
        if (this.postfix != null) {
            append = append + (append.length() > 0 ? "&" + this.postfix : "?" + this.postfix);
        }
        return this.baseURL + filename + append;
    }

    public String getFileHistoryUrl(VersionedFile file) {
        return this.getFileUrl(file, "");
    }

    public String getFileViewUrl(VersionedFile file) {
        return this.getFileUrl(file, "?rev=HEAD&content-type=text/vnd.viewcvs-markup");
    }

    public String getFileViewUrl(Revision revision) {
        return this.getFileUrl(revision.getFile(), "?rev=" + revision.getRevisionNumber() + "&content-type=text/vnd.viewcvs-markup");
    }

    public String getDiffUrl(Revision oldRevision, Revision newRevision) {
        if (!oldRevision.getFile().equals(newRevision.getFile())) {
            throw new IllegalArgumentException("revisions must be of the same file");
        }
        return this.getFileUrl(oldRevision.getFile(), ".diff?r1=" + oldRevision.getRevisionNumber() + "&r2=" + newRevision.getRevisionNumber() + "&f=h");
    }

    public void setAtticFileNames(Set atticFileNames) {
        this.atticFileNames = atticFileNames;
    }

    private boolean isInAttic(VersionedFile file) {
        return this.atticFileNames.contains(file.getFilenameWithPath());
    }

    public String getBaseUrl() {
        return this.baseURL;
    }
}

