/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.Messages;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.output.ReportConfig;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class LOCChurnChartMaker {
    private static final double LOWER_MARGIN = 0.4;
    private ChartImage chartFile = null;

    public LOCChurnChartMaker(ReportConfig config, TimeSeries churnSeries, TimeSeries locSeries, String title, String fileName, Dimension size, List annotations) {
        TimeSeriesCollection collection = new TimeSeriesCollection(locSeries);
        TimeSeriesCollection churnCollection = new TimeSeriesCollection(churnSeries);
        JFreeChart chart = this.createChart(collection, churnCollection, title, annotations);
        this.chartFile = config.createChartImage(fileName, title, chart, size);
    }

    public ChartImage toFile() {
        return this.chartFile;
    }

    private JFreeChart createChart(TimeSeriesCollection locCollection, TimeSeriesCollection churnSet, String title, List annotations) {
        String domain = Messages.getString("TIME_LOC_DOMAIN");
        String range = Messages.getString("TIME_LOC_RANGE");
        TimeSeriesCollection data = locCollection;
        boolean legend = true;
        JFreeChart chart = ChartFactory.createXYBarChart(ConfigurationOptions.getProjectName() + ":" + title, domain, true, range, data, PlotOrientation.VERTICAL, true, false, false);
        XYPlot plot = chart.getXYPlot();
        plot.setRenderer(new XYStepRenderer());
        NumberAxis rangeAxis1 = (NumberAxis)plot.getRangeAxis();
        rangeAxis1.setLowerMargin(0.4);
        DateAxis domainAxis = (DateAxis)plot.getDomainAxis();
        domainAxis.setVerticalTickLabels(true);
        NumberAxis rangeAxis2 = new NumberAxis(Messages.getString("CHURN_RANGE"));
        rangeAxis2.setUpperMargin(1.0);
        plot.setRangeAxis(1, rangeAxis2);
        plot.setDataset(1, churnSet);
        plot.setRangeAxis(1, rangeAxis2);
        plot.mapDatasetToRangeAxis(1, 1);
        XYBarRenderer renderer2 = new XYBarRenderer(0.2);
        plot.setRenderer(1, renderer2);
        if (annotations != null) {
            Iterator it = annotations.iterator();
            while (it.hasNext()) {
                plot.addAnnotation((XYAnnotation)it.next());
            }
        }
        return chart;
    }
}

