/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import java.util.Iterator;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.charts.TimeLineChartMaker;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.NavigationNode;
import net.sf.statcvs.pages.Page;
import net.sf.statcvs.reports.AvgFileSizeTimeLineReport;
import net.sf.statcvs.reports.FileCountTimeLineReport;
import net.sf.statcvs.reports.FileTypeReport;
import net.sf.statcvs.reports.FilesWithMostRevisionsTableReport;
import net.sf.statcvs.reports.LargestFilesTableReport;

public class FileSizesPageMaker {
    private static final int MAX_LARGEST_FILES = 20;
    private static final int MAX_FILES_WITH_MOST_REVISIONS = 20;
    private final ReportConfig config;
    private final Repository repository;

    public FileSizesPageMaker(ReportConfig config) {
        this.config = config;
        this.repository = config.getRepository();
    }

    public NavigationNode toFile() {
        ChartImage fileCountChart = new TimeLineChartMaker(this.config, new FileCountTimeLineReport(this.repository.getFiles()).getTimeLine(), "file_count.png", this.repository.getSymbolicNames()).toFile();
        ChartImage fileSizeChart = new TimeLineChartMaker(this.config, new AvgFileSizeTimeLineReport(this.repository.getFiles()).getTimeLine(), "file_size.png", this.repository.getSymbolicNames()).toFile();
        LargestFilesTableReport largestFilesTable = new LargestFilesTableReport(this.config, this.repository.getFiles(), 20);
        FilesWithMostRevisionsTableReport mostRevisionsTable = new FilesWithMostRevisionsTableReport(this.config, this.repository.getFiles(), 20);
        Page page = this.config.createPage("file_sizes", "File Statistics", "File Sizes and File Counts");
        page.addAttribute("Total Files", this.getCurrentFileCount());
        page.addAttribute("Average File Size", this.getCurrentAverageFileSize(), 1, "lines");
        page.addAttribute("Average Revisions Per File", this.getCurrentAverageRevisionCount(), 1);
        page.add(fileCountChart);
        page.add(fileSizeChart);
        page.addSection("File Types");
        page.add(new FileTypeReport(this.config));
        page.addSection("Largest Files");
        page.add(largestFilesTable);
        page.addSection("Files With Most Revisions");
        page.add(mostRevisionsTable);
        return page;
    }

    private int getCurrentFileCount() {
        int result = 0;
        Iterator it = this.repository.getFiles().iterator();
        while (it.hasNext()) {
            VersionedFile file = (VersionedFile)it.next();
            if (file.isDead()) continue;
            ++result;
        }
        return result;
    }

    private double getCurrentAverageFileSize() {
        return (double)this.repository.getCurrentLOC() / (double)this.getCurrentFileCount();
    }

    private double getCurrentAverageRevisionCount() {
        int revisions = 0;
        Iterator it = this.repository.getFiles().iterator();
        while (it.hasNext()) {
            VersionedFile file = (VersionedFile)it.next();
            if (file.isDead()) continue;
            revisions += file.getRevisions().size();
        }
        return (double)revisions / (double)this.getCurrentFileCount();
    }
}

