/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages.xml;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Iterator;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.output.WebRepositoryIntegration;
import net.sf.statcvs.pages.xml.AllDevelopersXml;
import net.sf.statcvs.pages.xml.DirectoriesXml;
import net.sf.statcvs.pages.xml.FilesXml;
import net.sf.statcvs.pages.xml.LogXml;
import net.sf.statcvs.pages.xml.XML;
import net.sf.statcvs.reports.TopDevelopersTableReport;
import net.sf.statcvs.weblinks.bugs.BugTracker;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class GenerateXml {
    private static final String TAG_REPO_STATISTICS = "RepoStatistics";
    private final ReportConfig config;
    private final Repository repository;

    public GenerateXml(ReportConfig config) {
        this.config = config;
        this.repository = config.getRepository();
    }

    public void generate() {
        WebRepositoryIntegration wi;
        BugTracker bt;
        TopDevelopersTableReport topDevelopers = new TopDevelopersTableReport(this.config);
        String gen_time = Calendar.getInstance().getTime().toString();
        String period = this.getReportPeriod();
        String title = Messages.getString("INDEX_TITLE") + " " + this.config.getProjectName();
        Element root = new Element(TAG_REPO_STATISTICS);
        root.setAttribute("date", gen_time.toLowerCase());
        root.setAttribute("period", period.toLowerCase());
        root.setAttribute("numberfiles", Integer.toString(this.getCurrentFileCount()));
        root.setAttribute("totalloc", Integer.toString(this.repository.getCurrentLOC()));
        root.setAttribute("numberdevelopers", Integer.toString(topDevelopers.getDeveloperCount()));
        Document myXML = new Document(root);
        myXML.addContent(new Comment(title));
        Element el2 = new Element("CheckedOutDirectory");
        el2.setAttribute("path", ConfigurationOptions.getCheckedOutDirectory());
        root.addContent(el2);
        if (ConfigurationOptions.getProjectName() != null) {
            Element el3 = new Element("Project");
            el3.setAttribute("path", ConfigurationOptions.getCheckedOutDirectory());
            root.addContent(el3);
        }
        if ((bt = ConfigurationOptions.getWebBugtracker()) != null) {
            Element el = new Element("BugTracker");
            el.setAttribute("baseurl", bt.baseURL());
            el.setAttribute("name", bt.getName());
            root.addContent(el);
        }
        if ((wi = ConfigurationOptions.getWebRepository()) != null) {
            Element el = new Element("WebRepository");
            el.setAttribute("baseurl", wi.getBaseUrl());
            el.setAttribute("name", wi.getName());
            root.addContent(el);
        }
        AllDevelopersXml adxml = new AllDevelopersXml(this.config);
        Element child1 = adxml.toFile();
        root.addContent(child1);
        DirectoriesXml dxml = new DirectoriesXml(this.config);
        Element child2 = dxml.toFile();
        root.addContent(child2);
        LogXml log = new LogXml(this.config);
        Element child3 = log.toFile();
        root.addContent(child3);
        FilesXml fl = new FilesXml(this.config);
        Element child4 = fl.toFile();
        root.addContent(child4);
        try {
            String file = ConfigurationOptions.getOutputDir() + "repo-statistics.xml";
            FileOutputStream out = new FileOutputStream(file);
            XMLOutputter serializer = new XMLOutputter();
            serializer.output(myXML, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private String getReportPeriod() {
        return XML.getDate(this.repository.getFirstDate()) + " to " + XML.getDate(this.repository.getLastDate());
    }

    private int getCurrentFileCount() {
        int result = 0;
        Iterator it = this.repository.getFiles().iterator();
        while (it.hasNext()) {
            VersionedFile file = (VersionedFile)it.next();
            if (file.isDead()) continue;
            ++result;
        }
        return result;
    }
}

