/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reports;

import java.util.Collection;
import java.util.Iterator;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.reportmodel.GenericColumn;
import net.sf.statcvs.reportmodel.IntegerColumn;
import net.sf.statcvs.reportmodel.RatioColumn;
import net.sf.statcvs.reportmodel.Table;
import net.sf.statcvs.util.IntegerMap;

public abstract class AbstractLocTableReport {
    public static final int SORT_BY_NAME = 0;
    public static final int SORT_BY_LINES = 1;
    private final ReportConfig config;
    private final Repository content;
    private final IntegerMap changesMap = new IntegerMap();
    private final IntegerMap linesMap = new IntegerMap();

    public AbstractLocTableReport(ReportConfig config) {
        this.config = config;
        this.content = config.getRepository();
    }

    protected void calculateChangesAndLinesPerDeveloper(Collection revs) {
        Iterator it = revs.iterator();
        while (it.hasNext()) {
            Revision rev = (Revision)it.next();
            if (rev.getAuthor() == null || !this.config.isDeveloper(rev.getAuthor())) continue;
            this.changesMap.addInt(rev.getAuthor(), 1);
            this.linesMap.addInt(rev.getAuthor(), rev.getNewLines());
        }
    }

    protected void calculateChangesAndLinesPerDirectory(Collection revisions) {
        Iterator it = revisions.iterator();
        while (it.hasNext()) {
            Revision rev = (Revision)it.next();
            Directory dir = rev.getFile().getDirectory();
            this.changesMap.addInt(dir, 1);
            this.linesMap.addInt(dir, rev.getNewLines());
        }
    }

    protected Table createChangesAndLinesTable(GenericColumn keys, GenericColumn keys2, String summary) {
        Table result = new Table(summary);
        IntegerColumn changes = new IntegerColumn(Messages.getString("COLUMN_CHANGES"));
        IntegerColumn linesOfCode = new IntegerColumn(Messages.getString("COLUMN_LOC"));
        RatioColumn linesPerChange = new RatioColumn(Messages.getString("COLUMN_LOC_PER_CHANGE"), linesOfCode, changes);
        keys.setTotal(Messages.getString("TOTALS"));
        changes.setShowPercentages(true);
        linesOfCode.setShowPercentages(true);
        result.addColumn(keys);
        if (keys2 != null) {
            keys.setTotal("");
            keys2.setTotal(Messages.getString("TOTALS"));
            result.addColumn(keys2);
        }
        result.addColumn(changes);
        result.addColumn(linesOfCode);
        result.addColumn(linesPerChange);
        result.setKeysInFirstColumn(true);
        Iterator it = this.linesMap.iteratorSortedByValueReverse();
        while (it.hasNext()) {
            Object key = it.next();
            keys.addValue(key);
            if (keys2 != null) {
                keys2.addValue(key);
            }
            changes.addValue(this.changesMap.get(key));
            linesOfCode.addValue(this.linesMap.get(key));
        }
        if (result.getRowCount() > 1) {
            result.setShowTotals(true);
        }
        return result;
    }

    protected Repository getContent() {
        return this.content;
    }

    protected IntegerMap getChangesMap() {
        return this.changesMap;
    }

    protected IntegerMap getLinesMap() {
        return this.linesMap;
    }

    public int getDeveloperCount() {
        int result = 0;
        Iterator it = this.getContent().getAuthors().iterator();
        while (it.hasNext()) {
            Author author = (Author)it.next();
            if (!this.config.isDeveloper(author)) continue;
            ++result;
        }
        return result;
    }
}

