/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ContentHandlerFactory;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class URLConnectionEx {
    protected static String defaultUserAgent = "Mozilla/5.0";
    protected URLConnection urlConnection;
    protected boolean isCompressionActive;

    public static void setDefaultUserAgent(String defaultUserAgent) {
        URLConnectionEx.defaultUserAgent = defaultUserAgent;
    }

    protected URLConnectionEx(URLConnection urlConnection, boolean isCompressionActive) {
        this.urlConnection = urlConnection;
        this.isCompressionActive = isCompressionActive;
        if (isCompressionActive) {
            urlConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
        }
        urlConnection.setRequestProperty("User-Agent", defaultUserAgent);
    }

    public static URLConnectionEx openConnection(URL url) throws IOException {
        String protocol;
        boolean isCompressionActive = false;
        if (url != null && ("http".equals(protocol = url.getProtocol()) || "https".equals(protocol))) {
            isCompressionActive = true;
        }
        return new URLConnectionEx(url.openConnection(), isCompressionActive);
    }

    public void connect() throws IOException {
        this.urlConnection.connect();
    }

    public boolean getAllowUserInteraction() {
        return this.urlConnection.getAllowUserInteraction();
    }

    public Object getContent() throws IOException {
        return this.urlConnection.getContent();
    }

    public String getContentEncoding() {
        return this.urlConnection.getContentEncoding();
    }

    public int getContentLength() {
        return this.urlConnection.getContentLength();
    }

    public String getContentType() {
        return this.urlConnection.getContentType();
    }

    public long getDate() {
        return this.urlConnection.getDate();
    }

    public static boolean getDefaultAllowUserInteraction() {
        return URLConnection.getDefaultAllowUserInteraction();
    }

    public static String getDefaultRequestProperty(String key) {
        return URLConnection.getDefaultRequestProperty(key);
    }

    public boolean getDefaultUseCaches() {
        return this.urlConnection.getDefaultUseCaches();
    }

    public boolean getDoInput() {
        return this.urlConnection.getDoInput();
    }

    public boolean getDoOutput() {
        return this.urlConnection.getDoOutput();
    }

    public long getExpiration() {
        return this.urlConnection.getExpiration();
    }

    public static FileNameMap getFileNameMap() {
        return URLConnection.getFileNameMap();
    }

    public String getHeaderField(int n) {
        return this.urlConnection.getHeaderField(n);
    }

    public String getHeaderField(String name) {
        return this.urlConnection.getHeaderField(name);
    }

    public long getHeaderFieldDate(String name, long default_) {
        return this.urlConnection.getHeaderFieldDate(name, default_);
    }

    public int getHeaderFieldInt(String name, int default_) {
        return this.urlConnection.getHeaderFieldInt(name, default_);
    }

    public String getHeaderFieldKey(int n) {
        return this.urlConnection.getHeaderFieldKey(n);
    }

    public long getIfModifiedSince() {
        return this.urlConnection.getIfModifiedSince();
    }

    public InputStream getInputStream() throws IOException {
        String encoding;
        InputStream in = this.urlConnection.getInputStream();
        if (this.isCompressionActive && (encoding = this.urlConnection.getContentEncoding()) != null) {
            if ("gzip".equals(encoding = encoding.toLowerCase(Locale.ENGLISH))) {
                in = new GZIPInputStream(in);
            } else if ("deflate".equals(encoding)) {
                in = new InflaterInputStream(in, new Inflater(true));
            }
        }
        return in;
    }

    public long getLastModified() {
        return this.urlConnection.getLastModified();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.urlConnection.getOutputStream();
    }

    public String getRequestProperty(String key) {
        return this.urlConnection.getRequestProperty(key);
    }

    public URL getURL() {
        return this.urlConnection.getURL();
    }

    public boolean getUseCaches() {
        return this.urlConnection.getUseCaches();
    }

    public static String guessContentTypeFromName(String fname) {
        return URLConnection.guessContentTypeFromName(fname);
    }

    public static String guessContentTypeFromStream(InputStream is) throws IOException {
        return URLConnection.guessContentTypeFromStream(is);
    }

    public void setAllowUserInteraction(boolean allowUserInteraction) {
        this.urlConnection.setAllowUserInteraction(allowUserInteraction);
    }

    public static void setContentHandlerFactory(ContentHandlerFactory fac) {
        URLConnection.setContentHandlerFactory(fac);
    }

    public static void setDefaultAllowUserInteraction(boolean defaultAllowUserInteraction) {
        URLConnection.setDefaultAllowUserInteraction(defaultAllowUserInteraction);
    }

    public static void setDefaultRequestProperty(String key, String value) {
        URLConnection.setDefaultRequestProperty(key, value);
    }

    public void setDefaultUseCaches(boolean defaultUseCaches) {
        this.urlConnection.setDefaultUseCaches(defaultUseCaches);
    }

    public void setDoInput(boolean doInput) {
        this.urlConnection.setDoInput(doInput);
    }

    public void setDoOutput(boolean doOutput) {
        this.urlConnection.setDoOutput(doOutput);
    }

    public static void setFileNameMap(FileNameMap map) {
        URLConnection.setFileNameMap(map);
    }

    public void setIfModifiedSince(long ifModifiedSince) {
        this.urlConnection.setIfModifiedSince(ifModifiedSince);
    }

    public void setRequestProperty(String key, String value) {
        this.urlConnection.setRequestProperty(key, value);
    }

    public void setUseCaches(boolean useCaches) {
        this.urlConnection.setUseCaches(useCaches);
    }

    public String toString() {
        return this.urlConnection.toString();
    }

    public URLConnection getWrappedURLConnection() {
        return this.urlConnection;
    }
}

