/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.model.processor.javadoc;

import chrriis.udoc.model.ClassInfo;
import chrriis.udoc.model.URLConnectionEx;
import chrriis.udoc.model.Util;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;

public class JavadocClassInfoLoader {
    protected static final int UNDEFINED = 0;
    protected static final int CLASS_DATA_START = 1;
    protected static final int ENUM_CONSTANT_SUMMARY = 2;
    protected static final int ANNOTATION_REQUIRED_MEMBER_SUMMARY = 3;
    protected static final int FIELD_SUMMARY = 4;
    protected static final int CONSTRUCTOR_SUMMARY = 5;
    protected static final int METHOD_SUMMARY = 6;
    protected static final int ENUM_CONSTANT_DETAIL = 7;
    protected static final int ANNOTATION_MEMBER_DETAIL = 8;
    protected static final int FIELD_DETAIL = 9;
    protected static final int CONSTRUCTOR_DETAIL = 10;
    protected static final int METHOD_DETAIL = 11;
    protected static final int CLASS_DATA_END = 12;
    protected static final String CLASS_DATA_START_TEXT = "<!-- ======== START OF CLASS DATA ======== -->";
    protected static final String ENUM_CONSTANT_SUMMARY_TEXT = "<!-- =========== ENUM CONSTANT SUMMARY =========== -->";
    protected static final String ANNOTATION_REQUIRED_MEMBER_SUMMARY_TEXT = "<!-- =========== ANNOTATION TYPE REQUIRED MEMBER SUMMARY =========== -->";
    protected static final String FIELD_SUMMARY_TEXT = "<!-- =========== FIELD SUMMARY =========== -->";
    protected static final String CONSTRUCTOR_SUMMARY_TEXT = "<!-- ======== CONSTRUCTOR SUMMARY ======== -->";
    protected static final String METHOD_SUMMARY_TEXT = "<!-- ========== METHOD SUMMARY =========== -->";
    protected static final String ENUM_CONSTANT_DETAIL_TEXT = "<!-- ============ ENUM CONSTANT DETAIL =========== -->";
    protected static final String ANNOTATION_MEMBER_DETAIL_TEXT = "<!-- ============ ANNOTATION TYPE MEMBER DETAIL =========== -->";
    protected static final String FIELD_DETAIL_TEXT = "<!-- ============ FIELD DETAIL =========== -->";
    protected static final String CONSTRUCTOR_DETAIL_TEXT = "<!-- ========= CONSTRUCTOR DETAIL ======== -->";
    protected static final String METHOD_DETAIL_TEXT = "<!-- ============ METHOD DETAIL ========== -->";
    protected static final String CLASS_DATA_END_TEXT = "<!-- ========= END OF CLASS DATA ========= -->";
    protected static HashMap packageToDocumentationRootMap = new HashMap();

    public static String loadClassData(String className, String documentationRoot) {
        int lastDotIndex = className.lastIndexOf(46);
        String packageName = lastDotIndex == -1 ? "" : className.substring(0, lastDotIndex);
        String docPath = String.valueOf(Util.unescapeClassName(className.replace('.', '/'))) + ".html";
        if (documentationRoot != null) {
            docPath = String.valueOf(documentationRoot) + "/" + docPath;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<type name=\"").append(Util.escapeXML(className)).append("\">");
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(URLConnectionEx.openConnection(new URL(docPath)).getInputStream()));
            int state = 0;
            boolean hasEnumDetail = false;
            boolean hasFieldDetail = false;
            boolean hasConstructorDetail = false;
            boolean hasMethodDetail = false;
            StringBuffer subTypeSB = new StringBuffer();
            int classModifiers = 0;
            block16: while ((line = reader.readLine()) != null) {
                line = line.trim();
                switch (state) {
                    case 0: {
                        if (!line.startsWith(CLASS_DATA_START_TEXT)) break;
                        state = JavadocClassInfoLoader.changeState(state, 1, sb);
                        break;
                    }
                    case 1: {
                        if (line.startsWith(ENUM_CONSTANT_SUMMARY_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 2, sb);
                            hasEnumDetail = true;
                            break;
                        }
                        if (line.startsWith(ANNOTATION_REQUIRED_MEMBER_SUMMARY_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 3, sb);
                            break;
                        }
                        if (line.startsWith(FIELD_SUMMARY_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 4, sb);
                            hasFieldDetail = true;
                            break;
                        }
                        if (line.startsWith(CONSTRUCTOR_SUMMARY_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 5, sb);
                            hasConstructorDetail = true;
                            break;
                        }
                        if (line.startsWith(METHOD_SUMMARY_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 6, sb);
                            hasMethodDetail = true;
                            break;
                        }
                        if (line.startsWith(CLASS_DATA_END_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 12, sb);
                            break;
                        }
                        if (line.startsWith("<DT><B>All Known ") || line.startsWith("<DT><B>Direct Known ")) {
                            String type = line.startsWith("All Known Subinterfaces") ? "interface " : "class ";
                            line = line.substring(line.indexOf("<DD>") + "<DD>".length());
                            String[] tokens = line.split(", ");
                            int i = 0;
                            while (i < tokens.length) {
                                String token = tokens[i].trim().replaceAll("</DD>", "");
                                subTypeSB.append("<subType value=\"" + type + JavadocClassInfoLoader.processType(token, documentationRoot, packageName) + "\"/>");
                                ++i;
                            }
                            continue block16;
                        }
                        if (!line.startsWith("<DT><PRE>")) break;
                        while (!line.contains("</DL>")) {
                            line = String.valueOf(line) + " " + reader.readLine();
                        }
                        line = line.substring("<DT><PRE>".length());
                        String[] tokens = line.split("<DT>");
                        int index = line.indexOf("<B>");
                        if (index != -1) {
                            line = String.valueOf(line.substring(0, index += "<B>".length())) + packageName + '.' + line.substring(index);
                        }
                        String prototypeToken = tokens[0].replaceAll("<B>", "").replaceAll("</B>", "").replaceAll("</DL>", "");
                        String prototype = JavadocClassInfoLoader.removeTags(line.replaceAll("<DT>", " "));
                        sb.append("<prototype value=\"" + prototype + "\"/>");
                        classModifiers = Util.getModifiers(prototypeToken);
                        sb.append("<superTypes>");
                        int i = 1;
                        while (i < tokens.length) {
                            String superTypes = tokens[i];
                            int modifier = 0;
                            if (superTypes.startsWith("implements ")) {
                                superTypes = superTypes.substring("implements ".length());
                                modifier = 64;
                            } else if (superTypes.startsWith("extends ")) {
                                superTypes = superTypes.substring("extends ".length());
                                modifier = (classModifiers & 0x40) != 0 ? 64 : 256;
                            }
                            String[] superTypeTokens = superTypes.split(", ");
                            int j = 0;
                            while (j < superTypeTokens.length) {
                                String token = superTypeTokens[j].trim().replaceAll("</DL>", "");
                                sb.append("<superType value=\"");
                                if ((modifier & 0x100) != 0) {
                                    sb.append("class ");
                                } else if ((modifier & 0x10) != 0) {
                                    sb.append("@interface ");
                                } else if ((modifier & 0x20) != 0) {
                                    sb.append("enum ");
                                } else if ((modifier & 0x40) != 0) {
                                    sb.append("interface ");
                                }
                                sb.append(JavadocClassInfoLoader.processType(token, documentationRoot, packageName)).append("\"/>");
                                ++j;
                            }
                            ++i;
                        }
                        sb.append("</superTypes>");
                        sb.append("<subTypes>" + subTypeSB.toString() + "</subTypes>");
                        break;
                    }
                    case 2: {
                        if (line.startsWith(ANNOTATION_REQUIRED_MEMBER_SUMMARY_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 3, sb);
                            break;
                        }
                        if (line.startsWith(FIELD_SUMMARY_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 4, sb);
                            hasFieldDetail = true;
                            break;
                        }
                        if (line.startsWith(CONSTRUCTOR_SUMMARY_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 5, sb);
                            hasConstructorDetail = true;
                            break;
                        }
                        if (line.startsWith(METHOD_SUMMARY_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 6, sb);
                            hasMethodDetail = true;
                            break;
                        }
                        if (line.startsWith(ENUM_CONSTANT_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 7, sb);
                            break;
                        }
                        if (line.startsWith(FIELD_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 9, sb);
                            break;
                        }
                        if (!line.startsWith(CLASS_DATA_END_TEXT)) break;
                        state = JavadocClassInfoLoader.changeState(state, 12, sb);
                        break;
                    }
                    case 3: {
                        if (line.startsWith(FIELD_SUMMARY_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 4, sb);
                            hasFieldDetail = true;
                            break;
                        }
                        if (line.startsWith(CONSTRUCTOR_SUMMARY_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 5, sb);
                            hasConstructorDetail = true;
                            break;
                        }
                        if (line.startsWith(METHOD_SUMMARY_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 6, sb);
                            hasMethodDetail = true;
                            break;
                        }
                        if (hasEnumDetail && line.startsWith(ENUM_CONSTANT_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 7, sb);
                            break;
                        }
                        if (line.startsWith(ANNOTATION_MEMBER_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 8, sb);
                            break;
                        }
                        if (line.startsWith(FIELD_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 9, sb);
                            break;
                        }
                        if (!line.startsWith(CLASS_DATA_END_TEXT)) break;
                        state = JavadocClassInfoLoader.changeState(state, 12, sb);
                        break;
                    }
                    case 4: {
                        if (line.startsWith(CONSTRUCTOR_SUMMARY_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 5, sb);
                            hasConstructorDetail = true;
                            break;
                        }
                        if (line.startsWith(METHOD_SUMMARY_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 6, sb);
                            hasMethodDetail = true;
                            break;
                        }
                        if (hasEnumDetail && line.startsWith(ENUM_CONSTANT_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 7, sb);
                            break;
                        }
                        if (line.startsWith(ANNOTATION_MEMBER_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 8, sb);
                            break;
                        }
                        if (line.startsWith(FIELD_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 9, sb);
                            break;
                        }
                        if (!line.startsWith(CLASS_DATA_END_TEXT)) break;
                        state = JavadocClassInfoLoader.changeState(state, 12, sb);
                        break;
                    }
                    case 5: {
                        if (line.indexOf(METHOD_SUMMARY_TEXT) >= 0) {
                            state = JavadocClassInfoLoader.changeState(state, 6, sb);
                            hasMethodDetail = true;
                            break;
                        }
                        if (hasEnumDetail && line.startsWith(ENUM_CONSTANT_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 7, sb);
                            break;
                        }
                        if (hasFieldDetail && line.startsWith(FIELD_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 9, sb);
                            break;
                        }
                        if (line.startsWith(CONSTRUCTOR_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 10, sb);
                            break;
                        }
                        if (!line.startsWith(CLASS_DATA_END_TEXT)) break;
                        state = JavadocClassInfoLoader.changeState(state, 12, sb);
                        break;
                    }
                    case 6: {
                        if (hasEnumDetail && line.startsWith(ENUM_CONSTANT_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 7, sb);
                            break;
                        }
                        if (hasFieldDetail && line.startsWith(FIELD_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 9, sb);
                            break;
                        }
                        if (hasConstructorDetail && line.startsWith(CONSTRUCTOR_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 10, sb);
                            break;
                        }
                        if (line.startsWith(METHOD_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 11, sb);
                            break;
                        }
                        if (!line.startsWith(CLASS_DATA_END_TEXT)) break;
                        state = JavadocClassInfoLoader.changeState(state, 12, sb);
                        break;
                    }
                    case 7: {
                        if (line.startsWith(ANNOTATION_MEMBER_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 8, sb);
                            break;
                        }
                        if (hasFieldDetail && line.startsWith(FIELD_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 9, sb);
                            break;
                        }
                        if (hasConstructorDetail && line.startsWith(CONSTRUCTOR_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 10, sb);
                            break;
                        }
                        if (hasMethodDetail && line.startsWith(METHOD_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 11, sb);
                            break;
                        }
                        if (line.startsWith(CLASS_DATA_END_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 12, sb);
                            break;
                        }
                        if (!line.startsWith("<PRE>")) break;
                        line = reader.readLine().trim();
                        while (!line.endsWith("</PRE>")) {
                            line = String.valueOf(line) + ' ' + reader.readLine().trim();
                        }
                        sb.append("<enum value=\"" + JavadocClassInfoLoader.removeTags(JavadocClassInfoLoader.processType(line.replaceAll("</PRE>", ""), documentationRoot, packageName)) + "\"/>");
                        break;
                    }
                    case 8: {
                        if (hasFieldDetail && line.startsWith(FIELD_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 9, sb);
                            break;
                        }
                        if (hasConstructorDetail && line.startsWith(CONSTRUCTOR_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 10, sb);
                            break;
                        }
                        if (hasMethodDetail && line.startsWith(METHOD_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 11, sb);
                            break;
                        }
                        if (line.startsWith(CLASS_DATA_END_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 12, sb);
                            break;
                        }
                        if (!line.startsWith("<PRE>")) break;
                        line = reader.readLine().trim();
                        while (!line.endsWith("</PRE>")) {
                            line = String.valueOf(line) + ' ' + reader.readLine().trim();
                        }
                        sb.append("<annotationMember value=\"" + JavadocClassInfoLoader.removeTags(JavadocClassInfoLoader.processType(line.replaceAll("</PRE>", ""), documentationRoot, packageName)) + "()\"/>");
                        break;
                    }
                    case 9: {
                        if (hasConstructorDetail && line.startsWith(CONSTRUCTOR_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 10, sb);
                            break;
                        }
                        if (hasMethodDetail && line.startsWith(METHOD_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 11, sb);
                            break;
                        }
                        if (line.startsWith(CLASS_DATA_END_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 12, sb);
                            break;
                        }
                        if (!line.startsWith("<PRE>")) break;
                        line = reader.readLine().trim();
                        while (!line.endsWith("</PRE>")) {
                            line = String.valueOf(line) + ' ' + reader.readLine().trim();
                        }
                        sb.append("<field value=\"" + JavadocClassInfoLoader.removeTags(JavadocClassInfoLoader.processType(line.replaceAll("</PRE>", ""), documentationRoot, packageName)) + "\"/>");
                        break;
                    }
                    case 10: {
                        if (hasMethodDetail && line.startsWith(METHOD_DETAIL_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 11, sb);
                            break;
                        }
                        if (line.startsWith(CLASS_DATA_END_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 12, sb);
                            break;
                        }
                        if (!line.startsWith("<PRE>")) break;
                        line = reader.readLine().trim();
                        while (!line.endsWith("</PRE>")) {
                            line = String.valueOf(line) + ' ' + reader.readLine().trim();
                        }
                        sb.append("<constructor value=\"" + JavadocClassInfoLoader.removeTags(JavadocClassInfoLoader.processType(line.replaceAll("</PRE>", ""), documentationRoot, packageName)) + "\"/>");
                        break;
                    }
                    case 11: {
                        if (line.startsWith(CLASS_DATA_END_TEXT)) {
                            state = JavadocClassInfoLoader.changeState(state, 12, sb);
                            break;
                        }
                        if (!line.startsWith("<PRE>")) break;
                        line = reader.readLine().trim();
                        while (!line.endsWith("</PRE>")) {
                            line = String.valueOf(line) + ' ' + reader.readLine().trim();
                        }
                        if (line.indexOf("</B>(") == -1) break;
                        sb.append("<method value=\"");
                        if ((classModifiers & 0x40) != 0) {
                            sb.append("public ");
                        }
                        sb.append(String.valueOf(JavadocClassInfoLoader.removeTags(JavadocClassInfoLoader.processType(line.replaceAll("</PRE>", ""), documentationRoot, packageName))) + "\"/>");
                        break;
                    }
                }
            }
            JavadocClassInfoLoader.setPackageDocumentationRoot(packageName, documentationRoot);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        sb.append("</type>");
        System.err.println(sb.toString());
        return sb.toString();
    }

    protected static int changeState(int oldState, int newState, StringBuffer sb) {
        if (oldState == newState) {
            return newState;
        }
        switch (oldState) {
            case 7: {
                sb.append("</enums>");
                break;
            }
            case 8: {
                sb.append("</annotationMembers>");
                break;
            }
            case 9: {
                sb.append("</fields>");
                break;
            }
            case 11: {
                sb.append("</methods>");
                break;
            }
            case 10: {
                sb.append("</constructors>");
            }
        }
        switch (newState) {
            case 7: {
                sb.append("<enums>");
                break;
            }
            case 8: {
                sb.append("<annotationMembers>");
                break;
            }
            case 9: {
                sb.append("<fields>");
                break;
            }
            case 11: {
                sb.append("<methods>");
                break;
            }
            case 10: {
                sb.append("<constructors>");
            }
        }
        return newState;
    }

    protected static String processType(String pType, String documentationRoot, String referencePackageName) {
        int index;
        pType = pType.replaceAll("<B>", "").replaceAll("</B>", "").replaceAll("&nbsp;", " ");
        int analysisStart = 0;
        while ((index = pType.indexOf("<A HREF=\"", analysisStart)) != -1) {
            int processIndex = index;
            String modifiers = pType.substring(0, index);
            String type = pType.substring(processIndex + "<A HREF=\"".length());
            index = type.indexOf(34);
            String docPath = type.substring(0, index);
            int endTagIndex = type.indexOf(62, index + 1);
            if ((index = type.indexOf(" title=\"", index + 1)) != -1 && index < endTagIndex) {
                String endString;
                if ((type = type.substring(index + " title=\"".length())).startsWith("class ") || type.startsWith("annotation ") || type.startsWith("enum ") || type.startsWith("interface ")) {
                    int indexOfIndex;
                    type = type.substring(type.indexOf(" in ") + " in ".length());
                    index = type.indexOf(34);
                    endString = type.substring(type.indexOf(62) + 1);
                    boolean isAnnotation = endString.startsWith("@");
                    if (isAnnotation) {
                        endString = endString.substring(1);
                    }
                    int aIndex = endString.indexOf("</A>");
                    endString = String.valueOf(Util.escapeClassName(endString.substring(0, aIndex))) + endString.substring(aIndex + "</A>".length());
                    String packageName = type.substring(0, index);
                    String startString = String.valueOf(modifiers) + (isAnnotation ? "@" : "") + packageName + ".";
                    analysisStart = startString.length();
                    type = String.valueOf(startString) + endString;
                    String referenceDocPath = documentationRoot;
                    if (referencePackageName.length() > 0) {
                        referenceDocPath = String.valueOf(referenceDocPath) + '/' + referencePackageName.replace('.', '/');
                    }
                    if ((indexOfIndex = docPath.indexOf("/index.html")) != -1) {
                        docPath = String.valueOf(docPath.substring(0, indexOfIndex)) + '/' + packageName.replace('.', '/') + "/a.html";
                    }
                    docPath = packageName.length() > 0 ? docPath.substring(0, docPath.lastIndexOf(String.valueOf(packageName.replace('.', '/')) + '/')) : docPath.substring(0, docPath.lastIndexOf(47) + 1);
                    while (docPath.startsWith("./")) {
                        docPath = docPath.substring("./".length());
                    }
                    if (docPath.startsWith("../")) {
                        while (docPath.startsWith("../")) {
                            docPath = docPath.substring("../".length());
                            referenceDocPath = referenceDocPath.substring(0, referenceDocPath.lastIndexOf(47));
                        }
                        referenceDocPath = String.valueOf(referenceDocPath) + "/" + docPath;
                    } else if (docPath.startsWith("/")) {
                        int pIndex = referenceDocPath.indexOf("://");
                        if (pIndex == -1) {
                            pIndex = referenceDocPath.indexOf(":/");
                            referenceDocPath = referenceDocPath.substring(0, pIndex + 1);
                        } else {
                            referenceDocPath = referenceDocPath.substring(0, pIndex + 2);
                        }
                    } else {
                        referenceDocPath = docPath.indexOf(":/") != -1 ? docPath : String.valueOf(referenceDocPath) + "/" + docPath;
                    }
                    if (referenceDocPath.endsWith("/")) {
                        referenceDocPath = referenceDocPath.substring(0, referenceDocPath.length() - 1);
                    }
                    JavadocClassInfoLoader.setPackageDocumentationRoot(packageName, referenceDocPath);
                } else {
                    index = type.indexOf(34);
                    endString = type.substring(type.indexOf(62) + 1);
                    int aIndex = endString.indexOf("</A>");
                    String startString = String.valueOf(modifiers) + endString.substring(0, aIndex);
                    analysisStart = startString.length();
                    type = String.valueOf(startString) + endString.substring(aIndex + "</A>".length());
                }
                pType = type;
                continue;
            }
            analysisStart = modifiers.length() + 1;
        }
        return pType.replaceAll(" +", " ").replaceAll(" +", " ");
    }

    protected static String removeTags(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        int count = 0;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    ++count;
                    break;
                }
                case '>': {
                    --count;
                    break;
                }
                default: {
                    if (count != 0) break;
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    protected static void setPackageDocumentationRoot(String packageName, String documentationRoot) {
        packageToDocumentationRootMap.put(packageName, documentationRoot);
    }

    protected static void removePackageDocumentationRoot(String packageName) {
        packageToDocumentationRootMap.remove(packageName);
    }

    protected static String[] getPackageNames() {
        return packageToDocumentationRootMap.keySet().toArray(new String[0]);
    }

    protected static void clearPackageDocumentationRootInformation() {
        packageToDocumentationRootMap.clear();
    }

    protected static String getPackageDocumentationRoot(String packageName) {
        int index = packageName.length();
        while (index >= 0) {
            String documentationRoot = (String)packageToDocumentationRootMap.get(packageName.substring(0, index));
            if (documentationRoot != null) {
                return documentationRoot;
            }
            index = packageName.lastIndexOf(46, index - 1);
        }
        return null;
    }

    public static void destroyClassInfo(ClassInfo classInfo) {
    }
}

