/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui;

import chrriis.udoc.model.ClassInfo;
import java.util.regex.Pattern;

public class Filter {
    protected String namePattern;
    protected boolean isRegularExpression;
    protected Pattern pattern;
    protected int modifiers;
    protected int hashCode;

    public Filter(String namePattern) {
        this(namePattern, false, 0);
    }

    public Filter(String namePattern, boolean isRegularExpression, int modifiers) {
        if (isRegularExpression) {
            this.pattern = Pattern.compile(namePattern);
            this.hashCode = namePattern.hashCode() + modifiers;
        } else {
            String regExp = "\\Q" + namePattern.replace("\\E", "\\\\E").replace("\\Q", "\\\\Q").replace("?", "\\E.\\Q").replace("*", "\\E.*\\Q");
            this.hashCode = regExp.hashCode() + modifiers;
            this.pattern = Pattern.compile(regExp);
        }
        this.namePattern = namePattern;
        this.isRegularExpression = isRegularExpression;
        this.modifiers = modifiers;
    }

    public boolean matches(ClassInfo classInfo) {
        return (this.modifiers == 0 || (classInfo.getModifiers() & this.modifiers) != 0) && this.pattern.matcher(classInfo.getClassName()).matches();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public boolean isRegularExpression() {
        return this.isRegularExpression;
    }

    public int getModifiers() {
        return this.modifiers;
    }
}

