/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class LayeredIcon
extends ImageIcon {
    protected List iconList = new ArrayList();
    protected List positionsList = new ArrayList();
    protected int width;
    protected int height;
    protected Component component;
    protected int lastTopPosition;
    protected int lastBottomPosition;
    protected ImageObserver observer;
    protected Image currentImage;

    public LayeredIcon(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public void paintIcon(Component component, Graphics g, int x, int y) {
        this.component = component;
        int i = 0;
        while (i < this.iconList.size()) {
            Point position = (Point)this.positionsList.get(i);
            ((Icon)this.iconList.get(i)).paintIcon(component, g, x + position.x, y + position.y);
            ++i;
        }
    }

    public void addTopDecorationIcon(Icon icon) {
        int offsetX = 0;
        switch (this.lastTopPosition++) {
            case 0: {
                offsetX += 15;
                break;
            }
            case 1: {
                offsetX += 8;
                break;
            }
            case 2: {
                ++offsetX;
            }
        }
        this.addIcon(icon, new Point(offsetX, 0));
    }

    public void addBottomDecorationIcon(Icon icon) {
        int offsetX = 0;
        switch (this.lastBottomPosition++) {
            case 0: {
                offsetX += 15;
                break;
            }
            case 1: {
                offsetX += 8;
                break;
            }
            case 2: {
                ++offsetX;
            }
        }
        this.addIcon(icon, new Point(offsetX, 7));
    }

    public void addIcon(Icon icon) {
        this.addIcon(icon, new Point(0, 0));
    }

    public void addIcon(Icon icon, Point position) {
        if (icon instanceof ImageIcon) {
            if (this.observer == null) {
                this.observer = new ImageObserver(){

                    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                        if (LayeredIcon.this.component != null) {
                            LayeredIcon.this.currentImage = img;
                            boolean result = LayeredIcon.this.component.imageUpdate(img, infoflags, x, y, width, height);
                            LayeredIcon.this.currentImage = null;
                            return result;
                        }
                        return false;
                    }
                };
            }
            ((ImageIcon)icon).setImageObserver(this.observer);
        }
        this.iconList.add(icon);
        this.positionsList.add(position);
    }

    public Image getImage() {
        return this.currentImage;
    }
}

