/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui;

import chrriis.udoc.model.ClassInfoLoader;
import chrriis.udoc.model.ModelDescriptor;
import chrriis.udoc.model.Util;
import chrriis.udoc.model.processor.ClassProcessor;
import chrriis.udoc.model.processor.ClassProcessorRegistry;
import chrriis.udoc.ui.ClassComponent;
import chrriis.udoc.ui.ClassPane;
import chrriis.udoc.ui.Filter;
import java.awt.Dimension;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Workspace {
    protected static String getVisibility(int visibility) {
        switch (visibility) {
            case 1: {
                return "public";
            }
            case 2: {
                return "protected";
            }
            case 3: {
                return "default";
            }
        }
        return "private";
    }

    protected static int getVisibility(String visibility) {
        if ("public".equals(visibility)) {
            return 1;
        }
        if ("protected".equals(visibility)) {
            return 2;
        }
        if ("default".equals(visibility)) {
            return 3;
        }
        return 4;
    }

    public static String getXMLDescription(ClassPane classPane) {
        String className;
        StringBuffer sb = new StringBuffer();
        sb.append("<workspace>");
        sb.append(ModelDescriptor.getXMLDescription());
        sb.append("<desktop>");
        ClassProcessor lastClassProcessor = classPane.getLastClassProcessor();
        if (lastClassProcessor != null) {
            sb.append("<selection classes=\"").append(Util.escapeXML(classPane.getLastClassNames())).append("\" classProcessor=\"").append(Util.escapeXML(lastClassProcessor.getProcessorID())).append("\"/>");
        }
        Filter[] filters = classPane.getFilters();
        sb.append("<filters fieldVisibility=\"").append(Util.escapeXML(Workspace.getVisibility(classPane.getFieldVisibility()))).append("\" methodVisibility=\"").append(Util.escapeXML(Workspace.getVisibility(classPane.getMethodVisibility()))).append("\">");
        int i = 0;
        while (i < filters.length) {
            Filter filter = filters[i];
            int modifiers = filter.getModifiers();
            sb.append("<filter pattern=\"").append(Util.escapeXML(filter.getNamePattern())).append("\" class=\"").append((modifiers & 0x100) != 0).append("\" interface=\"").append((modifiers & 0x40) != 0).append("\" regularExpression=\"").append(filter.isRegularExpression()).append("\"/>");
            ++i;
        }
        sb.append("</filters>");
        sb.append("<components>");
        ClassComponent[] classComponents = classPane.getClassComponents();
        int i2 = 0;
        while (i2 < classComponents.length) {
            ClassComponent classComponent = classComponents[i2];
            className = classComponent.getClassInfo().getClassName();
            Dimension size = classComponent.getSize();
            sb.append("<component class=\"").append(Util.escapeXML(className)).append("\" width=\"").append(size.width).append("\" height=\"").append(size.height);
            Dimension expandedPreferredSize = classComponent.getExpandedPreferredSize();
            if (expandedPreferredSize != null) {
                sb.append("\" expandedPreferredWidth=\"").append(expandedPreferredSize.width).append("\" expandedPreferredHeight=\"").append(expandedPreferredSize.height);
            }
            sb.append("\" expanded=\"").append(classComponent.isExpanded()).append("\" superTypes=\"").append(classComponent.areSuperTypesVisible()).append("\" subTypes=\"").append(classComponent.areSubTypesVisible()).append("\" compositions=\"").append(classComponent.areCompositionsVisible()).append("\" associations=\"").append(classComponent.areAssociationsVisible()).append("\"/>");
            ++i2;
        }
        sb.append("</components>");
        sb.append("<classLocations>");
        String[] classNames = classPane.getLocatedClasses();
        int i3 = 0;
        while (i3 < classNames.length) {
            className = classNames[i3];
            Point location = classPane.getClassLocation(className);
            sb.append("<classLocation name=\"").append(Util.escapeXML(className)).append("\" x=\"").append(location.x).append("\" y=\"").append(location.y).append("\"/>");
            ++i3;
        }
        sb.append("</classLocations>");
        sb.append("</desktop>");
        sb.append("</workspace>");
        return sb.toString();
    }

    public static void clearWorkspace(ClassPane classPane) {
        ModelDescriptor.clearModel();
        Workspace.setXMLDescription(classPane, "<workspace><desktop><filters></filters><components></components></desktop></workspace>");
    }

    public static void setXMLDescription(ClassPane classPane, String description) {
        classPane.clearClassLocations();
        classPane.removeClassComponents(classPane.getClassComponents());
        try {
            String name;
            Node node;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(description.getBytes("UTF-8")));
            NodeList nodeList = document.getChildNodes().item(0).getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                node = nodeList.item(i);
                name = node.getNodeName();
                if ("model".equals(name)) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    DOMSource source = new DOMSource(node);
                    StreamResult result = new StreamResult(out);
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.transform(source, result);
                    ModelDescriptor.setXMLDescription(new String(out.toByteArray(), "UTF-8"));
                }
                ++i;
            }
            i = 0;
            while (i < nodeList.getLength()) {
                node = nodeList.item(i);
                name = node.getNodeName();
                if ("desktop".equals(name)) {
                    Workspace.loadDesktop(classPane, node.getChildNodes());
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        classPane.adjustBounds();
        classPane.revalidate();
        classPane.repaint();
    }

    protected static void loadDesktop(ClassPane classPane, NodeList nodeList) {
        int i = 0;
        while (i < nodeList.getLength()) {
            ClassProcessor classProcessor;
            Node node = nodeList.item(i);
            String name = node.getNodeName();
            if ("filters".equals(name)) {
                Node fieldVisibilityNode = node.getAttributes().getNamedItem("fieldVisibility");
                if (fieldVisibilityNode != null) {
                    classPane.setFieldVisibility(Workspace.getVisibility(fieldVisibilityNode.getNodeValue()));
                } else {
                    classPane.setFieldVisibility(Workspace.getVisibility(null));
                }
                Node methodVisibilityNode = node.getAttributes().getNamedItem("methodVisibility");
                if (methodVisibilityNode != null) {
                    classPane.setMethodVisibility(Workspace.getVisibility(methodVisibilityNode.getNodeValue()));
                } else {
                    classPane.setMethodVisibility(Workspace.getVisibility(null));
                }
                Workspace.loadFilters(classPane, node.getChildNodes());
            } else if ("components".equals(name)) {
                Workspace.loadComponents(classPane, node.getChildNodes());
            } else if ("classLocations".equals(name)) {
                Workspace.loadClassLocations(classPane, node.getChildNodes());
            } else if ("selection".equals(name) && (classProcessor = ClassProcessorRegistry.getClassProcessor(node.getAttributes().getNamedItem("classProcessor").getNodeValue())) != null) {
                classPane.setLastClassNames(node.getAttributes().getNamedItem("classes").getNodeValue());
                classPane.setLastClassProcessor(classProcessor);
            }
            ++i;
        }
    }

    protected static void loadFilters(ClassPane classPane, NodeList nodeList) {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String name = node.getNodeName();
            if ("filter".equals(name)) {
                String pattern = node.getAttributes().getNamedItem("pattern").getNodeValue();
                String isClass = node.getAttributes().getNamedItem("class").getNodeValue();
                String isInterface = node.getAttributes().getNamedItem("interface").getNodeValue();
                String isRegular = node.getAttributes().getNamedItem("regularExpression").getNodeValue();
                int modifiers = 0;
                if ("true".equals(isClass)) {
                    modifiers |= 0x100;
                }
                if ("true".equals(isInterface)) {
                    modifiers |= 0x40;
                }
                filterList.add(new Filter(pattern, "true".equals(isRegular), modifiers));
            }
            ++i;
        }
        classPane.setFilters(filterList.toArray(new Filter[0]));
    }

    protected static void loadComponents(ClassPane classPane, NodeList nodeList) {
        ArrayList<1> relationRunnableList = new ArrayList<1>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String name = node.getNodeName();
            if ("component".equals(name)) {
                NamedNodeMap attributes = node.getAttributes();
                String className = attributes.getNamedItem("class").getNodeValue();
                String width = attributes.getNamedItem("width").getNodeValue();
                String height = attributes.getNamedItem("height").getNodeValue();
                Node expandedPreferredWidthNode = attributes.getNamedItem("expandedPreferredWidth");
                Node expandedPreferredHeightNode = attributes.getNamedItem("expandedPreferredHeight");
                Dimension expandedPreferredSize = expandedPreferredWidthNode != null && expandedPreferredHeightNode != null ? new Dimension(Integer.parseInt(expandedPreferredWidthNode.getNodeValue()), Integer.parseInt(expandedPreferredHeightNode.getNodeValue())) : null;
                final String isExpanded = attributes.getNamedItem("expanded").getNodeValue();
                final String areSuperTypesVisible = attributes.getNamedItem("superTypes").getNodeValue();
                final String areSubTypesVisible = attributes.getNamedItem("subTypes").getNodeValue();
                final String areCompositionsVisible = attributes.getNamedItem("compositions").getNodeValue();
                final String areAssociationsVisible = attributes.getNamedItem("associations").getNodeValue();
                final ClassComponent classComponent = new ClassComponent(classPane, ClassInfoLoader.getClassInfo(className));
                classPane.addClassComponent(classComponent);
                classComponent.setExpandedPreferredSize(expandedPreferredSize);
                classComponent.setSize(Integer.parseInt(width), Integer.parseInt(height));
                relationRunnableList.add(new Runnable(){

                    public void run() {
                        if ("true".equals(isExpanded)) {
                            classComponent.setExpanded(true);
                        }
                        if ("true".equals(areSuperTypesVisible)) {
                            classComponent.setRelationsVisible(true, 1);
                        }
                        if ("true".equals(areSubTypesVisible)) {
                            classComponent.setRelationsVisible(true, 2);
                        }
                        if ("true".equals(areCompositionsVisible)) {
                            classComponent.setRelationsVisible(true, 3);
                        }
                        if ("true".equals(areAssociationsVisible)) {
                            classComponent.setRelationsVisible(true, 4);
                        }
                    }
                });
            }
            ++i;
        }
        i = 0;
        while (i < relationRunnableList.size()) {
            ((Runnable)relationRunnableList.get(i)).run();
            ++i;
        }
    }

    protected static void loadClassLocations(ClassPane classPane, NodeList nodeList) {
        ArrayList<String> classNameList = new ArrayList<String>();
        ArrayList<Point> locationList = new ArrayList<Point>();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String name = node.getNodeName();
            if ("classLocation".equals(name)) {
                NamedNodeMap attributes = node.getAttributes();
                String className = attributes.getNamedItem("name").getNodeValue();
                String x = attributes.getNamedItem("x").getNodeValue();
                String y = attributes.getNamedItem("y").getNodeValue();
                Point location = new Point(Integer.parseInt(x), Integer.parseInt(y));
                classNameList.add(className);
                locationList.add(location);
                ClassComponent classComponent = classPane.getClassComponent(className);
                if (classComponent != null) {
                    classComponent.setLocation(location);
                }
            }
            ++i;
        }
        classPane.setClassLocations(classNameList.toArray(new String[0]), locationList.toArray(new Point[0]));
        classPane.revalidate();
        classPane.repaint();
    }
}

