/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui.layout;

import chrriis.udoc.model.ClassInfo;
import chrriis.udoc.ui.ClassComponent;
import chrriis.udoc.ui.ClassPane;
import chrriis.udoc.ui.layout.Edge;
import chrriis.udoc.ui.layout.Node;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LayoutHandler {
    protected static final double MAX_NODE_MOVEMENT = 200.0;
    protected static final double MIN_DIAGRAM_SIZE = 1.0;
    protected static final double MAX_REPULSIVE_FORCE_DISTANCE = 1000.0;
    protected static final double K = 1000.0;
    protected static final double C = 100.0;
    protected static final int SPRING_EMBEDDER_ITERATIONS = 1000;
    protected static final double SUPER_TYPE_WEIGHT = 2.0;
    protected static final double SUB_TYPE_WEIGHT = 1.0;
    protected static final double COMPOSITION_WEIGHT = 1.5;
    protected static final double ASSOCIATION_WEIGHT = 1.0;
    protected Map nodeMap = new HashMap();
    protected Map edgeMap = new HashMap();

    protected LayoutHandler() {
    }

    public static void adjust(ClassPane classPane) {
        new LayoutHandler().adjustLayout(classPane);
    }

    protected void addEdges(ClassPane classPane, Rectangle areaBounds, Node sourceNode, ClassInfo[] classInfos) {
        int j = 0;
        while (j < classInfos.length) {
            ClassComponent classComponent = classPane.getClassComponent(classInfos[j]);
            if (classComponent != null && classComponent.isVisible()) {
                double x = (double)(classComponent.getX() - areaBounds.x) / (double)(areaBounds.x - areaBounds.width) * 2.0;
                double y = (double)(classComponent.getY() - areaBounds.y) / (double)(areaBounds.y - areaBounds.height) * 2.0;
                Node targetNode = new Node(classComponent, x, y);
                this.addEdge(sourceNode, targetNode, 2.0);
            }
            ++j;
        }
    }

    protected void adjustLayout(ClassPane classPane) {
        ClassComponent[] classComponents = classPane.getClassComponents();
        int i = 0;
        while (i < classComponents.length) {
            ClassComponent classComponent = classComponents[i];
            if (classComponent.isVisible()) {
                ClassInfo classInfo = classComponent.getClassInfo();
                Rectangle areaBounds = classPane.getClassComponentAreaBounds();
                double x = (double)(classComponent.getX() - areaBounds.x) / (double)(areaBounds.x - areaBounds.width) * 2.0;
                double y = (double)(classComponent.getY() - areaBounds.y) / (double)(areaBounds.y - areaBounds.height) * 2.0;
                Node sourceNode = new Node(classComponent, x, y);
                this.addNode(sourceNode);
                this.addEdges(classPane, areaBounds, sourceNode, classInfo.getSuperTypes());
                this.addEdges(classPane, areaBounds, sourceNode, classInfo.getSubTypes());
                this.addEdges(classPane, areaBounds, sourceNode, classInfo.getCompositions());
                this.addEdges(classPane, areaBounds, sourceNode, classInfo.getAssociations());
            }
            ++i;
        }
        this.computeLayout(1000);
        this.adjustLocations(classPane, classComponents);
    }

    protected void adjustLocations(ClassPane classPane, ClassComponent[] classComponents) {
        int width;
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double maxWeight = 0.0;
        Set nodes = this.getLinkedNodeSet();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (node.getX() > maxX) {
                maxX = node.getX();
            }
            if (node.getX() < minX) {
                minX = node.getX();
            }
            if (node.getY() > maxY) {
                maxY = node.getY();
            }
            if (!(node.getY() < minY)) continue;
            minY = node.getY();
        }
        double minSize = 1.0;
        if (maxX - minX < minSize) {
            double midX = (maxX + minX) / 2.0;
            minX = midX - minSize / 2.0;
            maxX = midX + minSize / 2.0;
        }
        if (maxY - minY < minSize) {
            double midY = (maxY + minY) / 2.0;
            minY = midY - minSize / 2.0;
            maxY = midY + minSize / 2.0;
        }
        Iterator it2 = this.edgeMap.keySet().iterator();
        while (it2.hasNext()) {
            Edge edge = (Edge)it2.next();
            double weight = edge.getWeight();
            if (!(weight > maxWeight)) continue;
            maxWeight = weight;
        }
        int height = width = (int)Math.round(Math.sqrt(classComponents.length) * 170.0);
        double xyRatio = (maxX - minX) / (maxY - minY) / (double)(width / height);
        if (xyRatio > 1.0) {
            double dy = maxY - minY;
            dy = dy * xyRatio - dy;
            minY -= dy / 2.0;
            maxY += dy / 2.0;
        } else if (xyRatio < 1.0) {
            double dx = maxX - minX;
            dx = dx / xyRatio - dx;
            minX -= dx / 2.0;
            maxX += dx / 2.0;
        }
        Dimension classPaneSize = classPane.getSize();
        int xOffset = (width - classPaneSize.width) / 2 + 50;
        height = (int)Math.round(Math.sqrt(classComponents.length) * 3.0 / 4.0 * 170.0);
        int yOffset = (height - classPaneSize.height) / 2 + 25;
        int i = 0;
        while (i < classComponents.length) {
            ClassComponent classComponent = classComponents[i];
            if (classComponent.isVisible()) {
                Node node = (Node)this.nodeMap.get(new Node(classComponent, 0.0, 0.0));
                int x1 = (int)((double)width * (node.getX() - minX) / (maxX - minX));
                int y1 = (int)((double)height * (node.getY() - minY) / (maxY - minY));
                classComponent.setLocation(x1 - xOffset, y1 - yOffset);
            }
            ++i;
        }
        classPane.adjustBounds();
        classPane.revalidate();
        classPane.repaint();
    }

    protected Set getLinkedNodeSet() {
        HashSet<Node> linkedNodeSet = new HashSet<Node>();
        Iterator it = this.edgeMap.keySet().iterator();
        while (it.hasNext()) {
            Edge edge = (Edge)it.next();
            linkedNodeSet.add(edge.getSourceNode());
            linkedNodeSet.add(edge.getTargetNode());
        }
        return linkedNodeSet;
    }

    protected void computeLayout(int iterations) {
        Node[] nodes = this.getLinkedNodeSet().toArray(new Node[0]);
        Edge[] edges = this.edgeMap.keySet().toArray(new Edge[0]);
        double maxRepulsiveForceDistance = 1000.0;
        int it = 0;
        while (it < iterations) {
            double distance;
            double distanceSquared;
            double deltaY;
            double deltaX;
            int i = 0;
            while (i < nodes.length) {
                int j = i + 1;
                while (j < nodes.length) {
                    Node node1 = nodes[i];
                    Node node2 = nodes[j];
                    deltaX = node2.getX() - node1.getX();
                    distanceSquared = deltaX * deltaX + (deltaY = node2.getY() - node1.getY()) * deltaY;
                    if (distanceSquared < 0.01) {
                        deltaX = Math.random() / 10.0 + 0.1;
                        deltaY = Math.random() / 10.0 + 0.1;
                        distanceSquared = deltaX * deltaX + deltaY * deltaY;
                    }
                    if ((distance = Math.sqrt(distanceSquared)) < maxRepulsiveForceDistance) {
                        double repulsiveForce = 1000000.0 / distance;
                        node1.setFX(node1.getFX() - repulsiveForce * deltaX / distance);
                        node1.setFY(node1.getFY() - repulsiveForce * deltaY / distance);
                        node2.setFX(node2.getFX() + repulsiveForce * deltaX / distance);
                        node2.setFY(node2.getFY() + repulsiveForce * deltaY / distance);
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < edges.length) {
                Edge edge = edges[i];
                Node sourceNode = edge.getSourceNode();
                Node targetNode = edge.getTargetNode();
                deltaX = targetNode.getX() - sourceNode.getX();
                distanceSquared = deltaX * deltaX + (deltaY = targetNode.getY() - sourceNode.getY()) * deltaY;
                if (distanceSquared < 0.01) {
                    deltaX = Math.random() / 10.0 + 0.1;
                    deltaY = Math.random() / 10.0 + 0.1;
                    distanceSquared = deltaX * deltaX + deltaY * deltaY;
                }
                if ((distance = Math.sqrt(distanceSquared)) > maxRepulsiveForceDistance) {
                    distance = maxRepulsiveForceDistance;
                }
                distanceSquared = distance * distance;
                double attractiveForce = (distanceSquared - 1000000.0) / 1000.0;
                double weight = edge.getWeight();
                if (weight < 1.0) {
                    weight = 1.0;
                }
                targetNode.setFX(targetNode.getFX() - (attractiveForce *= Math.log(weight) * 0.5 + 1.0) * deltaX / distance);
                targetNode.setFY(targetNode.getFY() - attractiveForce * deltaY / distance);
                sourceNode.setFX(sourceNode.getFX() + attractiveForce * deltaX / distance);
                sourceNode.setFY(sourceNode.getFY() + attractiveForce * deltaY / distance);
                ++i;
            }
            i = 0;
            while (i < nodes.length) {
                Node node = nodes[i];
                double xMovement = 100.0 * node.getFX();
                double yMovement = 100.0 * node.getFY();
                double max = 200.0;
                if (xMovement > max) {
                    xMovement = max;
                } else if (xMovement < -max) {
                    xMovement = -max;
                }
                if (yMovement > max) {
                    yMovement = max;
                } else if (yMovement < -max) {
                    yMovement = -max;
                }
                node.setX(node.getX() + xMovement);
                node.setY(node.getY() + yMovement);
                node.setFX(0.0);
                node.setFY(0.0);
                ++i;
            }
            ++it;
        }
    }

    protected void addNode(Node node) {
        if (this.nodeMap.containsKey(node)) {
            node = (Node)this.nodeMap.get(node);
        } else {
            this.nodeMap.put(node, node);
        }
        node.setWeight(node.getWeight() + 1.0);
    }

    protected boolean addEdge(Node sourceNode, Node targetNode, double weight) {
        if (sourceNode.equals(targetNode) || weight <= 0.0) {
            return false;
        }
        this.addNode(sourceNode);
        this.addNode(targetNode);
        Edge edge = new Edge(sourceNode, targetNode);
        if (this.edgeMap.containsKey(edge)) {
            edge = (Edge)this.edgeMap.get(edge);
        } else {
            sourceNode = (Node)this.nodeMap.get(sourceNode);
            targetNode = (Node)this.nodeMap.get(targetNode);
            edge = new Edge(sourceNode, targetNode);
            this.edgeMap.put(edge, edge);
        }
        edge.setWeight(edge.getWeight() + weight);
        return true;
    }
}

