/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui.widgets;

import chrriis.udoc.model.FieldInfo;
import chrriis.udoc.model.Util;
import chrriis.udoc.ui.widgets.CodeComponent;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class FieldTooltip
extends JPanel {
    protected static final Color TOOLTIP_COLOR = new Color(255, 255, 160);
    protected static final Border BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(167, 166, 174)), BorderFactory.createEmptyBorder(1, 1, 1, 1));
    protected static final Color BACKGROUND_COLOR = new Color(255, 255, 160);

    public FieldTooltip(FieldInfo fieldInfo) {
        int i;
        BoxLayout boxLayout = new BoxLayout(this, 1);
        this.setLayout(boxLayout);
        this.setOpaque(true);
        this.setBorder(BORDER);
        this.setBackground(BACKGROUND_COLOR);
        String prototype = fieldInfo.getPrototype();
        ArrayList<String> tokenList = new ArrayList<String>();
        boolean isValid = true;
        while (isValid && prototype.startsWith("@")) {
            i = 0;
            while (isValid && i < prototype.length()) {
                int count = 0;
                char c = prototype.charAt(i);
                switch (c) {
                    case '(': {
                        ++count;
                        break;
                    }
                    case ')': {
                        --count;
                        break;
                    }
                    case ' ': {
                        if (count != 0) break;
                        String s = prototype.substring(0, i);
                        if (Util.getModifier(s) == -1) {
                            tokenList.add(s);
                            prototype = prototype.substring(i + 1);
                            i = 0;
                            break;
                        }
                        isValid = false;
                    }
                }
                ++i;
            }
        }
        tokenList.add(prototype);
        i = 0;
        while (i < tokenList.size()) {
            this.add(new CodeComponent((String)tokenList.get(i)));
            ++i;
        }
    }
}

