/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.model;

import chrriis.udoc.model.ClassInfo;
import chrriis.udoc.model.FieldInfo;
import chrriis.udoc.model.MethodInfo;
import chrriis.udoc.model.Util;
import chrriis.udoc.model.processor.ClassProcessor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClassInfoLoader {
    protected static final int METHOD_METHOD_TYPE = 1;
    protected static final int CONSTRUCTOR_METHOD_TYPE = 2;
    protected static final int ANNOTATION_METHOD_TYPE = 3;
    protected static HashMap classNameToClassInfoMap = new HashMap();

    protected static void loadClassInfo(ClassInfo classInfo, ClassProcessor classProcessor) {
        try {
            InputStream in = classProcessor.getClassInfoDataInputStream(classInfo.getClassName());
            if (in == null) {
                classInfo.setModifiers(classInfo.getModifiers() | 0x100000);
                return;
            }
            ClassInfoLoader.loadClassInfo(classInfo, classProcessor, in);
        }
        catch (Exception e) {
            e.printStackTrace();
            classInfo.setModifiers(classInfo.getModifiers() | 0x100000);
            return;
        }
        classInfo.setModifiers(classInfo.getModifiers() & 0xFFEFFFFF);
    }

    protected static void loadClassInfo(ClassInfo classInfo, ClassProcessor classProcessor, InputStream in) {
        try {
            String name;
            Node node;
            if (in == null) {
                return;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            NodeList nodeList = document.getChildNodes().item(0).getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                node = nodeList.item(i);
                name = node.getNodeName();
                if ("prototype".equals(name)) {
                    String prototype = node.getAttributes().getNamedItem("value").getNodeValue();
                    classInfo.setPrototype(prototype);
                    ClassInfoLoader.loadPrototypeInfo(classInfo, prototype);
                    break;
                }
                ++i;
            }
            i = 0;
            while (i < nodeList.getLength()) {
                node = nodeList.item(i);
                name = node.getNodeName();
                if (!"prototype".equals(name)) {
                    ClassInfoLoader.processClassNode(classInfo, nodeList.item(i), classProcessor);
                }
                ++i;
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void processClassNode(ClassInfo classInfo, Node node, ClassProcessor classProcessor) {
        String name = node.getNodeName();
        if ("superTypes".equals(name)) {
            ClassInfoLoader.loadSuperTypes(classInfo, node.getChildNodes(), classProcessor);
        } else if ("subTypes".equals(name)) {
            ClassInfoLoader.loadSubTypes(classInfo, node.getChildNodes(), classProcessor);
        } else if ("enums".equals(name)) {
            ClassInfoLoader.loadFields(classInfo, node.getChildNodes(), classProcessor, true);
        } else if ("fields".equals(name)) {
            ClassInfoLoader.loadFields(classInfo, node.getChildNodes(), classProcessor, false);
        } else if ("methods".equals(name)) {
            ClassInfoLoader.loadMethods(classInfo, node.getChildNodes(), classProcessor, 1);
        } else if ("constructors".equals(name)) {
            ClassInfoLoader.loadMethods(classInfo, node.getChildNodes(), classProcessor, 2);
        } else if ("annotationMembers".equals(name)) {
            ClassInfoLoader.loadMethods(classInfo, node.getChildNodes(), classProcessor, 3);
        }
    }

    protected static void loadPrototypeInfo(ClassInfo classInfo, String prototype) {
        int index;
        char c;
        while (prototype.startsWith("@") && !prototype.startsWith("@interface ")) {
            int count = 0;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < prototype.length()) {
                c = prototype.charAt(i);
                switch (c) {
                    case '(': {
                        ++count;
                        sb.append(c);
                        break;
                    }
                    case ')': {
                        --count;
                        sb.append(c);
                        break;
                    }
                    case ' ': {
                        if (count != 0) break;
                        prototype = prototype.substring(i + 1);
                        i = prototype.length();
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                ++i;
            }
        }
        int modifiers = 0;
        while ((index = prototype.indexOf(32)) > 0) {
            String token = prototype.substring(0, index);
            int modifier = Util.getModifier(token);
            if (modifier < 0) break;
            modifiers |= modifier;
            prototype = prototype.substring(index + 1);
        }
        int count = 0;
        int i = 0;
        while (i < prototype.length()) {
            c = prototype.charAt(i);
            switch (c) {
                case '<': {
                    ++count;
                    break;
                }
                case '>': {
                    --count;
                }
            }
            String s = prototype.substring(i);
            if (count == 0 && (s.startsWith(" extends ") || s.startsWith(" implements "))) {
                prototype = prototype.substring(0, i).trim();
                break;
            }
            ++i;
        }
        String[] tokens = prototype.split("[<,]");
        HashSet<String> genericSet = new HashSet<String>();
        int i2 = 1;
        while (i2 < tokens.length) {
            String[] gTokens = tokens[i2].split("[ >]");
            int j = 0;
            while (j < gTokens.length) {
                String s = gTokens[j];
                if (s.length() > 0) {
                    genericSet.add(s);
                    break;
                }
                ++j;
            }
            ++i2;
        }
        classInfo.setDeclaration(prototype, genericSet.toArray(new String[0]));
        if ((modifiers & 0xB) == 0) {
            modifiers |= 4;
        }
        classInfo.setModifiers(modifiers);
    }

    protected static void loadSuperTypes(ClassInfo classInfo, NodeList nodeList, ClassProcessor classProcessor) {
        ArrayList<ClassInfo> list = new ArrayList<ClassInfo>(nodeList.getLength());
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String name = node.getNodeName();
            if ("superType".equals(name)) {
                String superTypePrototype = node.getAttributes().getNamedItem("value").getNodeValue();
                ClassInfo superTypeClassInfo = ClassInfoLoader.loadSuperTypeInfo(superTypePrototype, classProcessor);
                if (superTypeClassInfo.getPrototype() == null) {
                    superTypeClassInfo.setPrototype(superTypePrototype);
                }
                list.add(superTypeClassInfo);
            }
            ++i;
        }
        if (!list.isEmpty()) {
            classInfo.setSuperTypes(list.toArray(new ClassInfo[0]));
        }
    }

    protected static ClassInfo loadSuperTypeInfo(String prototype, ClassProcessor classProcessor) {
        ClassInfo classInfo;
        int index;
        int modifiers = 0;
        while ((index = prototype.indexOf(32)) > 0) {
            String token = prototype.substring(0, index);
            int modifier = Util.getModifier(token);
            if (modifier < 0) break;
            modifiers |= modifier;
            prototype = prototype.substring(index + 1);
        }
        String className = prototype;
        int index2 = className.indexOf(60);
        if (index2 >= 0) {
            className = className.substring(0, index2);
        }
        if (!(classInfo = ClassInfoLoader.createClassInfo(className, classProcessor)).isLoaded()) {
            String[] tokens = prototype.split("[<,]");
            HashSet<String> genericSet = new HashSet<String>();
            int i = 1;
            while (i < tokens.length) {
                String[] gTokens = tokens[i].split("[ >]");
                int j = 0;
                while (j < gTokens.length) {
                    String s = gTokens[j];
                    if (s.length() > 0) {
                        genericSet.add(s);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            classInfo.setDeclaration(prototype, genericSet.toArray(new String[0]));
            if ((modifiers & 0xB) == 0) {
                modifiers |= 4;
            }
            classInfo.setModifiers(modifiers);
        }
        return classInfo;
    }

    protected static void loadSubTypes(ClassInfo classInfo, NodeList nodeList, ClassProcessor classProcessor) {
        ArrayList<ClassInfo> list = new ArrayList<ClassInfo>(nodeList.getLength());
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String name = node.getNodeName();
            if ("subType".equals(name)) {
                String subTypePrototype = node.getAttributes().getNamedItem("value").getNodeValue();
                ClassInfo subTypeClassInfo = ClassInfoLoader.loadSubTypeInfo(subTypePrototype, classProcessor);
                if (subTypeClassInfo.getPrototype() == null) {
                    subTypeClassInfo.setPrototype(subTypePrototype);
                }
                list.add(subTypeClassInfo);
            }
            ++i;
        }
        if (!list.isEmpty()) {
            classInfo.setSubTypes(list.toArray(new ClassInfo[0]));
        }
    }

    protected static ClassInfo loadSubTypeInfo(String prototype, ClassProcessor classProcessor) {
        ClassInfo classInfo;
        int index;
        int modifiers = 0;
        while ((index = prototype.indexOf(32)) > 0) {
            String token = prototype.substring(0, index);
            int modifier = Util.getModifier(token);
            if (modifier < 0) break;
            modifiers |= modifier;
            prototype = prototype.substring(index + 1);
        }
        String className = prototype;
        int index2 = className.indexOf(60);
        if (index2 >= 0) {
            className = className.substring(0, index2);
        }
        if (!(classInfo = ClassInfoLoader.createClassInfo(className, classProcessor)).isLoaded()) {
            String[] tokens = prototype.split("[<,]");
            HashSet<String> genericSet = new HashSet<String>();
            int i = 1;
            while (i < tokens.length) {
                String[] gTokens = tokens[i].split("[ >]");
                int j = 0;
                while (j < gTokens.length) {
                    String s = gTokens[j];
                    if (s.length() > 0) {
                        genericSet.add(s);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            classInfo.setDeclaration(prototype, genericSet.toArray(new String[0]));
            if ((modifiers & 0xB) == 0) {
                modifiers |= 4;
            }
            classInfo.setModifiers(modifiers);
        }
        return classInfo;
    }

    protected static void loadFields(ClassInfo classInfo, NodeList nodeList, ClassProcessor classProcessor, boolean isEnum) {
        ArrayList<FieldInfo> list = new ArrayList<FieldInfo>(nodeList.getLength());
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String name = node.getNodeName();
            if ("field".equals(name) || "enum".equals(name)) {
                String fieldInfoPrototype = node.getAttributes().getNamedItem("value").getNodeValue();
                FieldInfo fieldInfo = ClassInfoLoader.loadFieldInfo(classInfo, fieldInfoPrototype, classProcessor);
                if (fieldInfo.getPrototype() == null) {
                    fieldInfo.setPrototype(fieldInfoPrototype);
                }
                list.add(fieldInfo);
            }
            ++i;
        }
        if (!list.isEmpty()) {
            FieldInfo[] fields = list.toArray(new FieldInfo[0]);
            Arrays.sort(fields, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((FieldInfo)o1).getName().toLowerCase(Locale.ENGLISH).compareTo(((FieldInfo)o2).getName().toLowerCase(Locale.ENGLISH));
                }
            });
            if (isEnum) {
                classInfo.setEnums(fields);
            } else {
                classInfo.setFields(fields);
            }
        }
    }

    protected static FieldInfo loadFieldInfo(ClassInfo classInfo, String prototype, ClassProcessor classProcessor) {
        int index;
        ArrayList<ClassInfo> annotationList = new ArrayList<ClassInfo>();
        while (prototype.startsWith("@") && !prototype.startsWith("@interface ")) {
            int count = 0;
            boolean hasParameters = false;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < prototype.length()) {
                char c = prototype.charAt(i);
                switch (c) {
                    case '(': {
                        ++count;
                        sb.append(c);
                        hasParameters = true;
                        break;
                    }
                    case ')': {
                        --count;
                        sb.append(c);
                        break;
                    }
                    case ' ': {
                        if (count != 0) break;
                        prototype = prototype.substring(i + 1);
                        i = prototype.length();
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                ++i;
            }
            String annotationClassName = sb.toString();
            annotationClassName = hasParameters ? annotationClassName.substring(1, annotationClassName.indexOf(40)) : annotationClassName.substring(1);
            annotationList.add(ClassInfoLoader.createClassInfo(annotationClassName, classProcessor));
        }
        int modifiers = 0;
        while ((index = prototype.indexOf(32)) > 0) {
            String token = prototype.substring(0, index);
            int modifier = Util.getModifier(token);
            if (modifier < 0) break;
            modifiers |= modifier;
            prototype = prototype.substring(index + 1);
        }
        index = prototype.lastIndexOf(32);
        String fieldName = prototype.substring(index + 1);
        prototype = prototype.substring(0, index);
        if ((modifiers & 0xB) == 0) {
            modifiers |= 4;
        }
        FieldInfo fieldInfo = new FieldInfo(classInfo, null, prototype, fieldName, modifiers, classProcessor);
        fieldInfo.setAnnotations(annotationList.toArray(new ClassInfo[0]));
        return fieldInfo;
    }

    protected static void loadMethods(ClassInfo classInfo, NodeList nodeList, ClassProcessor classProcessor, int methodType) {
        ArrayList<MethodInfo> list = new ArrayList<MethodInfo>(nodeList.getLength());
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String name = node.getNodeName();
            if ("method".equals(name) || "constructor".equals(name) || "annotationMember".equals(name)) {
                String methodInfoPrototype = node.getAttributes().getNamedItem("value").getNodeValue();
                MethodInfo methodInfo = ClassInfoLoader.loadMethodInfo(classInfo, methodInfoPrototype, node, classProcessor);
                if (methodInfo.getPrototype() == null) {
                    methodInfo.setPrototype(methodInfoPrototype);
                }
                list.add(methodInfo);
            }
            ++i;
        }
        if (!list.isEmpty()) {
            MethodInfo[] methods = list.toArray(new MethodInfo[0]);
            Arrays.sort(methods, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((MethodInfo)o1).getName().toLowerCase(Locale.ENGLISH).compareTo(((MethodInfo)o2).getName().toLowerCase(Locale.ENGLISH));
                }
            });
            switch (methodType) {
                case 1: {
                    classInfo.setMethods(methods);
                    break;
                }
                case 2: {
                    classInfo.setConstructors(methods);
                    break;
                }
                case 3: {
                    classInfo.setAnnotationMembers(methods);
                }
            }
        }
    }

    protected static MethodInfo loadMethodInfo(ClassInfo classInfo, String prototype, Node node, ClassProcessor classProcessor) {
        boolean isConstructor;
        int index;
        ArrayList<ClassInfo> annotationList = new ArrayList<ClassInfo>();
        while (prototype.startsWith("@") && !prototype.startsWith("@interface ")) {
            int count = 0;
            boolean hasParameters = false;
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < prototype.length()) {
                char c = prototype.charAt(i);
                switch (c) {
                    case '(': {
                        ++count;
                        sb.append(c);
                        hasParameters = true;
                        break;
                    }
                    case ')': {
                        --count;
                        sb.append(c);
                        break;
                    }
                    case ' ': {
                        if (count != 0) break;
                        prototype = prototype.substring(i + 1);
                        i = prototype.length();
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                ++i;
            }
            String annotationClassName = sb.toString();
            annotationClassName = hasParameters ? annotationClassName.substring(1, annotationClassName.indexOf(40)) : annotationClassName.substring(1);
            annotationList.add(ClassInfoLoader.createClassInfo(annotationClassName, classProcessor));
        }
        int modifiers = 0;
        while ((index = prototype.indexOf(32)) > 0) {
            String token = prototype.substring(0, index);
            int modifier = Util.getModifier(token);
            if (modifier < 0) break;
            modifiers |= modifier;
            prototype = prototype.substring(index + 1);
        }
        String methodName = prototype;
        int index2 = prototype.lastIndexOf(32, prototype.indexOf(40));
        boolean bl = isConstructor = index2 < 0;
        if (!isConstructor) {
            methodName = methodName.substring(index2 + 1);
            prototype = prototype.substring(0, index2);
        }
        index2 = methodName.indexOf(" throws ");
        String exceptionsString = null;
        if (index2 >= 0) {
            exceptionsString = methodName.substring(index2 + " throws ".length());
            methodName = methodName.substring(0, index2);
        }
        index2 = methodName.indexOf(40);
        String parametersString = methodName.substring(index2 + 1, methodName.length() - 1);
        methodName = methodName.substring(0, index2);
        HashSet<String> genericSet = new HashSet<String>();
        if (prototype.startsWith("<")) {
            int count = 1;
            int i = 0;
            i = 1;
            while (count > 0 && i < prototype.length()) {
                switch (prototype.charAt(i)) {
                    case '<': {
                        ++count;
                        break;
                    }
                    case '>': {
                        --count;
                    }
                }
                ++i;
            }
            if (count == 0) {
                String[] tokens = prototype.substring(0, i).split("[<,]");
                int k = 1;
                while (k < tokens.length) {
                    String[] gTokens = tokens[k].split("[ >]");
                    int j = 0;
                    while (j < gTokens.length) {
                        String s = gTokens[j];
                        if (s.length() > 0) {
                            genericSet.add(s);
                            break;
                        }
                        ++j;
                    }
                    ++k;
                }
                prototype = prototype.substring(i).trim();
            }
        }
        String[] generics = genericSet.toArray(new String[0]);
        if ((modifiers & 0xB) == 0) {
            modifiers |= 4;
        }
        MethodInfo methodInfo = new MethodInfo(classInfo, methodName, modifiers, generics);
        FieldInfo[] exceptionsParameterInfo = null;
        if (exceptionsString != null) {
            StringTokenizer st = new StringTokenizer(exceptionsString, ",");
            exceptionsParameterInfo = new FieldInfo[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                exceptionsParameterInfo[i] = new FieldInfo(classInfo, methodInfo, st.nextToken().trim(), classProcessor);
                ++i;
            }
        }
        FieldInfo[] parametersParameterInfo = null;
        if (parametersString.length() > 0) {
            ArrayList<String> parametersList = new ArrayList<String>();
            int count = 0;
            int i = 0;
            while (i < parametersString.length()) {
                char c = parametersString.charAt(i);
                switch (c) {
                    case '<': {
                        ++count;
                        break;
                    }
                    case '>': {
                        --count;
                        break;
                    }
                    case ',': {
                        if (count != 0) break;
                        String s = parametersString.substring(0, i).trim();
                        parametersList.add(s);
                        parametersString = parametersString.substring(i + 1).trim();
                        i = 0;
                    }
                }
                ++i;
            }
            parametersList.add(parametersString);
            parametersParameterInfo = new FieldInfo[parametersList.size()];
            i = 0;
            while (i < parametersParameterInfo.length) {
                String parameter = (String)parametersList.get(i);
                int sIndex = parameter.lastIndexOf(32);
                parametersParameterInfo[i] = new FieldInfo(classInfo, methodInfo, parameter.substring(0, sIndex), parameter.substring(sIndex + 1), classProcessor);
                ++i;
            }
        }
        FieldInfo returnedType = isConstructor ? null : new FieldInfo(classInfo, methodInfo, prototype, classProcessor);
        methodInfo.setMethodParameters(parametersParameterInfo, returnedType, exceptionsParameterInfo);
        methodInfo.setAnnotations(annotationList.toArray(new ClassInfo[0]));
        return methodInfo;
    }

    public static ClassInfo createClassInfo(String className, ClassProcessor classProcessor) {
        ClassInfo classInfo = (ClassInfo)classNameToClassInfoMap.get(className);
        if (classInfo == null) {
            classInfo = new ClassInfo(className, classProcessor);
            classNameToClassInfoMap.put(className, classInfo);
        }
        return classInfo;
    }

    public static void destroyClassInfo(ClassInfo classInfo) {
        classNameToClassInfoMap.remove(classInfo.getClassName());
        ClassProcessor classProcessor = classInfo.getClassProcessor();
        if (classProcessor != null) {
            classProcessor.destroyClassInfo(classInfo);
        }
    }

    public static ClassInfo[] getClassInfos() {
        return classNameToClassInfoMap.values().toArray(new ClassInfo[0]);
    }

    public static ClassInfo getClassInfo(String className) {
        return (ClassInfo)classNameToClassInfoMap.get(className);
    }

    protected static void setClassInfos(ClassInfo[] classInfos) {
        classNameToClassInfoMap.clear();
        int i = 0;
        while (i < classInfos.length) {
            ClassInfo classInfo = classInfos[i];
            classNameToClassInfoMap.put(classInfo.getClassName(), classInfo);
            ++i;
        }
    }
}

