/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.model.processor.binary;

import chrriis.udoc.model.Util;
import chrriis.udoc.model.processor.ClassProcessor;
import chrriis.udoc.model.processor.binary.BinaryParametersComponent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.util.TraceSignatureVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BinaryClassProcessor
extends ClassProcessor {
    protected String classPath;
    protected DefaultMutableTreeNode javadocNode;

    public String getProcessorID() {
        return "BinaryClassProcessor";
    }

    public String getProcessorName() {
        return "Binary";
    }

    public String getProcessorDescription() {
        return "Load class diagrams from \".class\" binary files";
    }

    public JComponent getParametersComponent() {
        return new BinaryParametersComponent(this);
    }

    protected InputStream getClassInputStream(String className) {
        int lastDotIndex = className.lastIndexOf(46);
        String cName = className.substring(lastDotIndex + 1);
        String subPath = String.valueOf(lastDotIndex == -1 ? cName : String.valueOf(className.substring(0, lastDotIndex + 1).replace('.', '/')) + cName) + ".class";
        String[] paths = this.getClassPath().split(Util.getPathSeparator());
        int i = 0;
        while (i < paths.length) {
            File file;
            String path = paths[i];
            if (path.length() != 0 && (file = new File(path)).exists()) {
                if (file.isFile()) {
                    try {
                        ZipEntry entry;
                        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
                        while ((entry = zin.getNextEntry()) != null) {
                            if (!subPath.equals(entry.getName())) continue;
                            return zin;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        return new BufferedInputStream(new FileInputStream(String.valueOf(path) + "/" + subPath));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        return this.getClass().getResourceAsStream("/" + subPath);
    }

    public InputStream getClassInfoDataInputStream(String className) {
        int lastDotIndex = className.lastIndexOf(46);
        final String cName = Util.unescapeClassName(className.substring(lastDotIndex + 1));
        InputStream in = this.getClassInputStream(className);
        if (in == null) {
            return null;
        }
        ClassReader classReader = null;
        try {
            classReader = new ClassReader(in);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        StringBuffer classSB = new StringBuffer();
        classSB.append("<type name=\"").append(Util.escapeXML(className)).append("\">");
        final StringBuffer prototypeSB = new StringBuffer();
        final ArrayList constructorList = new ArrayList();
        final ArrayList superTypeList = new ArrayList();
        final ArrayList methodList = new ArrayList();
        final ArrayList fieldList = new ArrayList();
        classReader.accept((ClassVisitor)new EmptyVisitor(){
            protected int classAccess;
            protected StringBuffer lastSB;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                block18: {
                    block17: {
                        boolean isClass;
                        this.classAccess = access &= 0xFFFFFFDF;
                        String eName = name.replace('/', '.');
                        prototypeSB.append(BinaryClassProcessor.getModifiers(access));
                        boolean bl = isClass = (access & 0x6200) == 0;
                        if (isClass) {
                            prototypeSB.append("class ");
                        }
                        prototypeSB.append(eName);
                        if (signature == null) break block17;
                        TraceSignatureVisitor visitor = new TraceSignatureVisitor(access);
                        new SignatureReader(signature).accept((SignatureVisitor)visitor);
                        String genericDeclaration = visitor.getDeclaration();
                        if (genericDeclaration == null) break block18;
                        prototypeSB.append(genericDeclaration);
                        int extendsIndex = -1;
                        int implementsIndex = -1;
                        int count = 0;
                        int i = 0;
                        while (i < genericDeclaration.length()) {
                            switch (genericDeclaration.charAt(i)) {
                                case '<': {
                                    ++count;
                                    break;
                                }
                                case '>': {
                                    --count;
                                    break;
                                }
                                default: {
                                    if (count != 0) break;
                                    String substring = genericDeclaration.substring(i);
                                    if (extendsIndex == -1 && substring.startsWith(" extends ")) {
                                        extendsIndex = i;
                                        break;
                                    }
                                    if (implementsIndex != -1 || !substring.startsWith(" implements ")) break;
                                    implementsIndex = i;
                                }
                            }
                            ++i;
                        }
                        if (extendsIndex != -1) {
                            BinaryClassProcessor.this.addTypes(genericDeclaration.substring(extendsIndex + " extends ".length(), implementsIndex != -1 ? implementsIndex : genericDeclaration.length()), superTypeList, "class ");
                        } else if (isClass) {
                            superTypeList.add("public class java.lang.Object");
                        }
                        if (implementsIndex == -1) break block18;
                        BinaryClassProcessor.this.addTypes(genericDeclaration.substring(implementsIndex + " implements ".length(), genericDeclaration.length()), superTypeList, "interface ");
                        break block18;
                    }
                    if ((access & 0x200) == 0 && superName != null) {
                        String sName = superName.replace('/', '.');
                        superTypeList.add("class " + sName);
                        prototypeSB.append(" extends " + sName);
                    }
                    if (interfaces != null) {
                        int i = 0;
                        while (i < interfaces.length) {
                            String sName = interfaces[i].replace('/', '.');
                            superTypeList.add("interface " + sName);
                            if (i == 0) {
                                if ((access & 0x200) == 0) {
                                    prototypeSB.append(" implements ");
                                } else {
                                    prototypeSB.append(" extends ");
                                }
                            } else {
                                prototypeSB.append(", ");
                            }
                            prototypeSB.append(sName);
                            ++i;
                        }
                    }
                }
                this.lastSB = prototypeSB;
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (this.lastSB != null) {
                    this.lastSB.insert(0, String.valueOf('@') + BinaryClassProcessor.getType(Type.getType((String)desc)) + ' ');
                }
                return super.visitAnnotation(desc, visible);
            }

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                if ((access & 0x1040) != 0) {
                    this.lastSB = null;
                    return super.visitField(access, name, desc, signature, value);
                }
                StringBuffer sb = new StringBuffer();
                sb.append(BinaryClassProcessor.getModifiers(access));
                if (signature == null) {
                    sb.append(BinaryClassProcessor.getType(Type.getType((String)desc))).append(' ').append(name);
                } else {
                    TraceSignatureVisitor visitor = new TraceSignatureVisitor(access);
                    new SignatureReader(signature).accept((SignatureVisitor)visitor);
                    String returnType = visitor.getReturnType();
                    if (returnType == null) {
                        this.lastSB = null;
                        return super.visitField(access, name, desc, signature, value);
                    }
                    sb.append(returnType).append(' ').append(name);
                }
                fieldList.add(sb);
                this.lastSB = sb;
                return super.visitField(access, name, desc, signature, value);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if ("<clinit>".equals(name) || (access & 0x1000) != 0) {
                    this.lastSB = null;
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }
                StringBuffer sb = new StringBuffer();
                if ((this.classAccess & 0x200) != 0 && (this.classAccess & 0x2000) == 0) {
                    access &= 0xFFFFFBFF;
                }
                sb.append(BinaryClassProcessor.getModifiers(access));
                boolean isConstructor = "<init>".equals(name);
                if (isConstructor) {
                    name = cName;
                }
                if (signature == null) {
                    if (!isConstructor) {
                        Type type = Type.getReturnType((String)desc);
                        sb.append(BinaryClassProcessor.getType(type)).append(' ');
                    }
                    sb.append(name).append('(');
                    Type[] argumentTypes = Type.getArgumentTypes((String)desc);
                    int i = 0;
                    while (i < argumentTypes.length) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(BinaryClassProcessor.getType(argumentTypes[i])).append(" arg" + i);
                        ++i;
                    }
                    sb.append(')');
                    if (exceptions != null) {
                        sb.append(" throws ");
                        i = 0;
                        while (i < exceptions.length) {
                            if (i > 0) {
                                sb.append(", ");
                            }
                            sb.append(Util.escapeClassName(exceptions[i]));
                            ++i;
                        }
                    }
                } else {
                    TraceSignatureVisitor visitor = new TraceSignatureVisitor(access);
                    new SignatureReader(signature).accept((SignatureVisitor)visitor);
                    String genericDeclaration = visitor.getDeclaration();
                    if (genericDeclaration.charAt(0) != '(') {
                        int index = genericDeclaration.indexOf(40);
                        sb.append(genericDeclaration.substring(0, index)).append(' ');
                        genericDeclaration = genericDeclaration.substring(index);
                    }
                    StringBuffer declarationSB = new StringBuffer(genericDeclaration.length() * 2);
                    int count = 0;
                    int iCount = 0;
                    int i = 0;
                    while (i < genericDeclaration.length()) {
                        char c = genericDeclaration.charAt(i);
                        switch (c) {
                            case '<': {
                                ++iCount;
                                declarationSB.append(c);
                                break;
                            }
                            case '>': {
                                --iCount;
                                declarationSB.append(c);
                                break;
                            }
                            case ',': {
                                if (iCount != 0) {
                                    declarationSB.append(c);
                                    break;
                                }
                            }
                            case ')': {
                                if (i > 1) {
                                    declarationSB.append(" arg").append(count++);
                                }
                            }
                            default: {
                                declarationSB.append(c);
                            }
                        }
                        ++i;
                    }
                    String genericReturnType = visitor.getReturnType();
                    String genericExceptions = visitor.getExceptions();
                    if (!isConstructor) {
                        sb.append(genericReturnType).append(' ');
                    }
                    sb.append(name).append(declarationSB.toString());
                    if (genericExceptions != null) {
                        sb.append(" throws ").append(genericExceptions);
                    }
                }
                if (isConstructor) {
                    constructorList.add(sb);
                } else {
                    methodList.add(sb);
                }
                this.lastSB = sb;
                return super.visitMethod(access, name, desc, signature, exceptions);
            }

            public void visit(String name, Object value) {
                super.visit(name, value);
            }

            public void visitEnum(String name, String desc, String value) {
                int index;
                if (this.lastSB != null && (index = this.lastSB.indexOf(" ")) > 0) {
                    if (name == null) {
                        name = "value";
                    }
                    if (this.lastSB.charAt(index - 1) == ')') {
                        this.lastSB.insert(index - 1, ", " + name + "=" + value);
                    } else {
                        this.lastSB.insert(index, "(" + name + "=" + value + ")");
                    }
                }
                super.visitEnum(name, desc, value);
            }
        }, 2);
        classSB.append("<prototype value=\"").append(Util.escapeXML(prototypeSB.toString())).append("\"/>");
        classSB.append("<superTypes>");
        int i = superTypeList.size() - 1;
        while (i >= 0) {
            classSB.append("<superType value=\"").append(Util.escapeXML((String)superTypeList.get(i))).append("\"/>");
            --i;
        }
        classSB.append("</superTypes>");
        classSB.append("<fields>");
        i = fieldList.size() - 1;
        while (i >= 0) {
            classSB.append("<field value=\"").append(Util.escapeXML(((StringBuffer)fieldList.get(i)).toString())).append("\"/>");
            --i;
        }
        classSB.append("</fields>");
        classSB.append("<constructors>");
        i = constructorList.size() - 1;
        while (i >= 0) {
            classSB.append("<constructor value=\"").append(Util.escapeXML(((StringBuffer)constructorList.get(i)).toString())).append("\"/>");
            --i;
        }
        classSB.append("</constructors>");
        classSB.append("<methods>");
        i = methodList.size() - 1;
        while (i >= 0) {
            classSB.append("<method value=\"").append(Util.escapeXML(((StringBuffer)methodList.get(i)).toString())).append("\"/>");
            --i;
        }
        classSB.append("</methods>");
        classSB.append("</type>");
        System.err.println(classSB);
        try {
            return new ByteArrayInputStream(classSB.toString().getBytes("UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static String getModifiers(int modifiers) {
        StringBuffer sb = new StringBuffer();
        if ((modifiers & 1) != 0) {
            sb.append("public ");
        }
        if ((modifiers & 4) != 0) {
            sb.append("protected ");
        }
        if ((modifiers & 2) != 0) {
            sb.append("private ");
        }
        if ((modifiers & 0x100) != 0) {
            sb.append("native ");
        }
        if ((modifiers & 8) != 0) {
            sb.append("static ");
        }
        if ((modifiers & 0x20) != 0) {
            sb.append("synchronized ");
        }
        if ((modifiers & 0x4000) != 0) {
            sb.append("enum ");
        } else if ((modifiers & 0x10) != 0) {
            sb.append("final ");
        }
        if ((modifiers & 0x80) != 0) {
            sb.append("transient ");
        }
        if ((modifiers & 0x40) != 0) {
            sb.append("volatile ");
        }
        if ((modifiers & 0x2000) != 0) {
            sb.append("@interface ");
        } else if ((modifiers & 0x200) != 0) {
            sb.append("interface ");
        } else if ((modifiers & 0x400) != 0) {
            sb.append("abstract ");
        }
        return sb.toString();
    }

    protected static String getType(Type type) {
        switch (type.getSort()) {
            case 0: {
                return "void";
            }
            case 1: {
                return "boolean";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "double";
            }
            case 10: {
                return type.getClassName();
            }
            case 9: {
                StringBuffer sb = new StringBuffer();
                sb.append(BinaryClassProcessor.getType(type.getElementType()));
                int i = type.getDimensions() - 1;
                while (i >= 0) {
                    sb.append("[]");
                    --i;
                }
                return sb.toString();
            }
        }
        return null;
    }

    protected void addTypes(String declaration, List list, String prefix) {
        StringBuffer sb = new StringBuffer();
        int count = 0;
        int i = 0;
        while (i < declaration.length()) {
            char c = declaration.charAt(i);
            switch (c) {
                case '<': {
                    ++count;
                    sb.append(c);
                    break;
                }
                case '>': {
                    --count;
                    sb.append(c);
                    break;
                }
                case ',': {
                    if (count == 0) {
                        String type = sb.toString().trim();
                        if (type.length() <= 0) break;
                        list.add(String.valueOf(prefix) + type);
                        sb = new StringBuffer();
                        break;
                    }
                    sb.append(c);
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        String type = sb.toString().trim();
        if (type.length() > 0) {
            list.add(String.valueOf(prefix) + type);
        }
    }

    public String getClassPath() {
        return this.classPath == null ? "" : this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String getXMLDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("<binaryClassProcessorParameter>");
        sb.append("<classPaths>");
        String[] classPaths = this.getClassPath().split(Util.getPathSeparator());
        int i = 0;
        while (i < classPaths.length) {
            sb.append("<classPath value=\"").append(Util.escapeXML(classPaths[i])).append("\"/>");
            ++i;
        }
        sb.append("</classPaths>");
        sb.append("</binaryClassProcessorParameter>");
        return sb.toString();
    }

    public void loadXMLDescription(String xmlDescription) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(xmlDescription.getBytes("UTF-8")));
            NodeList nodeList = document.getChildNodes().item(0).getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                String name = node.getNodeName();
                if ("classPaths".equals(name)) {
                    this.loadClassPaths(node.getChildNodes());
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void loadClassPaths(NodeList nodeList) {
        this.classPath = null;
        StringBuffer sb = new StringBuffer();
        String pathSeparator = Util.getPathSeparator();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            String name = node.getNodeName();
            if ("classPath".equals(name)) {
                if (i > 0) {
                    sb.append(pathSeparator);
                }
                sb.append(node.getAttributes().getNamedItem("value").getNodeValue());
            }
            ++i;
        }
        this.setClassPath(sb.toString());
    }

    public void loadClassBrowser(final JTree tree) {
        if (this.javadocNode != null) {
            tree.setModel(new DefaultTreeModel(this.javadocNode));
            return;
        }
        final String classPath = this.classPath;
        final DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getModel().getRoot();
        node.removeAllChildren();
        new Thread(){

            public void run() {
                String[] paths = BinaryClassProcessor.this.getClassPath().split(Util.getPathSeparator());
                int i = 0;
                while (i < paths.length) {
                    File file;
                    String path = paths[i];
                    if (path.length() != 0 && (file = new File(path)).exists()) {
                        if (file.isFile()) {
                            try {
                                ZipEntry entry;
                                ZipInputStream zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
                                while ((entry = zin.getNextEntry()) != null) {
                                    String name = entry.getName();
                                    if (!name.endsWith(".class")) continue;
                                    BinaryClassProcessor.addTreeClass(name.substring(0, name.length() - ".class".length()).replace('/', '.'), node);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            BinaryClassProcessor.addDirectoryContent(file, null, node);
                        }
                    }
                    ++i;
                }
                SwingUtilities.invokeLater(new Runnable(this, classPath, node, tree){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ String val$classPath;
                    private final /* synthetic */ DefaultMutableTreeNode val$node;
                    private final /* synthetic */ JTree val$tree;
                    {
                        this.this$1 = var1_1;
                        this.val$classPath = string;
                        this.val$node = defaultMutableTreeNode;
                        this.val$tree = jTree;
                    }

                    public void run() {
                        if (this.val$classPath == null ? 2.access$0(this.this$1).classPath != null : !this.val$classPath.equals(2.access$0(this.this$1).classPath)) {
                            return;
                        }
                        2.access$0(this.this$1).javadocNode = this.val$node;
                        this.val$tree.setModel(new DefaultTreeModel(2.access$0(this.this$1).javadocNode));
                    }
                });
            }

            static /* synthetic */ BinaryClassProcessor access$0(2 var0) {
                return var0.BinaryClassProcessor.this;
            }
        }.start();
    }

    protected static void addDirectoryContent(File directory, String currentPath, DefaultMutableTreeNode node) {
        File[] files = directory.listFiles();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            String name = file.getName();
            if (file.isDirectory()) {
                BinaryClassProcessor.addDirectoryContent(file, currentPath == null ? name : String.valueOf(currentPath) + "." + name, node);
            } else if (name.endsWith(".class")) {
                name = name.substring(0, name.length() - ".class".length());
                BinaryClassProcessor.addTreeClass(currentPath == null ? name : String.valueOf(currentPath) + "." + name, node);
            }
            ++i;
        }
    }

    protected static void addTreeClass(String className, DefaultMutableTreeNode node) {
        int index = className.indexOf(46);
        if (index != -1) {
            String packageName = className.substring(0, index);
            int i = node.getChildCount() - 1;
            while (i >= 0) {
                int comparison;
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
                String childPackageOrClassName = (String)childNode.getUserObject();
                int n = comparison = childNode.isLeaf() ? 1 : childPackageOrClassName.compareTo(packageName);
                if (comparison == 0) {
                    BinaryClassProcessor.addTreeClass(className.substring(index + 1), childNode);
                    return;
                }
                if (comparison < 0) {
                    childNode = new DefaultMutableTreeNode(packageName);
                    node.insert(childNode, i + 1);
                    BinaryClassProcessor.addTreeClass(className.substring(index + 1), childNode);
                    return;
                }
                --i;
            }
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(packageName);
            node.insert(childNode, 0);
            BinaryClassProcessor.addTreeClass(className.substring(index + 1), childNode);
            return;
        }
        int i = node.getChildCount() - 1;
        while (i >= 0) {
            int comparison;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            String childClassName = (String)childNode.getUserObject();
            int n = comparison = !childNode.isLeaf() ? -1 : childClassName.compareTo(className);
            if (comparison == 0) {
                return;
            }
            if (comparison < 0) {
                childNode = new DefaultMutableTreeNode(Util.unescapeClassName(className));
                node.insert(childNode, i + 1);
                return;
            }
            --i;
        }
        node.insert(new DefaultMutableTreeNode(Util.unescapeClassName(className)), 0);
    }
}

