/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.charts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.util.StringUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;

public final class ChartConfigUtil {
    private ChartConfigUtil() {
    }

    public static Color getBackgroundColor(String chartName) {
        return ConfigurationOptions.getConfigColorProperty("chart." + chartName + ".backgroundColor", "chart.backgroundColor", ChartImage.BACKGROUND_COLOR);
    }

    public static Color getPlotColor(String chartName) {
        return ConfigurationOptions.getConfigColorProperty("chart." + chartName + ".plotColor", "chart.plotColor", ChartImage.BACKGROUND_COLOR);
    }

    public static Dimension getDimension(String chartName, Dimension defaultDimension) {
        Integer width = ConfigurationOptions.getConfigIntegerProperty("chart." + chartName + ".width", "chart.width", new Integer(defaultDimension.width));
        Integer height = ConfigurationOptions.getConfigIntegerProperty("chart." + chartName + ".height", "chart.height", new Integer(defaultDimension.height));
        return new Dimension(width, height);
    }

    public static void configureStroke(String chartName, XYItemRenderer renderer, XYDataset data) {
        Float stroke = ConfigurationOptions.getConfigFloatProperty("chart." + chartName + ".lineStroke", "chart.lineStroke", null);
        if (stroke != null) {
            for (int i = 0; i < data.getSeriesCount(); ++i) {
                renderer.setSeriesStroke(i, new BasicStroke(stroke.floatValue()));
            }
        }
    }

    public static void configureShapes(String chartName, XYItemRenderer renderer) {
        if (renderer instanceof XYLineAndShapeRenderer) {
            Boolean showShapes = ConfigurationOptions.getConfigBooleanProperty("chart." + chartName + ".showShapes", "chart.showShapes", Boolean.FALSE);
            Boolean filledShapes = ConfigurationOptions.getConfigBooleanProperty("chart." + chartName + ".filledShapes", "chart.filledShapes", Boolean.FALSE);
            ((XYLineAndShapeRenderer)renderer).setBaseShapesVisible(showShapes);
            ((XYLineAndShapeRenderer)renderer).setBaseShapesFilled(filledShapes);
        }
    }

    public static void configureChartBackgroungImage(String chartName, JFreeChart chart) {
        String imageLocation = ConfigurationOptions.getConfigStringProperty("chart." + chartName + ".chartBackgroundImage.url", "chart.chartBackgroundImage.url", null);
        Float alpha = ConfigurationOptions.getConfigFloatProperty("chart." + chartName + ".chartBackgroundImage.transparency", "chart.chartBackgroundImage.transparency", new Float(0.35));
        if (StringUtils.isNotEmpty(imageLocation) && alpha != null) {
            Image image = null;
            try {
                image = new ImageIcon(new URL(imageLocation)).getImage();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (image != null) {
                chart.setBackgroundImageAlpha(alpha.floatValue());
                chart.setBackgroundImageAlignment(6);
                chart.setBackgroundImage(image);
            }
        }
    }

    public static void configurePlotImage(String chartName, JFreeChart chart) {
        String imageLocation = ConfigurationOptions.getConfigStringProperty("chart." + chartName + ".plotImage.url", "chart.plotImage.url", null);
        Float alpha = ConfigurationOptions.getConfigFloatProperty("chart." + chartName + ".plotImage.transparency", "chart.plotImage.transparency", new Float(0.35));
        if (StringUtils.isNotEmpty(imageLocation) && alpha != null) {
            Image image = null;
            try {
                image = new ImageIcon(new URL(imageLocation)).getImage();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (image != null) {
                Plot plot = chart.getPlot();
                plot.setBackgroundImageAlpha(alpha.floatValue());
                plot.setBackgroundImage(image);
            }
        }
    }

    public static void configureCopyrightNotice(String chartName, JFreeChart chart) {
        String copyrightTxt = ConfigurationOptions.getConfigStringProperty("chart." + chartName + ".copyright", "chart.copyright", null);
        Integer copyrightTxtSize = ConfigurationOptions.getConfigIntegerProperty("chart." + chartName + ".copyrightTextSize", "chart.copyrightTextSize", new Integer(9));
        if (StringUtils.isNotEmpty(copyrightTxt)) {
            TextTitle copyright = new TextTitle(copyrightTxt, new Font("SansSerif", 0, copyrightTxtSize));
            copyright.setPosition(RectangleEdge.BOTTOM);
            copyright.setHorizontalAlignment(HorizontalAlignment.RIGHT);
            chart.addSubtitle(copyright);
        }
    }
}

