/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.model;

import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.statcvs.model.Revision;

public class Author
implements Comparable {
    private final String name;
    private final SortedSet revisions = new TreeSet();
    private final SortedSet directories = new TreeSet();
    private String realName;
    private String homePageUrl;
    private String imageUrl;
    private String email;
    private String twitterUserName;
    private String twitterUserId;
    private boolean twitterIncludeHtml = false;
    private boolean twitterIncludeFlash = false;

    public Author(String name) {
        this.name = name;
        this.realName = name;
    }

    protected void addRevision(Revision revision) {
        this.revisions.add(revision);
        this.directories.add(revision.getFile().getDirectory());
    }

    public String getName() {
        return this.name;
    }

    public SortedSet getRevisions() {
        return this.revisions;
    }

    public SortedSet getDirectories() {
        return this.directories;
    }

    public int compareTo(Object o) {
        return this.name.compareTo(((Author)o).getName());
    }

    public String toString() {
        return this.realName + "(" + this.revisions.size() + " revisions)";
    }

    public String getHomePageUrl() {
        return this.homePageUrl;
    }

    public void setHomePageUrl(String homePageUrl) {
        this.homePageUrl = homePageUrl;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String realName) {
        if (realName != null) {
            this.realName = realName;
        }
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getTwitterUserName() {
        return this.twitterUserName;
    }

    public void setTwitterUserName(String twitterUserName) {
        this.twitterUserName = twitterUserName;
    }

    public String getTwitterUserId() {
        return this.twitterUserId;
    }

    public void setTwitterUserId(String twitterUserId) {
        this.twitterUserId = twitterUserId;
    }

    public boolean isTwitterIncludeHtml() {
        return this.twitterIncludeHtml;
    }

    public void setTwitterIncludeHtml(boolean twitterIncludeHtml) {
        this.twitterIncludeHtml = twitterIncludeHtml;
    }

    public boolean isTwitterIncludeFlash() {
        return this.twitterIncludeFlash;
    }

    public void setTwitterIncludeFlash(boolean twitterIncludeFlash) {
        this.twitterIncludeFlash = twitterIncludeFlash;
    }
}

