/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedSet;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.pages.NavigationNode;
import net.sf.statcvs.pages.Page;
import net.sf.statcvs.util.FileUtils;

public class RepoMapPageMaker {
    private static final int DAYS_FROM_LAST_DATE = 30;
    private static final String WEB_FILE_PATH = "web-files/";
    private static final String REPO_FILE = "repomap-data.txt";
    private final Date deadline;
    private final Date currentDate;
    private final ReportConfig config;
    private int indent = 0;

    public RepoMapPageMaker(ReportConfig config) {
        Calendar cal = Calendar.getInstance();
        if (config != null && config.getRepository() != null && config.getRepository().getLastDate() != null) {
            cal.setTime(config.getRepository().getLastDate());
        }
        this.currentDate = cal.getTime();
        cal.add(5, -30);
        this.deadline = cal.getTime();
        this.config = config;
    }

    public NavigationNode toFile() {
        Page page = this.config.createPage("repomap", Messages.getString("REPOMAP_TITLE"), Messages.getString("REPOMAP_TITLE"));
        page.addRawAttribute(Messages.getString("REPOMAP_START_DATE"), HTML.getDate(this.deadline));
        page.addRawAttribute(Messages.getString("REPOMAP_END_DATE"), HTML.getDate(this.currentDate));
        page.addRawContent("<p>" + Messages.getString("REPOMAP_DESCRIPTION") + "</p>");
        page.addRawContent("<p>" + this.getApplet() + "</p>");
        page.addRawContent("<p><small>This page uses <a href=\"http://jtreemap.sourceforge.net\">JTreeMap</a>.</small></p>");
        this.buildXmlForJTreeMap();
        return page;
    }

    private String getApplet() {
        return "<applet archive=\"./" + Messages.getString("JTREEMAP_JAR") + "\" code=\"net.sf.jtreemap.swing.example.JTreeMapAppletExample\"" + " width=\"940\" height=\"600\"><param name=\"dataFile\" value=\"" + REPO_FILE + "\"/>" + "<param name=\"viewTree\" value=\"true\"/>" + "<param name=\"showWeight\" value=\"true\"/>" + "<param name=\"valuePrefix\" value=\"Change:\"/>" + "<param name=\"weightPrefix\" value=\"LOC:\"/>" + "<param name=\"dataFileType\" value=\"xml\"/>" + "<param name=\"colorProvider\" value=\"HSBLog\"/>" + "</applet>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildXmlForJTreeMap() {
        BufferedWriter out = null;
        this.copyJar(Messages.getString("JTREEMAP_JAR"));
        out = new BufferedWriter(new FileWriter(ConfigurationOptions.getOutputDir() + REPO_FILE));
        out.write("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
        out.write("<root>\n");
        Iterator it = this.config.getRepository().getDirectories().iterator();
        if (it.hasNext()) {
            Directory dir = (Directory)it.next();
            this.doDirectory(out, dir);
        }
        out.write("</root>");
        Object var5_5 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (IOException e) {
                e.printStackTrace();
                Object var5_6 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyJar(String jtreemapJar) throws IOException {
        block5: {
            InputStream stream = null;
            try {
                stream = RepoMapPageMaker.class.getResourceAsStream(WEB_FILE_PATH + jtreemapJar);
                if (stream != null) {
                    FileUtils.copyFile(stream, new File(ConfigurationOptions.getOutputDir() + jtreemapJar));
                    break block5;
                }
                throw new IOException("The stream to " + WEB_FILE_PATH + jtreemapJar + " failed, is it copied in the jar?");
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
    }

    private void addSpaces(int count, BufferedWriter out) throws IOException {
        out.write(this.getSpaces(count));
    }

    private String getSpaces(int count) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            result.append("  ");
        }
        return result.toString();
    }

    private void doDirectory(BufferedWriter out, Directory dir) throws IOException {
        ++this.indent;
        if (dir.isEmpty()) {
            --this.indent;
            return;
        }
        SortedSet set = dir.getSubdirectories();
        SortedSet files = dir.getFiles();
        String name = dir.isRoot() ? Messages.getString("NAVIGATION_ROOT") : dir.getName();
        boolean addedBranch = false;
        if (this.indent > 1 && set != null && !set.isEmpty()) {
            out.write("\n");
            this.addSpaces(this.indent, out);
            out.write("<branch>\n");
            this.addSpaces(this.indent + 2, out);
            this.labelTag(out, name);
            addedBranch = true;
        } else if (this.indent == 1) {
            this.addSpaces(this.indent, out);
            this.labelTag(out, name);
        }
        if (set != null) {
            Iterator it2 = set.iterator();
            while (it2.hasNext()) {
                this.doDirectory(out, (Directory)it2.next());
            }
        }
        if (addedBranch = this.handleEachFileInDir(out, files, name, addedBranch)) {
            this.addSpaces(this.indent, out);
            out.write("</branch>\n");
        }
        --this.indent;
    }

    private boolean handleEachFileInDir(BufferedWriter out, SortedSet files, String name, boolean addedBranch) throws IOException {
        if (files != null && !files.isEmpty()) {
            Iterator file = files.iterator();
            while (file.hasNext()) {
                VersionedFile vfile = (VersionedFile)file.next();
                int loc = vfile.getCurrentLinesOfCode();
                int delta = this.calculateTotalDelta(vfile);
                if (loc == 0) {
                    loc = Math.abs(delta);
                }
                if (loc == 0) continue;
                if (!addedBranch) {
                    out.write("\n");
                    this.addSpaces(this.indent, out);
                    out.write("<branch>\n");
                    this.addSpaces(this.indent + 2, out);
                    this.labelTag(out, name);
                    out.write("\n");
                    addedBranch = true;
                }
                this.addSpaces(this.indent + 2, out);
                out.write("<leaf>");
                this.labelTag(out, vfile.getFilename());
                this.tag(out, "weight", String.valueOf(loc));
                double percentage = (double)delta / (double)loc * 100.0;
                this.tag(out, "value", String.valueOf(percentage));
                out.write("</leaf>\n");
            }
        }
        return addedBranch;
    }

    private int calculateTotalDelta(VersionedFile vfile) {
        int delta = 0;
        SortedSet revisions = vfile.getRevisions();
        Iterator rev = revisions.iterator();
        while (rev.hasNext()) {
            Revision revision = (Revision)rev.next();
            if (!this.deadline.before(revision.getDate())) continue;
            delta += revision.getLinesDelta();
        }
        return delta;
    }

    private void labelTag(Writer result, String name) throws IOException {
        if (name == null || name.length() == 0) {
            this.tag(result, "label", "[root]");
        } else {
            this.tag(result, "label", name);
        }
    }

    private void tag(Writer result, String tagName, String value) throws IOException {
        result.write("<");
        result.write(tagName);
        result.write(">");
        result.write(value);
        result.write("</");
        result.write(tagName);
        result.write(">");
    }
}

