/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.ViewCvsIntegration;

public class ViewVcIntegration
extends ViewCvsIntegration {
    public ViewVcIntegration(String baseURL) {
        super(baseURL);
    }

    public String getName() {
        return "ViewVC";
    }

    protected String getFileUrl(VersionedFile file, String parameter) {
        String filename = "/" + file.getFilenameWithPath();
        String append = parameter;
        if (this.getPostfix() != null) {
            append = append + (append.length() > 0 ? "&" + this.getPostfix() : "?" + this.getPostfix());
        }
        return this.getBaseUrl() + filename + append;
    }

    public String getDiffUrl(Revision oldRevision, Revision newRevision) {
        if (!oldRevision.getFile().equals(newRevision.getFile())) {
            throw new IllegalArgumentException("revisions must be of the same file");
        }
        if (this.isInAttic(newRevision.getFile())) {
            return this.getFileViewUrl(newRevision);
        }
        return this.getFileUrl(oldRevision.getFile(), "?r1=" + oldRevision.getRevisionNumber() + "&r2=" + newRevision.getRevisionNumber());
    }
}

