/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.pages.DeveloperPageMaker;
import net.sf.statcvs.pages.DirectoryPageMaker;

public final class HTML {
    public static final SimpleDateFormat OUTPUT_DATE_FORMAT = new SimpleDateFormat(Messages.getString("DATE_FORMAT"));
    public static final SimpleDateFormat OUTPUT_DATE_TIME_FORMAT = new SimpleDateFormat(Messages.getString("DATE_TIME_FORMAT"));
    private static final Pattern HTTP_REGEXP2 = Pattern.compile("\\b(http://|https://|www.)(\\w|\\d|\\.)+(\\.|/|\\w|\\d|%|;|&|=)*\\b", 2);

    public static String getLink(String link, String linkName) {
        return HTML.getLink(link, linkName, "", "");
    }

    public static String getLink(String link, String linkName, String prefix, String suffix) {
        if (link == null) {
            return prefix + HTML.escape(linkName) + suffix;
        }
        return "<a href=\"" + HTML.escape(link) + "\">" + prefix + HTML.escape(linkName) + suffix + "</a>";
    }

    public static String getAuthorLink(Author author) {
        return "<a href=\"" + HTML.escape(DeveloperPageMaker.getURL(author)) + "\" class=\"author\">" + HTML.escape(author.getRealName()) + "</a>";
    }

    public static String getAuthorIdLink(Author author) {
        return "<a href=\"" + HTML.escape(DeveloperPageMaker.getURL(author)) + "\" class=\"author\">" + HTML.escape(author.getName()) + "</a>";
    }

    public static String getDate(Date date) {
        return "<span class=\"date\">" + OUTPUT_DATE_FORMAT.format(date) + "</span>";
    }

    public static String getAffectedFilesCount(Set files) {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"files\">" + files.size());
        if (files.size() <= 1) {
            sb.append(" file");
        } else {
            sb.append(" files");
        }
        sb.append("</span>");
        return sb.toString();
    }

    public static String getDateAndTime(Date date) {
        return "<span class=\"date\">" + OUTPUT_DATE_TIME_FORMAT.format(date) + "</span>";
    }

    public static String getRevisionNumber(String revisionNumber) {
        return "<span class=\"revisionNumberOuter\">Rev.: <span class=\"revisionNumberInner\">" + revisionNumber + "</span></span>";
    }

    public static String getDirectoryLink(Directory directory) {
        String caption = directory.isRoot() ? "/" : directory.getPath();
        return "<a href=\"" + HTML.escape(DirectoryPageMaker.getURL(directory)) + "\" class=\"directory\">" + HTML.escape(caption) + "</a>";
    }

    public static String getIcon(String iconFilename) {
        StringBuffer result = new StringBuffer("<img src=\"");
        result.append(HTML.escape(iconFilename)).append("\" width=\"");
        result.append(15).append("\" height=\"");
        result.append(13).append("\" alt=\"\"/>");
        return result.toString();
    }

    public static String getIcon(String iconFilename, String title) {
        StringBuffer result = new StringBuffer("<img src=\"");
        result.append(HTML.escape(iconFilename)).append("\" width=\"");
        result.append(15).append("\" height=\"");
        result.append(13).append("\" alt=\"").append(title).append("\"");
        result.append(" title=\"").append(title).append("\"");
        result.append("/>");
        return result.toString();
    }

    public static String escapeAuthorName(String authorName) {
        return authorName.replaceAll("#", "_").replaceAll("\\\\", "_");
    }

    public static String escapeDirectoryName(String directoryName) {
        if (!directoryName.startsWith("/")) {
            directoryName = "/" + directoryName;
        }
        return directoryName.substring(0, directoryName.length() - 1).replaceAll("/", "_");
    }

    public static String escape(String text) {
        String result = text.replaceAll("&", "&amp;");
        result = result.replaceAll("<", "&lt;");
        result = result.replaceAll(">", "&gt;");
        result = result.replaceAll("\n", "<br />\n");
        return result;
    }

    public static String escapeUrl(String text) {
        String result = HTML.escape(text);
        result = result.replaceAll("\\%", "%25");
        result = result.replaceAll("\\$", "%24");
        result = result.replaceAll("\\&", "%26");
        result = result.replaceAll("\\+", "%2B");
        result = result.replaceAll(",", "%2C");
        result = result.replaceAll("/", "%2F");
        result = result.replaceAll(":", "%3A");
        result = result.replaceAll(";", "%3B");
        result = result.replaceAll("=", "%3D");
        result = result.replaceAll("\\?", "%3F");
        result = result.replaceAll("@", "%40");
        result = result.replaceAll("\"", "%22");
        result = result.replaceAll("#", "%23");
        result = result.replaceAll("\\{", "%7B");
        result = result.replaceAll("\\}", "%7C");
        result = result.replaceAll("\\\\", "%5C");
        result = result.replaceAll("\\^", "%5E");
        result = result.replaceAll("~", "%7E");
        result = result.replaceAll("\\[", "%5B");
        result = result.replaceAll("\\]", "%5D");
        result = result.replaceAll("`", "%60");
        result = result.replaceAll(" ", "%20");
        return result;
    }

    private HTML() {
    }

    public static String webifyLinksFromPlainText(String plainText) {
        String escapedText = HTML.escape(plainText);
        Matcher m = HTTP_REGEXP2.matcher(escapedText);
        String res = m.replaceAll("<a href=\"$0\">$0</a>");
        res = res.replaceAll("href=\"www.", "href=\"http://www.");
        return res;
    }
}

