/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages.xml;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.Stack;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.output.ReportConfig;
import org.jdom.Element;

public class DirectoriesXml {
    private final SortedSet directory;
    private final Repository repository;

    public DirectoriesXml(ReportConfig config) {
        this.repository = config.getRepository();
        this.directory = this.repository.getDirectories();
    }

    public Element toFile() {
        Element dir = new Element("Directories");
        Iterator it = this.directory.iterator();
        Element parent = dir;
        Stack<Element> stack = new Stack<Element>();
        stack.add(dir);
        while (it.hasNext()) {
            Directory direc = (Directory)it.next();
            Element item = this.format(direc, 0);
            parent.addContent(item);
        }
        return dir;
    }

    private Element format(Directory dir, int currentDepth) {
        Element element = new Element("Directory");
        Element path = new Element("Path");
        path.setText(dir.getPath());
        if (dir.isEmpty()) {
            element.setAttribute("status", "deleted");
        }
        Element child1 = new Element("Files");
        String str = Integer.toString(dir.getCurrentFileCount());
        child1.setText(str);
        Element child2 = new Element("LinesChanged");
        String str2 = Integer.toString(dir.getCurrentLOC());
        child2.setText(str2);
        element.addContent(path);
        element.addContent(child1);
        element.addContent(child2);
        return element;
    }
}

