/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui.webpage;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class WebpageViewer
extends JFrame {
    protected JEditorPane editorPane;
    protected static WebpageViewer instance;

    protected WebpageViewer() {
        this.setLocationByPlatform(true);
        this.editorPane = new JEditorPane();
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                try {
                    WebpageViewer.this.openPage(e.getURL().toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.editorPane.setEditable(false);
        this.getContentPane().add((Component)new JScrollPane(this.editorPane), "Center");
        this.setSize(800, 600);
    }

    public static void open(String title, String documentPath) {
        if (instance == null) {
            instance = new WebpageViewer();
        }
        instance.openPage(title, documentPath);
        instance.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                instance.requestFocus();
                instance.toFront();
            }
        });
    }

    public void openPage(String title, String documentPath) {
        this.setTitle(title);
        this.openPage(documentPath);
    }

    public void openPage(final String documentPath) {
        try {
            final int index = documentPath.indexOf(35);
            String page = index < 0 ? documentPath : documentPath.substring(0, index);
            this.editorPane.setPage(page);
            new Thread(){

                public void run() {
                    long now = System.currentTimeMillis();
                    while (System.currentTimeMillis() - now < 5000L && WebpageViewer.this.editorPane.getY() < 0) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                3.access$0(this.this$1).editorPane.scrollRectToVisible(new Rectangle(0, 0, 3.access$0(this.this$1).editorPane.getWidth(), 1));
                            }
                        });
                        try {
                            3.sleep(400L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (index > 0) {
                        now = System.currentTimeMillis();
                        while (System.currentTimeMillis() - now < 5000L && WebpageViewer.this.editorPane.getY() >= 0) {
                            SwingUtilities.invokeLater(new Runnable(this, documentPath, index){
                                final /* synthetic */ 3 this$1;
                                private final /* synthetic */ String val$documentPath;
                                private final /* synthetic */ int val$index;
                                {
                                    this.this$1 = var1_1;
                                    this.val$documentPath = string;
                                    this.val$index = n;
                                }

                                public void run() {
                                    3.access$0(this.this$1).editorPane.scrollToReference(this.val$documentPath.substring(this.val$index + 1));
                                }
                            });
                            try {
                                3.sleep(400L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }

                static /* synthetic */ WebpageViewer access$0(3 var0) {
                    return var0.WebpageViewer.this;
                }
            }.start();
        }
        catch (Exception e) {
            this.editorPane.setText("Could not open " + documentPath);
        }
        this.toFront();
    }
}

