/*
 * Decompiled with CFR 0.152.
 */
package chrriis.udoc.ui.widgets;

import chrriis.udoc.model.Util;
import java.awt.Color;
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CodeComponent
extends JPanel {
    protected static final Color IDENTIFIER_COLOR = new Color(127, 0, 85);

    public CodeComponent(String code) {
        super(new FlowLayout(0, 0, 0));
        this.setOpaque(false);
        ArrayList<String> tokenList = new ArrayList<String>();
        int i = 0;
        while (i < code.length()) {
            char c = code.charAt(i);
            switch (c) {
                case ' ': 
                case '(': 
                case ')': 
                case '[': {
                    if (i > 0) {
                        tokenList.add(code.substring(0, i));
                    }
                    tokenList.add(code.substring(i, i + 1));
                    code = code.substring(i + 1);
                    i = 0;
                }
            }
            ++i;
        }
        if (code.length() > 0) {
            tokenList.add(code);
        }
        i = 0;
        while (i < tokenList.size()) {
            this.add(new CodeTokenComponent((String)tokenList.get(i)));
            ++i;
        }
    }

    protected static class CodeTokenComponent
    extends JLabel {
        public CodeTokenComponent(String token) {
            super(token);
            if (Util.isReservedKeyword(token)) {
                this.setFont(this.getFont().deriveFont(1, 11.0f));
                this.setForeground(IDENTIFIER_COLOR);
            } else {
                this.setFont(this.getFont().deriveFont(0, 11.0f));
            }
            this.setBorder(null);
        }
    }
}

