/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import net.sf.statcvs.Messages;
import net.sf.statcvs.input.Builder;
import net.sf.statcvs.input.CvsLogfileParser;
import net.sf.statcvs.input.LogSyntaxException;
import net.sf.statcvs.input.RepositoryFileManager;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.output.CommandLineParser;
import net.sf.statcvs.output.ConfigurationException;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.Page;
import net.sf.statcvs.pages.ReportSuiteMaker;

public class Main {
    private static Logger logger = Logger.getLogger("net.sf.statcvs");
    private static LogManager lm = LogManager.getLogManager();

    public static void main(String[] args) {
        System.out.println(Messages.getString("PROJECT_NAME") + "\n");
        if (args.length == 0) {
            Main.printProperUsageAndExit();
        }
        if (args.length == 1) {
            String arg = args[0].toLowerCase();
            if (arg.equals("-h") || arg.equals("-help")) {
                Main.printProperUsageAndExit();
            } else if (arg.equals("-version")) {
                Main.printVersionAndExit();
            }
        }
        try {
            new CommandLineParser(args).parse();
            Main.generateDefaultHTMLSuite();
        }
        catch (ConfigurationException cex) {
            System.err.println(cex.getMessage());
            System.exit(1);
        }
        catch (LogSyntaxException lex) {
            Main.printLogErrorMessageAndExit(lex.getMessage());
        }
        catch (IOException ioex) {
            Main.printIoErrorMessageAndExit(ioex.getMessage());
        }
        catch (OutOfMemoryError oome) {
            Main.printOutOfMemMessageAndExit();
        }
        System.exit(0);
    }

    private static void initLogManager(String loggingProperties) {
        try {
            lm.readConfiguration(Main.class.getResourceAsStream(loggingProperties));
        }
        catch (IOException e) {
            System.err.println("ERROR: Logging could not be initialized!");
        }
    }

    private static void printProperUsageAndExit() {
        System.out.println("Usage: java -jar statcvs.jar [options] <logfile> <directory>\n\nRequired parameters:\n  <logfile>          path to the cvs logfile of the module\n  <directory>        path to the directory of the checked out module\n\nSome options:\n  -version           print version information and exit\n  -output-dir <dir>  set directory where HTML suite will be saved\n  -include <pattern> include only files matching pattern, e.g. **/*.c;**/*.h\n  -exclude <pattern> exclude matching files, e.g. tests/**;docs/**\n  -tags <regexp>     show matching tags in lines of code chart, e.g. version-.*\n  -title <title>     set project title to be used in reports\n  -xdoc              generate Maven XDoc instead of HTML\n  -trac <url>        integrate with Trac at <url>\n  -xml               generate XML instead of HTML\n  -charset <charset> specify the charset to use for html/xdoc\n  -verbose           print extra progress information\n  -viewcvs/viewvc/cvsweb/chora/jcvsweb/bugzilla/mantis <url>\n                     add links to installation at <url>\n  -disable-twitter-button\n\nFull options list: http://statcvs.sf.net/manual");
        System.exit(1);
    }

    private static void printVersionAndExit() {
        System.out.println("Version " + Messages.getString("PROJECT_VERSION"));
        System.exit(1);
    }

    private static void printOutOfMemMessageAndExit() {
        System.err.println("OutOfMemoryError.");
        System.err.println("Try running java with the -mx option (e.g. -mx128m for 128Mb).");
        System.exit(1);
    }

    private static void printLogErrorMessageAndExit(String message) {
        System.err.println("Logfile parsing failed.");
        System.err.println(message);
        System.exit(1);
    }

    private static void printIoErrorMessageAndExit(String message) {
        System.err.println(message);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateDefaultHTMLSuite() throws LogSyntaxException, IOException, ConfigurationException {
        if (ConfigurationOptions.getLogFileName() == null) {
            throw new ConfigurationException("Missing logfile name");
        }
        if (ConfigurationOptions.getCheckedOutDirectory() == null) {
            throw new ConfigurationException("Missing checked out directory");
        }
        long memoryUsedOnStart = Runtime.getRuntime().totalMemory();
        long startTime = System.currentTimeMillis();
        Main.initLogManager(ConfigurationOptions.getLoggingProperties());
        logger.info("Parsing CVS log '" + ConfigurationOptions.getLogFileName() + "'");
        FileReader logReader = null;
        Builder builder = null;
        try {
            logReader = new FileReader(ConfigurationOptions.getLogFileName());
            RepositoryFileManager repFileMan = new RepositoryFileManager(ConfigurationOptions.getCheckedOutDirectory());
            builder = new Builder(repFileMan, ConfigurationOptions.getIncludePattern(), ConfigurationOptions.getExcludePattern(), ConfigurationOptions.getSymbolicNamesPattern());
            new CvsLogfileParser(logReader, builder).parse();
        }
        finally {
            if (logReader != null) {
                ((Reader)logReader).close();
            }
        }
        if (ConfigurationOptions.getProjectName() == null) {
            ConfigurationOptions.setProjectName(builder.getProjectName());
        }
        if (ConfigurationOptions.getWebRepository() != null) {
            ConfigurationOptions.getWebRepository().setAtticFileNames(builder.getAtticFileNames());
        }
        logger.info("Generating report for " + ConfigurationOptions.getProjectName() + " into " + ConfigurationOptions.getOutputDir());
        logger.info("Using " + ConfigurationOptions.getCssHandler());
        Repository content = builder.createCvsContent();
        if (content.isEmpty()) {
            if (builder.allRejectedByExcludePattern()) {
                logger.warning("Exclude pattern '" + ConfigurationOptions.getExcludePattern() + "' removed all files from repository");
            } else if (builder.allRejectedByIncludePattern()) {
                logger.warning("Include pattern '" + ConfigurationOptions.getIncludePattern() + "' rejected all files from repository");
            } else {
                logger.warning("Empty repository");
            }
        }
        if (builder.isLocalFilesNotFound()) {
            logger.warning("The log references many files that do not exist in the local copy.");
            logger.warning("Reports will be inaccurate or broken.");
            logger.warning("Log not generated in '" + ConfigurationOptions.getCheckedOutDirectory() + "'?");
        } else if (!builder.hasLocalCVSMetadata()) {
            logger.warning("No CVS metadata found in working copy. Reports may be inaccurate.");
        } else if (builder.isLogAndLocalFilesOutOfSync()) {
            logger.warning("Log and working copy are out of sync. Reports will be inaccurate.");
        }
        builder.clean();
        builder = null;
        System.setProperty("java.awt.headless", "true");
        ReportConfig config = new ReportConfig(content, ConfigurationOptions.getProjectName(), ConfigurationOptions.getOutputDir(), ConfigurationOptions.getMarkupSyntax(), ConfigurationOptions.getCssHandler(), ConfigurationOptions.getCharSet());
        config.setWebRepository(ConfigurationOptions.getWebRepository());
        config.setWebBugtracker(ConfigurationOptions.getWebBugtracker());
        config.setNonDeveloperLogins(ConfigurationOptions.getNonDeveloperLogins());
        ArrayList extraReports = new ArrayList();
        ReportSuiteMaker reportSuiteMaker = new ReportSuiteMaker(config, ConfigurationOptions.getNotes(), extraReports);
        if ("xml".equalsIgnoreCase(ConfigurationOptions.getOutputFormat())) {
            reportSuiteMaker.toXml();
        } else {
            Page page = reportSuiteMaker.toFile();
            page.write();
        }
        long endTime = System.currentTimeMillis();
        long memoryUsedOnEnd = Runtime.getRuntime().totalMemory();
        logger.info("runtime: " + ((double)endTime - (double)startTime) / 1000.0 + " seconds");
        logger.info("memory usage: " + ((double)memoryUsedOnEnd - (double)memoryUsedOnStart) / 1024.0 + " kb");
    }
}

