/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.charts;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.statcvs.charts.ChartConfigUtil;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.model.Module;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.util.IntegerMap;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ColorBar;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.plot.ContourPlot;
import org.jfree.data.contour.ContourDataset;
import org.jfree.data.contour.DefaultContourDataset;
import org.jfree.ui.RectangleEdge;

public class ModuleEvolutionChartMaker {
    private static final int SLICE_MIN_PERCENT = 5;
    private final ReportConfig config;
    private final String title;
    private final String fileName;
    private final List files = new ArrayList();
    private final String chartName;
    private final Repository repository;

    public ModuleEvolutionChartMaker(String chartName, ReportConfig config, String title, String fileName) {
        this.chartName = chartName;
        this.config = config;
        this.title = title;
        this.fileName = fileName;
        this.repository = config.getRepository();
    }

    public ChartImage toFile() {
        ContourDataset data = this.buildDs();
        if (data == null) {
            return null;
        }
        DateAxis xAxis = new DateAxis("Date");
        SymbolAxis yAxis = new SymbolAxis("Module", this.repository.getModules().keySet().toArray(new String[0]));
        yAxis.setInverted(true);
        yAxis.setLowerMargin(0.0);
        yAxis.setUpperMargin(0.0);
        ColorBar zAxis = new ColorBar("Commit Activity (%)");
        zAxis.getAxis();
        ContourPlot plot = new ContourPlot(data, xAxis, yAxis, zAxis);
        plot.setDataAreaRatio(0.0);
        plot.setColorBarLocation(RectangleEdge.BOTTOM);
        JFreeChart chart = new JFreeChart(this.config.getProjectName(), null, plot, false);
        plot.setBackgroundPaint(ChartConfigUtil.getPlotColor(this.chartName));
        chart.setBackgroundPaint(ChartConfigUtil.getBackgroundColor(this.chartName));
        ChartConfigUtil.configureCopyrightNotice(this.chartName, chart);
        ChartConfigUtil.configureChartBackgroungImage(this.chartName, chart);
        ChartConfigUtil.configurePlotImage(this.chartName, chart);
        Dimension dim = ChartConfigUtil.getDimension(this.chartName, this.config.getLargeChartSize());
        return this.config.createChartImage(this.fileName, this.title, chart, dim);
    }

    private ContourDataset buildDs() {
        LinkedHashMap<Date, IntegerMap> mapByDate = new LinkedHashMap<Date, IntegerMap>();
        int max = 0;
        long elapsed = this.repository.getLastDate().getTime() - this.repository.getFirstDate().getTime();
        long windowSize = Math.max(elapsed / 60L, 1L);
        IntegerMap commitsPerModule = new IntegerMap();
        Iterator itRev = this.repository.getRevisions().iterator();
        long currentDate = -1L;
        while (itRev.hasNext()) {
            Revision rev = (Revision)itRev.next();
            Date date = rev.getDate();
            System.out.println("| Consider Rev " + rev.getDate() + " Mod:" + rev.getFile().getModule().getName() + " currentDate:" + currentDate);
            if (currentDate == -1L) {
                currentDate = date.getTime();
            } else if (date.getTime() > currentDate + windowSize) {
                max = Math.max(commitsPerModule.max(), max);
                mapByDate.put(new Date(currentDate), commitsPerModule);
                commitsPerModule = new IntegerMap();
                int fill = (int)((date.getTime() - currentDate) / windowSize);
                if (fill > 1) {
                    mapByDate.put(new Date(currentDate + windowSize), null);
                }
                currentDate += (long)fill * windowSize;
            }
            commitsPerModule.inc(rev.getFile().getModule().getName());
        }
        if (currentDate != -1L) {
            mapByDate.put(new Date(currentDate), commitsPerModule);
            max = Math.max(commitsPerModule.max(), max);
        }
        System.out.println("Module Commit");
        Iterator it = mapByDate.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            IntegerMap map = (IntegerMap)mapByDate.get(key);
            System.out.println("Key:" + key);
            if (map == null) continue;
            Iterator it2 = map.iteratorSortedByKey();
            while (it2.hasNext()) {
                Object o = it2.next();
                System.out.println("Val:" + o + "\t -> " + map.get(o));
            }
        }
        int groupCount = this.repository.getModules().size();
        int dateCount = mapByDate.size();
        int numValues = dateCount * groupCount;
        if (numValues == 0 || max == 0 || dateCount == 1) {
            return null;
        }
        Object[] oDateX = new Date[numValues];
        Object[] oDoubleY = new Double[numValues];
        Object[] oDoubleZ = new Double[numValues];
        it = mapByDate.keySet().iterator();
        for (int x = 0; x < dateCount; ++x) {
            if (!it.hasNext()) {
                throw new RuntimeException("Invalid date count");
            }
            Date date = (Date)it.next();
            IntegerMap map = (IntegerMap)mapByDate.get(date);
            if (map != null) {
                Iterator it2 = this.repository.getModules().values().iterator();
                for (int y = 0; y < groupCount; ++y) {
                    if (!it2.hasNext()) {
                        throw new RuntimeException("Invalid group count");
                    }
                    Module group = (Module)it2.next();
                    int index = x * groupCount + y;
                    oDateX[index] = date;
                    oDoubleY[index] = new Double(y);
                    double value = (double)map.get(group.getName()) * 100.0 / (double)max;
                    oDoubleZ[index] = value != 0.0 ? new Double(value) : null;
                }
                continue;
            }
            for (int y = 0; y < groupCount; ++y) {
                int index = x * groupCount + y;
                oDateX[index] = date;
                oDoubleY[index] = new Double(y);
            }
        }
        return new DefaultContourDataset(null, oDateX, oDoubleY, oDoubleZ);
    }
}

