/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.charts;

import java.awt.Color;
import java.awt.Dimension;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.statcvs.charts.ChartConfigUtil;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.model.Module;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.util.IntegerMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class ModuleSizePieChartMaker {
    private static final int SLICE_MIN_PERCENT = 5;
    private final ReportConfig config;
    private final String title;
    private final String subTitle;
    private final String fileName;
    private final List files = new ArrayList();
    private final String chartName;

    public ModuleSizePieChartMaker(String chartName, ReportConfig config, String title, String subTitle, String fileName) {
        this.chartName = chartName;
        this.config = config;
        this.title = title;
        this.subTitle = subTitle;
        this.fileName = fileName;
    }

    public ChartImage toFile() {
        DefaultPieDataset data = new DefaultPieDataset();
        IntegerMap dirSizes = new IntegerMap();
        Iterator it = this.config.getRepository().getModules().values().iterator();
        int total = 0;
        while (it.hasNext()) {
            Module module = (Module)it.next();
            dirSizes.addInt(module.getName(), module.getCurrentLinesOfCode());
            total += module.getCurrentLinesOfCode();
        }
        it = dirSizes.iteratorSortedByValue();
        NumberFormat nf = NumberFormat.getNumberInstance();
        NumberFormat nf2 = NumberFormat.getPercentInstance();
        while (it.hasNext()) {
            String modName = (String)it.next();
            Integer loc = dirSizes.getInteger(modName);
            double percent = (double)loc.intValue() / (double)total;
            String dirName = modName + " = " + nf.format(loc) + " (" + nf2.format(percent) + ")";
            data.setValue((Comparable)((Object)dirName), loc);
        }
        JFreeChart chart = ChartFactory.createPieChart(this.config.getProjectName() + ": " + this.title, (PieDataset)data, false, false, false);
        ArrayList<TextTitle> arrayList = new ArrayList<TextTitle>();
        arrayList.add(new TextTitle(this.subTitle));
        chart.setSubtitles(arrayList);
        PiePlot plot = (PiePlot)chart.getPlot();
        plot.setShadowPaint(null);
        plot.setLabelShadowPaint(null);
        plot.setLabelOutlinePaint(Color.LIGHT_GRAY);
        plot.setForegroundAlpha(0.8f);
        plot.setSectionOutlinePaint(Color.BLACK);
        plot.setBackgroundPaint(ChartConfigUtil.getPlotColor(this.chartName));
        chart.setBackgroundPaint(ChartConfigUtil.getBackgroundColor(this.chartName));
        ChartConfigUtil.configureCopyrightNotice(this.chartName, chart);
        ChartConfigUtil.configureChartBackgroungImage(this.chartName, chart);
        ChartConfigUtil.configurePlotImage(this.chartName, chart);
        Dimension dim = ChartConfigUtil.getDimension(this.chartName, this.config.getLargeChartSize());
        return this.config.createChartImage(this.fileName, this.title, chart, dim);
    }
}

