/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.input;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import net.sf.statcvs.input.NoLineCountException;
import net.sf.statcvs.util.FileUtils;

public class RepositoryFileManager {
    private final Logger logger;
    private final String path;
    private final Hashtable revByFilename = new Hashtable();

    public RepositoryFileManager(String pathName) {
        this.path = pathName;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public int getLinesOfCode(String filename) throws NoLineCountException {
        String absoluteName = FileUtils.getAbsoluteName(this.path, filename);
        try {
            FileReader freader = new FileReader(absoluteName);
            BufferedReader reader = new BufferedReader(freader);
            int linecount = this.getLineCount(reader);
            this.logger.finer("line count for '" + absoluteName + "': " + linecount);
            freader.close();
            return linecount;
        }
        catch (IOException e) {
            throw new NoLineCountException("could not get line count for '" + absoluteName + "': " + e);
        }
    }

    private int getLineCount(BufferedReader reader) throws IOException {
        int linecount = 0;
        while (reader.readLine() != null) {
            ++linecount;
        }
        return linecount;
    }

    public String getRevision(String filename) throws IOException {
        String rev = (String)this.revByFilename.get(filename);
        if (rev != null) {
            return rev;
        }
        String baseDir = FileUtils.getParentDirectoryPath(filename);
        String entriesFilename = baseDir + "CVS" + FileUtils.getDefaultDirSeparator() + "Entries";
        String absoluteName = FileUtils.getAbsoluteName(this.path, entriesFilename);
        BufferedReader in = new BufferedReader(new FileReader(absoluteName));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                StringTokenizer t;
                if (line.startsWith("D") || (t = new StringTokenizer(line, "/")).countTokens() < 2) continue;
                this.revByFilename.put(baseDir + t.nextToken(), t.nextToken());
            }
            rev = (String)this.revByFilename.get(filename);
            if (rev != null) {
                String string = rev;
                return string;
            }
            throw new IOException("File " + filename + " has no revision");
        }
        finally {
            in.close();
        }
    }
}

