/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.sf.statcvs.Messages;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.charts.SymbolicNameAnnotation;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.output.LOCChurnChartMaker;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.NavigationNode;
import net.sf.statcvs.pages.Page;
import net.sf.statcvs.reports.LOCSeriesBuilder;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;

public class ChurnPageMaker {
    private final ReportConfig config;

    public ChurnPageMaker(ReportConfig config) {
        this.config = config;
    }

    public NavigationNode toFile() {
        Page page = this.config.createPage("churn", Messages.getString("CHURN_TITLE"), Messages.getString("CHURN_TITLE"));
        page.addRawContent("\n\n<!-- The LOC and Churn Report was designed by Benoit Xhenseval (http://www.objectlab.co.uk/open)-->");
        page.addRawContent("\n<!-- Initially part of StatSVN -->\n\n");
        page.addRawContent("<p>" + Messages.getString("CHURN_DESCRIPTION") + "</p>");
        page.add(this.buildChart());
        return page;
    }

    private ChartImage buildChart() {
        HashMap<Date, Integer> changePerRevision = new HashMap<Date, Integer>();
        SortedSet revisions = this.config.getRepository().getRevisions();
        Iterator it = revisions.iterator();
        while (it.hasNext()) {
            Revision rev = (Revision)it.next();
            Date dateToUse = this.blastTime(rev.getDate());
            Integer changes = (Integer)changePerRevision.get(dateToUse);
            if (changes == null) {
                changePerRevision.put(dateToUse, new Integer(Math.abs(this.getLineChanges(rev))));
                continue;
            }
            changePerRevision.put(dateToUse, new Integer(Math.abs(changes) + this.getLineChanges(rev)));
        }
        List annotations = SymbolicNameAnnotation.createAnnotations(this.config.getRepository().getSymbolicNames());
        TimeSeries timeLine = new TimeSeries((Comparable)((Object)Messages.getString("CHURN_TOUCHED_LINE")), Day.class);
        Iterator it2 = changePerRevision.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry entry = it2.next();
            timeLine.add((RegularTimePeriod)new Day((Date)entry.getKey()), ((Integer)entry.getValue()).intValue());
        }
        TimeSeries locSeries = this.getLOCTimeSeries(revisions, Messages.getString("TIME_LOC_SUBTITLE"));
        LOCChurnChartMaker chart = new LOCChurnChartMaker("locandchurn", this.config, timeLine, locSeries, Messages.getString("LOC_CHURN_CHART_TITLE"), "locandchurn.png", annotations);
        return chart.toFile();
    }

    private Date blastTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(14, 0);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    private int getLineChanges(Revision rev) {
        if (rev.isDead()) {
            return rev.getLinesDelta();
        }
        return Math.abs(rev.getLinesDelta()) + 2 * rev.getReplacedLines();
    }

    private TimeSeries getLOCTimeSeries(SortedSet revisions, String title) {
        Iterator it = revisions.iterator();
        LOCSeriesBuilder locCounter = new LOCSeriesBuilder(title, true);
        while (it.hasNext()) {
            locCounter.addRevision((Revision)it.next());
        }
        return locCounter.getTimeSeries();
    }
}

