/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import net.sf.statcvs.output.ConfigurationException;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.output.CssHandler;
import net.sf.statcvs.util.FileUtils;

public class LocalFileCssHandler
implements CssHandler {
    private static Logger logger = Logger.getLogger("net.sf.statcvs.output.CssHandler");
    private final String filename;

    public LocalFileCssHandler(String filename) {
        this.filename = filename;
    }

    public String getLink() {
        return FileUtils.getFilenameWithoutPath(this.filename);
    }

    public void checkForMissingResources() throws ConfigurationException {
        logger.finer("Checking if CSS file exists: '" + this.filename + "'");
        File f = new File(this.filename);
        if (!f.exists()) {
            throw new ConfigurationException("CSS file not found: " + this.filename);
        }
    }

    public void createOutputFiles() throws IOException {
        String destination = ConfigurationOptions.getOutputDir() + this.getLink();
        logger.info("Copying CSS file to '" + destination + "'");
        FileUtils.copyFile(this.filename, destination);
    }

    public String toString() {
        return "local CSS file (" + this.filename + ")";
    }
}

