/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.output;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.output.CssHandler;
import net.sf.statcvs.output.WebRepositoryIntegration;
import net.sf.statcvs.pages.MarkupHTML;
import net.sf.statcvs.pages.MarkupSyntax;
import net.sf.statcvs.pages.MarkupXDoc;
import net.sf.statcvs.pages.Page;
import net.sf.statcvs.pages.xml.MarkupXML;
import net.sf.statcvs.util.FileUtils;
import net.sf.statcvs.weblinks.bugs.BugTracker;
import org.jfree.chart.JFreeChart;

public class ReportConfig {
    public static final MarkupSyntax XDOC = MarkupXDoc.getInstance();
    public static final MarkupSyntax HTML = MarkupHTML.getInstance();
    public static final MarkupSyntax XML = MarkupXML.getInstance();
    private static final Dimension SMALL_CHART_SIZE = new Dimension(512, 320);
    private static final Dimension LARGE_CHART_SIZE = new Dimension(800, 500);
    private final Repository repository;
    private final String projectName;
    private final String rootDirectory;
    private final MarkupSyntax markup;
    private final CssHandler cssHandler;
    private Dimension smallChartSize;
    private Dimension largeChartSize;
    private WebRepositoryIntegration webRepository = null;
    private BugTracker webBugtracker = null;
    private Collection nonDeveloperLogins = Collections.EMPTY_LIST;
    private final String charSet;

    public ReportConfig(Repository repository, String projectName, String rootDirectory, MarkupSyntax syntax, CssHandler cssHandler, String charSet) {
        this.repository = repository;
        this.projectName = projectName;
        this.rootDirectory = rootDirectory;
        this.markup = syntax;
        this.cssHandler = cssHandler;
        this.smallChartSize = SMALL_CHART_SIZE;
        this.largeChartSize = LARGE_CHART_SIZE;
        this.charSet = charSet;
    }

    public void setSmallChartSize(Dimension newSize) {
        this.smallChartSize = newSize;
    }

    public void setLargeChartSize(Dimension newSize) {
        this.largeChartSize = newSize;
    }

    public void setWebRepository(WebRepositoryIntegration webRepository) {
        this.webRepository = webRepository;
    }

    public void setWebBugtracker(BugTracker webBugtracker) {
        this.webBugtracker = webBugtracker;
    }

    public void setNonDeveloperLogins(Collection names) {
        this.nonDeveloperLogins = names;
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Dimension getSmallChartSize() {
        return this.smallChartSize;
    }

    public Dimension getLargeChartSize() {
        return this.largeChartSize;
    }

    public MarkupSyntax getMarkup() {
        return this.markup;
    }

    public CssHandler getCssHandler() {
        return this.cssHandler;
    }

    public WebRepositoryIntegration getWebRepository() {
        return this.webRepository;
    }

    public BugTracker getWebBugtracker() {
        return this.webBugtracker;
    }

    public Page createPage(String fileName, String shortTitle, String fullTitle) {
        return new Page(this, fileName, shortTitle, fullTitle);
    }

    public ChartImage createChartImage(String fileName, String title, JFreeChart chart, Dimension size) {
        ChartImage img = new ChartImage(this.rootDirectory, fileName, title, chart, size);
        img.write();
        return img;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyFileIntoReport(URL source, String destinationFilename) {
        if (source == null) {
            throw new NullPointerException("Source was null");
        }
        InputStream stream = null;
        try {
            try {
                stream = source.openStream();
                FileUtils.copyFile(stream, new File(this.rootDirectory + destinationFilename));
                stream.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            Object var6_4 = null;
            if (stream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {}
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        stream.close();
    }

    public boolean isDeveloper(Author author) {
        return !this.nonDeveloperLogins.contains(author.getName());
    }

    public String getCharSet() {
        return this.charSet;
    }
}

