/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.pages;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import net.sf.statcvs.Messages;
import net.sf.statcvs.charts.ChartImage;
import net.sf.statcvs.charts.LOCChartMaker;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.HTML;
import net.sf.statcvs.pages.Page;
import net.sf.statcvs.pages.PageGroup;
import net.sf.statcvs.pages.TwitterHelp;
import net.sf.statcvs.reports.CloudCommitTableReport;
import net.sf.statcvs.reports.TagReport;
import net.sf.statcvs.reports.TopDevelopersTableReport;

public class IndexPageMaker {
    private final ReportConfig config;
    private final Repository repository;
    private final String notesHTML;
    private final PageGroup reports;
    private Page page;

    public IndexPageMaker(ReportConfig config, String notesHTML, PageGroup reports) {
        this.config = config;
        this.repository = config.getRepository();
        this.notesHTML = notesHTML;
        this.reports = reports;
        String title = Messages.getString("INDEX_TITLE") + " " + this.config.getProjectName();
        this.page = this.config.createPage("index", title, title);
        this.page.addChild(this.reports);
    }

    public Page toFile() {
        ChartImage chart = new LOCChartMaker.MainLOCChartMaker("loc_small", this.config, "loc_small.png", this.config.getSmallChartSize()).toFile();
        TopDevelopersTableReport topDevelopers = new TopDevelopersTableReport(this.config);
        CloudCommitTableReport cloud = new CloudCommitTableReport(this.config);
        Date date = Calendar.getInstance().getTime();
        this.page.addAttribute("Generated", date);
        String headRevisionNumber = this.getHeadRevisionNumber();
        if (headRevisionNumber != null && headRevisionNumber.indexOf(46) < 0) {
            this.page.addAttribute("Head revision", headRevisionNumber);
        }
        this.page.addRawAttribute("Report Period", this.getReportPeriod());
        this.page.addAttribute("Total Files", this.getCurrentFileCount());
        this.page.addAttribute("Total Lines of Code", this.repository.getCurrentLOC());
        this.page.addAttribute("Developers", topDevelopers.getDeveloperCount());
        if (ConfigurationOptions.isEnableTwitterButton()) {
            this.page.addRawAttribute("Tweet this", TwitterHelp.buildOverviewLink(topDevelopers, this.repository, this.config));
        }
        if (this.notesHTML != null) {
            this.page.addRawContent(this.notesHTML);
        }
        this.page.addRawContent(this.reports.asLinkList());
        if (chart != null) {
            this.page.addSection(Messages.getString("LOC_TITLE"));
            this.page.add(chart, "loc.html");
        }
        if (topDevelopers.getDeveloperCount() > 1) {
            if (topDevelopers.getDeveloperCount() > 10) {
                this.page.addSection(Messages.getString("SECTION_TOP_AUTHORS"));
            } else {
                this.page.addSection("Developers");
            }
            this.page.add(topDevelopers);
            this.page.addRawContent(HTML.getLink("developers.html", Messages.getString("NAVIGATION_MORE")));
        }
        this.page.addSection(Messages.getString("CLOUD_SECTION_TITLE"));
        cloud.calculate();
        this.page.addRawContent(cloud.getRawContent());
        this.page.addRawContent(HTML.getLink("cloud.html", Messages.getString("NAVIGATION_MORE")));
        if (!this.repository.getSymbolicNames().isEmpty()) {
            this.page.addSection("Repository Tags");
            this.page.add(new TagReport(this.config));
        }
        this.page.addSection("Directories");
        this.page.add(this.repository.getRoot(), false);
        return this.page;
    }

    private String getReportPeriod() {
        return HTML.getDate(this.repository.getFirstDate()) + " to " + HTML.getDate(this.repository.getLastDate());
    }

    private int getCurrentFileCount() {
        int result = 0;
        Iterator it = this.repository.getFiles().iterator();
        while (it.hasNext()) {
            VersionedFile file = (VersionedFile)it.next();
            if (file.isDead()) continue;
            ++result;
        }
        return result;
    }

    private String getHeadRevisionNumber() {
        Revision headRevision = (Revision)this.repository.getRevisions().last();
        if (headRevision != null) {
            return headRevision.getRevisionNumber();
        }
        return null;
    }

    public Page getPage() {
        return this.page;
    }
}

