/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reportmodel;

import java.util.ArrayList;
import java.util.List;
import net.sf.statcvs.renderer.TableCellRenderer;
import net.sf.statcvs.reportmodel.Column;

public class IntegerColumn
extends Column {
    private final String title;
    private final List values = new ArrayList();
    private int sum = 0;
    private boolean showValues = true;
    private boolean showPercentages = true;

    public IntegerColumn(String title) {
        this.title = title;
    }

    public void setShowValues(boolean enable) {
        this.showValues = enable;
    }

    public void setShowPercentages(boolean enable) {
        this.showPercentages = enable;
    }

    public void addValue(int value) {
        this.values.add(new Integer(value));
        this.sum += value;
    }

    public int getValue(int rowIndex) {
        return (Integer)this.values.get(rowIndex);
    }

    public int getSum() {
        return this.sum;
    }

    public void setSum(int sum) {
        this.sum = sum;
    }

    public int getRows() {
        return this.values.size();
    }

    public void renderHead(TableCellRenderer renderer) {
        renderer.renderCell(this.title);
    }

    public void renderCell(int rowIndex, TableCellRenderer renderer) {
        this.callRenderer(renderer, this.getValue(rowIndex));
    }

    public void renderTotal(TableCellRenderer renderer) {
        this.callRenderer(renderer, this.sum);
    }

    private void callRenderer(TableCellRenderer renderer, int value) {
        if (this.showValues && this.showPercentages) {
            renderer.renderIntegerCell(value, this.sum);
        } else if (this.showValues) {
            renderer.renderIntegerCell(value);
        } else if (this.showPercentages) {
            renderer.renderPercentageCell((double)value / (double)this.sum);
        } else {
            renderer.renderEmptyCell();
        }
    }
}

