/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reports;

import java.util.Iterator;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.model.Repository;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.reportmodel.DirectoryColumn;
import net.sf.statcvs.reportmodel.IntegerColumn;
import net.sf.statcvs.reportmodel.Table;
import net.sf.statcvs.reports.TableReport;
import net.sf.statcvs.util.IntegerMap;

public class DirectoriesTableReport
implements TableReport {
    private final Repository content;
    private Table table = null;
    private final IntegerMap changesMap = new IntegerMap();
    private final IntegerMap linesMap = new IntegerMap();

    public DirectoriesTableReport(Repository content) {
        this.content = content;
    }

    public void calculate() {
        Iterator it = this.content.getRevisions().iterator();
        while (it.hasNext()) {
            Revision rev = (Revision)it.next();
            Directory dir = rev.getFile().getDirectory();
            this.changesMap.addInt(dir, 1);
            if (rev.isBeginOfLog()) {
                this.linesMap.addInt(dir, rev.getLines());
                continue;
            }
            this.linesMap.addInt(dir, rev.getLinesDelta());
        }
        this.table = new Table(Messages.getString("DIRECTORIES_TABLE_SUMMARY"));
        IntegerColumn changes = new IntegerColumn(Messages.getString("COLUMN_CHANGES"));
        IntegerColumn linesOfCode = new IntegerColumn(Messages.getString("COLUMN_LOC"));
        DirectoryColumn keys = new DirectoryColumn();
        keys.setTotal(Messages.getString("TOTALS"));
        changes.setShowPercentages(true);
        linesOfCode.setShowPercentages(true);
        this.table.addColumn(keys);
        this.table.addColumn(changes);
        this.table.addColumn(linesOfCode);
        this.table.setKeysInFirstColumn(true);
        it = this.linesMap.iteratorSortedByValueReverse();
        while (it.hasNext()) {
            Object key = it.next();
            keys.addValue(key);
            changes.addValue(this.changesMap.get(key));
            linesOfCode.addValue(this.linesMap.get(key));
        }
        if (this.table.getRowCount() > 1) {
            this.table.setShowTotals(true);
        }
    }

    public Table getTable() {
        return this.table;
    }
}

