/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reports;

import java.util.Iterator;
import java.util.SortedSet;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Revision;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.reportmodel.TimeLine;

public class FileCountTimeLineReport {
    private final TimeLine timeLine = new TimeLine(Messages.getString("FILE_COUNT_TITLE"), Messages.getString("RANGE_FILES"));

    public FileCountTimeLineReport(SortedSet files) {
        this.timeLine.setInitialValue(0);
        Iterator filesIt = files.iterator();
        while (filesIt.hasNext()) {
            VersionedFile file = (VersionedFile)filesIt.next();
            this.addRevisions(file);
        }
    }

    public TimeLine getTimeLine() {
        return this.timeLine;
    }

    private void addRevisions(VersionedFile file) {
        Iterator it = file.getRevisions().iterator();
        while (it.hasNext()) {
            Revision revision = (Revision)it.next();
            if (revision.getFileCountDelta() == 0 && it.hasNext()) continue;
            this.timeLine.addChange(revision.getDate(), revision.getFileCountDelta());
        }
    }
}

