/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.VersionedFile;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.reportmodel.FileColumn;
import net.sf.statcvs.reportmodel.IntegerColumn;
import net.sf.statcvs.reportmodel.Table;
import net.sf.statcvs.reports.FilesLocComparator;
import net.sf.statcvs.reports.TableReport;

public class LargestFilesTableReport
implements TableReport {
    private final ReportConfig config;
    private final List files;
    private Table table;
    private final int maxRows;

    public LargestFilesTableReport(ReportConfig config, SortedSet files, int maxRows) {
        this.config = config;
        this.files = new ArrayList(files);
        this.maxRows = maxRows;
    }

    public void calculate() {
        Collections.sort(this.files, new FilesLocComparator());
        this.table = new Table(Messages.getString("LARGEST_FILES_TABLE_SUMMARY"));
        this.table.setKeysInFirstColumn(true);
        FileColumn filesCol = new FileColumn();
        filesCol.setWithIcon(true);
        filesCol.setWebRepository(this.config.getWebRepository());
        IntegerColumn locCol = new IntegerColumn(Messages.getString("COLUMN_LOC"));
        locCol.setShowPercentages(false);
        this.table.addColumn(filesCol);
        this.table.addColumn(locCol);
        int lines = 0;
        Iterator it = this.files.iterator();
        while (it.hasNext() && lines < this.maxRows) {
            VersionedFile file = (VersionedFile)it.next();
            if (file.isDead()) continue;
            filesCol.addValue(file);
            locCol.addValue(file.getCurrentLinesOfCode());
            ++lines;
        }
    }

    public Table getTable() {
        return this.table;
    }
}

