/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.reports;

import java.util.Iterator;
import net.sf.statcvs.Messages;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.reportmodel.AuthorColumn;
import net.sf.statcvs.reportmodel.IntegerColumn;
import net.sf.statcvs.reportmodel.Table;
import net.sf.statcvs.reports.AbstractLocTableReport;
import net.sf.statcvs.reports.TableReport;

public class TopDevelopersTableReport
extends AbstractLocTableReport
implements TableReport {
    private Table table = null;

    public TopDevelopersTableReport(ReportConfig config) {
        super(config);
    }

    public void calculate() {
        if (this.table != null) {
            return;
        }
        String summary = this.getDeveloperCount() > 10 ? Messages.getString("TOP_AUTHORS_TABLE_SUMMARY1") : Messages.getString("TOP_AUTHORS_TABLE_SUMMARY2");
        this.table = new Table(summary);
        AuthorColumn authors = new AuthorColumn();
        IntegerColumn linesOfCode = new IntegerColumn(Messages.getString("COLUMN_LOC"));
        linesOfCode.setShowPercentages(true);
        this.table.addColumn(authors);
        this.table.addColumn(linesOfCode);
        this.table.setKeysInFirstColumn(true);
        this.calculateChangesAndLinesPerDeveloper(this.getContent().getRevisions());
        int lines = 0;
        Iterator it = this.getLinesMap().iteratorSortedByValueReverse();
        while (it.hasNext()) {
            Author author = (Author)it.next();
            authors.addValue(author);
            linesOfCode.addValue(this.getLinesMap().get(author));
            if (++lines != 10) continue;
            break;
        }
        linesOfCode.setSum(this.getLinesMap().sum());
    }

    public Table getTable() {
        return this.table;
    }
}

