/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFile(String inputName, String destination) throws FileNotFoundException, IOException {
        File input = new File(inputName);
        File outputFile = new File(destination);
        FileReader in = null;
        FileWriter out = null;
        try {
            int c;
            in = new FileReader(input);
            out = new FileWriter(outputFile);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        try {
            if (in == null) return;
            in.close();
            return;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream in, File out) throws FileNotFoundException, IOException {
        InputStream fis = in;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(out);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) > 0) {
                fos.write(buf, 0, i);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                fis.close();
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
            throw throwable;
        }
        try {
            fis.close();
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static String getFilenameWithoutPath(String filename) {
        File f = new File(filename);
        return f.getName();
    }

    public static String getDirSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getDefaultDirSeparator() {
        return File.separator;
    }

    public static String getPathWithoutEndingSlash(String path) {
        if (path.endsWith(FileUtils.getDefaultDirSeparator())) {
            int pos = path.lastIndexOf(FileUtils.getDefaultDirSeparator());
            return path.substring(0, pos);
        }
        return path;
    }

    public static String getAbsoluteName(String path, String filename) {
        return path + FileUtils.getDirSeparator() + filename;
    }

    public static String getDirectoryName(String path) {
        if ("".equals(path)) {
            throw new IllegalArgumentException("can't get directory name for root");
        }
        String pathWithoutLastSlash = path.substring(0, path.length() - 1);
        int lastSlash = pathWithoutLastSlash.lastIndexOf(47);
        if (lastSlash == -1) {
            return pathWithoutLastSlash;
        }
        return pathWithoutLastSlash.substring(lastSlash + 1);
    }

    public static String getParentDirectoryPath(String path) {
        if ("".equals(path)) {
            throw new IllegalArgumentException("can't get directory name for root");
        }
        String pathWithoutLastSlash = path.substring(0, path.length() - 1);
        int lastSlash = pathWithoutLastSlash.lastIndexOf(47);
        if (lastSlash == -1) {
            return "";
        }
        return pathWithoutLastSlash.substring(0, lastSlash + 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readTextFromURL(String urlTxt) {
        StringBuffer buf = new StringBuffer();
        BufferedReader in = null;
        try {
            try {
                String str;
                URL url = new URL(urlTxt);
                in = new BufferedReader(new InputStreamReader(url.openStream()));
                while ((str = in.readLine()) != null) {
                    buf.append(str);
                }
                Object var6_7 = null;
                if (in == null) return buf.toString();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Mal-Formed URL " + urlTxt);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't get file " + urlTxt);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        in.close();
        return buf.toString();
    }
}

