/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkEventMotion;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    String text;
    TextLayout layout;
    Color linkColor;
    Color linkDisabledColor;
    Point[] offsets;
    Point selection;
    String[] ids;
    int[] mnemonics;
    int focusIndex;
    static final RGB LINK_FOREGROUND = new RGB(0, 51, 153);
    static final RGB LINK_DISABLED_FOREGROUND = new RGB(172, 168, 153);

    public Link(Composite parent, int style) {
        super(parent, style);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int height;
        int width;
        Rectangle rect;
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int layoutWidth = this.layout.getWidth();
        if (wHint == 0) {
            this.layout.setWidth(1);
            rect = this.layout.getBounds();
            width = 0;
            height = rect.height;
        } else {
            this.layout.setWidth(wHint);
            rect = this.layout.getBounds();
            width = rect.width;
            height = rect.height;
        }
        this.layout.setWidth(layoutWidth);
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    void createHandle(int index) {
        this.state |= 8;
        this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.handle == 0L) {
            SWT.error(2);
        }
        OS.gtk_fixed_set_has_window(this.handle, true);
        OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        this.layout = new TextLayout(this.display);
        this.linkColor = new Color(this.display, LINK_FOREGROUND);
        this.linkDisabledColor = new Color(this.display, LINK_DISABLED_FOREGROUND);
        this.offsets = new Point[0];
        this.ids = new String[0];
        this.mnemonics = new int[0];
        this.selection = new Point(-1, -1);
        this.focusIndex = -1;
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.layout.setFont(this.getFont());
        this.text = "";
        this.initAccessible();
    }

    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        if (this.isDisposed()) {
            return;
        }
        TextStyle linkStyle = new TextStyle(null, enabled ? this.linkColor : this.linkDisabledColor, null);
        linkStyle.underline = true;
        int i = 0;
        while (i < this.offsets.length) {
            Point point = this.offsets[i];
            this.layout.setStyle(linkStyle, point.x, point.y);
            ++i;
        }
        this.redraw();
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Link.this.parse(Link.this.text);
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                e.childID = -1;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle rect = Link.this.display.map((Control)Link.this.getParent(), null, Link.this.getBounds());
                e.x = rect.x;
                e.y = rect.y;
                e.width = rect.width;
                e.height = rect.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 30;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x100000;
                if (Link.this.hasFocus()) {
                    e.detail |= 4;
                }
            }

            public void getDefaultAction(AccessibleControlEvent e) {
                e.result = SWT.getMessage("SWT_Press");
            }

            public void getSelection(AccessibleControlEvent e) {
                if (Link.this.hasFocus()) {
                    e.childID = -1;
                }
            }

            public void getFocus(AccessibleControlEvent e) {
                if (Link.this.hasFocus()) {
                    e.childID = -1;
                }
            }
        });
    }

    String getNameText() {
        return this.getText();
    }

    Rectangle[] getRectangles(int linkIndex) {
        int lineCount = this.layout.getLineCount();
        Rectangle[] rects = new Rectangle[lineCount];
        int[] lineOffsets = this.layout.getLineOffsets();
        Point point = this.offsets[linkIndex];
        int lineStart = 1;
        while (point.x > lineOffsets[lineStart]) {
            ++lineStart;
        }
        int lineEnd = 1;
        while (point.y > lineOffsets[lineEnd]) {
            ++lineEnd;
        }
        int index = 0;
        if (lineStart == lineEnd) {
            rects[index++] = this.layout.getBounds(point.x, point.y);
        } else {
            rects[index++] = this.layout.getBounds(point.x, lineOffsets[lineStart] - 1);
            rects[index++] = this.layout.getBounds(lineOffsets[lineEnd - 1], point.y);
            if (lineEnd - lineStart > 1) {
                int i = lineStart;
                while (i < lineEnd - 1) {
                    rects[index++] = this.layout.getLineBounds(i);
                    ++i;
                }
            }
        }
        if (rects.length != index) {
            Rectangle[] tmp = new Rectangle[index];
            System.arraycopy(rects, 0, tmp, 0, index);
            rects = tmp;
        }
        return rects;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    long gtk_button_press_event(long widget, long event) {
        long result = super.gtk_button_press_event(widget, event);
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
        if (gdkEvent.button == 1 && gdkEvent.type == 4) {
            if (this.focusIndex != -1) {
                this.setFocus();
            }
            int x = (int)gdkEvent.x;
            int y = (int)gdkEvent.y;
            int offset = this.layout.getOffset(x, y, null);
            int oldSelectionX = this.selection.x;
            int oldSelectionY = this.selection.y;
            this.selection.x = offset;
            this.selection.y = -1;
            if (oldSelectionX != -1 && oldSelectionY != -1) {
                if (oldSelectionX > oldSelectionY) {
                    int temp = oldSelectionX;
                    oldSelectionX = oldSelectionY;
                    oldSelectionY = temp;
                }
                Rectangle rect = this.layout.getBounds(oldSelectionX, oldSelectionY);
                this.redraw(rect.x, rect.y, rect.width, rect.height, false);
            }
            int j = 0;
            while (j < this.offsets.length) {
                Rectangle[] rects = this.getRectangles(j);
                int i = 0;
                while (i < rects.length) {
                    Rectangle rect = rects[i];
                    if (rect.contains(x, y)) {
                        this.focusIndex = j;
                        this.redraw();
                        return result;
                    }
                    ++i;
                }
                ++j;
            }
        }
        return result;
    }

    long gtk_button_release_event(long widget, long event) {
        long result = super.gtk_button_release_event(widget, event);
        if (this.focusIndex == -1) {
            return result;
        }
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
        if (gdkEvent.button == 1) {
            int x = (int)gdkEvent.x;
            int y = (int)gdkEvent.y;
            Rectangle[] rects = this.getRectangles(this.focusIndex);
            int i = 0;
            while (i < rects.length) {
                Rectangle rect = rects[i];
                if (rect.contains(x, y)) {
                    Event ev = new Event();
                    ev.text = this.ids[this.focusIndex];
                    this.sendEvent(13, ev);
                    return result;
                }
                ++i;
            }
        }
        return result;
    }

    long gtk_event_after(long widget, long gdkEvent) {
        long result = super.gtk_event_after(widget, gdkEvent);
        GdkEvent event = new GdkEvent();
        OS.memmove(event, gdkEvent, (long)GdkEvent.sizeof);
        switch (event.type) {
            case 12: {
                this.redraw();
            }
        }
        return result;
    }

    long gtk_expose_event(long widget, long eventPtr) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        GdkEventExpose gdkEvent = new GdkEventExpose();
        OS.memmove(gdkEvent, eventPtr, (long)GdkEventExpose.sizeof);
        GCData data = new GCData();
        data.damageRgn = gdkEvent.region;
        GC gc = GC.gtk_new(this, data);
        OS.gdk_gc_set_clip_region(gc.handle, gdkEvent.region);
        int selStart = this.selection.x;
        int selEnd = this.selection.y;
        if (selStart > selEnd) {
            selStart = this.selection.y;
            selEnd = this.selection.x;
        }
        selEnd = -1;
        selStart = -1;
        this.layout.draw(gc, 0, 0, selStart, selEnd, null, null);
        if (this.hasFocus() && this.focusIndex != -1) {
            Rectangle[] rects = this.getRectangles(this.focusIndex);
            int i = 0;
            while (i < rects.length) {
                Rectangle rect = rects[i];
                gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
                ++i;
            }
        }
        if (this.hooks(9) || this.filters(9)) {
            Event event = new Event();
            event.count = gdkEvent.count;
            event.x = gdkEvent.area_x;
            event.y = gdkEvent.area_y;
            event.width = gdkEvent.area_width;
            event.height = gdkEvent.area_height;
            event.gc = gc;
            this.sendEvent(9, event);
            event.gc = null;
        }
        gc.dispose();
        return 0L;
    }

    long gtk_key_press_event(long widget, long eventPtr) {
        long result = super.gtk_key_press_event(widget, eventPtr);
        if (result != 0L) {
            return result;
        }
        if (this.focusIndex == -1) {
            return result;
        }
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove(gdkEvent, eventPtr, (long)GdkEventKey.sizeof);
        switch (gdkEvent.keyval) {
            case 32: 
            case 65293: 
            case 65421: {
                Event event = new Event();
                event.text = this.ids[this.focusIndex];
                this.sendEvent(13, event);
                break;
            }
            case 65289: {
                if (this.focusIndex >= this.offsets.length - 1) break;
                ++this.focusIndex;
                this.redraw();
                break;
            }
            case 65056: {
                if (this.focusIndex <= 0) break;
                --this.focusIndex;
                this.redraw();
            }
        }
        return result;
    }

    long gtk_motion_notify_event(long widget, long event) {
        long result = super.gtk_motion_notify_event(widget, event);
        GdkEventMotion gdkEvent = new GdkEventMotion();
        OS.memmove(gdkEvent, event, (long)GdkEventMotion.sizeof);
        int x = (int)gdkEvent.x;
        int y = (int)gdkEvent.y;
        if ((gdkEvent.state & 0x100) != 0) {
            int oldSelection = this.selection.y;
            this.selection.y = this.layout.getOffset(x, y, null);
            if (this.selection.y != oldSelection) {
                int newSelection = this.selection.y;
                if (oldSelection > newSelection) {
                    int temp = oldSelection;
                    oldSelection = newSelection;
                    newSelection = temp;
                }
                Rectangle rect = this.layout.getBounds(oldSelection, newSelection);
                this.redraw(rect.x, rect.y, rect.width, rect.height, false);
            }
        } else {
            int j = 0;
            while (j < this.offsets.length) {
                Rectangle[] rects = this.getRectangles(j);
                int i = 0;
                while (i < rects.length) {
                    Rectangle rect = rects[i];
                    if (rect.contains(x, y)) {
                        this.setCursor(this.display.getSystemCursor(21));
                        return result;
                    }
                    ++i;
                }
                ++j;
            }
            this.setCursor(null);
        }
        return result;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.layout != null) {
            this.layout.dispose();
        }
        this.layout = null;
        if (this.linkColor != null) {
            this.linkColor.dispose();
        }
        this.linkColor = null;
        if (this.linkDisabledColor != null) {
            this.linkDisabledColor.dispose();
        }
        this.linkDisabledColor = null;
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    String parse(String string) {
        int length = string.length();
        this.offsets = new Point[length / 4];
        this.ids = new String[length / 4];
        this.mnemonics = new int[length / 4 + 1];
        StringBuffer result = new StringBuffer();
        char[] buffer = new char[length];
        string.getChars(0, string.length(), buffer, 0);
        int index = 0;
        int state = 0;
        int linkIndex = 0;
        int start = 0;
        int tagStart = 0;
        int linkStart = 0;
        int endtagStart = 0;
        int refStart = 0;
        while (index < length) {
            char c = Character.toLowerCase(buffer[index]);
            block0 : switch (state) {
                case 0: {
                    if (c != '<') break;
                    tagStart = index;
                    ++state;
                    break;
                }
                case 1: {
                    if (c != 'a') break;
                    ++state;
                    break;
                }
                case 2: {
                    switch (c) {
                        case 'h': {
                            state = 7;
                            break block0;
                        }
                        case '>': {
                            linkStart = index + 1;
                            ++state;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(c)) break;
                    state = 13;
                    break;
                }
                case 3: {
                    if (c != '<') break;
                    endtagStart = index;
                    ++state;
                    break;
                }
                case 4: {
                    state = c == '/' ? state + 1 : 3;
                    break;
                }
                case 5: {
                    state = c == 'a' ? state + 1 : 3;
                    break;
                }
                case 6: {
                    if (c == '>') {
                        this.mnemonics[linkIndex] = this.parseMnemonics(buffer, start, tagStart, result);
                        int offset = result.length();
                        this.parseMnemonics(buffer, linkStart, endtagStart, result);
                        this.offsets[linkIndex] = new Point(offset, result.length() - 1);
                        if (this.ids[linkIndex] == null) {
                            this.ids[linkIndex] = new String(buffer, linkStart, endtagStart - linkStart);
                        }
                        ++linkIndex;
                        endtagStart = refStart = index + 1;
                        linkStart = refStart;
                        tagStart = refStart;
                        start = refStart;
                        state = 0;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 7: {
                    state = c == 'r' ? state + 1 : 0;
                    break;
                }
                case 8: {
                    state = c == 'e' ? state + 1 : 0;
                    break;
                }
                case 9: {
                    state = c == 'f' ? state + 1 : 0;
                    break;
                }
                case 10: {
                    state = c == '=' ? state + 1 : 0;
                    break;
                }
                case 11: {
                    if (c == '\"') {
                        ++state;
                        refStart = index + 1;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 12: {
                    if (c != '\"') break;
                    this.ids[linkIndex] = new String(buffer, refStart, index - refStart);
                    state = 2;
                    break;
                }
                case 13: {
                    if (Character.isWhitespace(c)) {
                        state = 0;
                        break;
                    }
                    if (c != '=') break;
                    ++state;
                    break;
                }
                case 14: {
                    state = c == '\"' ? state + 1 : 0;
                    break;
                }
                case 15: {
                    if (c != '\"') break;
                    state = 2;
                    break;
                }
                default: {
                    state = 0;
                }
            }
            ++index;
        }
        if (start < length) {
            int tmp = this.parseMnemonics(buffer, start, tagStart, result);
            int mnemonic = this.parseMnemonics(buffer, linkStart, index, result);
            if (mnemonic == -1) {
                mnemonic = tmp;
            }
            this.mnemonics[linkIndex] = mnemonic;
        } else {
            this.mnemonics[linkIndex] = -1;
        }
        if (this.offsets.length != linkIndex) {
            Point[] newOffsets = new Point[linkIndex];
            System.arraycopy(this.offsets, 0, newOffsets, 0, linkIndex);
            this.offsets = newOffsets;
            String[] newIDs = new String[linkIndex];
            System.arraycopy(this.ids, 0, newIDs, 0, linkIndex);
            this.ids = newIDs;
            int[] newMnemonics = new int[linkIndex + 1];
            System.arraycopy(this.mnemonics, 0, newMnemonics, 0, linkIndex + 1);
            this.mnemonics = newMnemonics;
        }
        return result.toString();
    }

    int parseMnemonics(char[] buffer, int start, int end, StringBuffer result) {
        int mnemonic = -1;
        int index = start;
        while (index < end) {
            if (buffer[index] == '&') {
                if (index + 1 < end && buffer[index + 1] == '&') {
                    result.append(buffer[index]);
                    ++index;
                } else {
                    mnemonic = result.length();
                }
            } else {
                result.append(buffer[index]);
            }
            ++index;
        }
        return mnemonic;
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result = super.setBounds(x, y, width, height, move, resize);
        if ((result & 0x100) != 0) {
            this.layout.setWidth(width > 0 ? width : -1);
            this.redraw();
        }
        return result;
    }

    void setFontDescription(long font) {
        super.setFontDescription(font);
        this.layout.setFont(Font.gtk_new(this.display, font));
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        this.layout.setText(this.parse(string));
        this.focusIndex = this.offsets.length > 0 ? 0 : -1;
        this.selection.y = -1;
        this.selection.x = -1;
        boolean enabled = (this.state & 0x10) == 0;
        TextStyle linkStyle = new TextStyle(null, enabled ? this.linkColor : this.linkDisabledColor, null);
        linkStyle.underline = true;
        int i = 0;
        while (i < this.offsets.length) {
            Point point = this.offsets[i];
            this.layout.setStyle(linkStyle, point.x, point.y);
            ++i;
        }
        TextStyle mnemonicStyle = new TextStyle(null, null, null);
        mnemonicStyle.underline = true;
        int i2 = 0;
        while (i2 < this.mnemonics.length) {
            int mnemonic = this.mnemonics[i2];
            if (mnemonic != -1) {
                this.layout.setStyle(mnemonicStyle, mnemonic, mnemonic);
            }
            ++i2;
        }
        this.redraw();
    }

    int traversalCode(int key, GdkEventKey event) {
        if (this.offsets.length == 0) {
            return 0;
        }
        int bits = super.traversalCode(key, event);
        if (key == 65289 && this.focusIndex < this.offsets.length - 1) {
            return bits & 0xFFFFFFEF;
        }
        if (key == 65056 && this.focusIndex > 0) {
            return bits & 0xFFFFFFF7;
        }
        return bits;
    }
}

